/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.ui;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.SyntheticaAddonsPainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;

public class BasicDockingPainter
extends SyntheticaAddonsPainter {
    public static SyntheticaAddonsPainter getInstance() {
        SyntheticaAddonsPainter instance = (SyntheticaAddonsPainter)instances.get(BasicDockingPainter.getPainterClassName(null, BasicDockingPainter.class, (String)"Synthetica.DockingPainter"));
        if (instance == null) {
            instance = (SyntheticaAddonsPainter)BasicDockingPainter.getInstance(null, BasicDockingPainter.class, (String)"Synthetica.DockingPainter");
        }
        return instance;
    }

    public void paintDockingTitleBarBackground(JComponent c, SyntheticaState state, Graphics g, int x, int y, int w, int h) {
        Graphics2D g2 = this.prepareGraphics2D(null, g, x, y, false);
        int borderWidth = 1;
        float arc = this.scaleArc(4.0f);
        Shape shape = this.createTitleBarShape(0.0f, 0.0f, BasicDockingPainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)0.0f), BasicDockingPainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)1.0f), arc);
        if (state.isSet(SyntheticaState.State.SELECTED)) {
            g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, borderWidth), 0.0f, this.calcRelativeGradientPos(g2, h, -borderWidth), new float[]{0.0f, 0.5f, 0.75f, 1.0f}, new Color[]{new Color(0xE5EFFF), new Color(14543612), new Color(14017268), new Color(12571623)}));
        } else {
            g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, borderWidth), 0.0f, this.calcRelativeGradientPos(g2, h, -borderWidth), new float[]{0.0f, 0.5f, 0.75f, 1.0f}, new Color[]{new Color(0xF0F0F0), new Color(0xE7E7E7), new Color(0xE1E1E1), new Color(0xD2D2D2)}));
        }
        g2.fill(BasicDockingPainter.subtractStroke((Graphics2D)g2, (Shape)shape));
        this.restoreGraphics2D(g2);
        g2 = this.prepareGraphics2D(null, g, x, y, true);
        shape = this.createTitleBarShape(0.0f, 0.0f, BasicDockingPainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)0.0f), BasicDockingPainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)0.0f), arc);
        g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, 0.0f), 0.0f, this.calcRelativeGradientPos(g2, h - 1, 0.0f), new float[]{0.0f, 1.0f}, new Color[]{new Color(0xB2B2B2), new Color(0x808080)}));
        g2.draw(shape);
        g2.setPaint(this.createLinearGradientPaint(0.0f, this.calcRelativeGradientPos(g2, 0.0f, 0.0f), 0.0f, this.calcRelativeGradientPos(g2, h - 1, 0.0f), new float[]{0.0f, 1.0f}, new Color[]{new Color(Integer.MAX_VALUE, true), new Color(0x3FFFFFFF, true)}));
        shape = this.createTitleBarShape(this.calcRelativePos(g2, 0.0f, 1.0f), this.calcRelativePos(g2, 0.0f, 1.0f), BasicDockingPainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)-2.0f), BasicDockingPainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)-2.0f), this.calcRelativeArc(g2, arc, -2.0f));
        g2.draw(shape);
        this.restoreGraphics2D(g2);
    }

    public void paintDockingContentPaneBackground(JComponent c, SyntheticaState state, Graphics g, int x, int y, int w, int h) {
        Graphics2D g2 = (Graphics2D)g;
        Object antialiasing_old = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object strokeControl_old = g2.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        Paint paint_old = g2.getPaint();
        Stroke stroke_old = g2.getStroke();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setPaint(SyntheticaLookAndFeel.getColor((String)"JYDocking.contentPane.border.color", (Component)c));
        float strokeWidth = SyntheticaLookAndFeel.getInstance().getScaleFactor();
        double cx = (float)x + strokeWidth / 2.0f;
        double cy = (float)y + strokeWidth / 2.0f;
        g2.setStroke(new BasicStroke(strokeWidth));
        g2.translate(cx, cy);
        g2.draw(new Rectangle2D.Float(x, y, (float)w - strokeWidth, (float)h - strokeWidth));
        g2.translate(-cx, -cy);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasing_old);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, strokeControl_old);
        g2.setPaint(paint_old);
        g2.setStroke(stroke_old);
    }

    private Shape createTitleBarShape(float x, float y, float w, float h, float arc) {
        GeneralPath path = new GeneralPath();
        path.moveTo(x, y + h);
        path.lineTo(x, arc /= 2.0f);
        path.quadTo(x, y, x + arc, y);
        path.lineTo(x + w - arc, y);
        path.quadTo(x + w, y, x + w, y + arc);
        path.lineTo(x + w, y + h);
        return path;
    }

    public void paintDockingDockbarBackground(JComponent c, SyntheticaState state, Graphics g, int x, int y, int w, int h, int placement) {
        Point p1 = new Point();
        Point p2 = new Point();
        g.setColor(new Color(208, 208, 208));
        this.calcLinePoints(x, y, w, h, placement, false, p1, p2);
        g.drawLine(p1.x, p1.y, p2.x, p2.y);
        g.setColor(Color.WHITE);
        this.calcLinePoints(x, y, w, h, placement, true, p1, p2);
        g.drawLine(p1.x, p1.y, p2.x, p2.y);
    }

    public void paintDockingDockbarLabelBackground(JComponent c, SyntheticaState state, Graphics g, int x, int y, int w, int h, int placement) {
        Graphics2D g2 = this.prepareGraphics2D(null, g, x, y, true, true);
        g2.setPaint(SyntheticaLookAndFeel.getColor((String)"JYDocking.dockbarLabel.border.color", (Component)c, (Color)Color.LIGHT_GRAY));
        Shape shape = this.createDockbarLabelShape(x, y, w - 1, h - 1, 4.0f);
        g2.draw(shape);
        this.restoreGraphics2D(g2);
    }

    public void paintDockingSlidePanelBackground(JComponent c, SyntheticaState state, Graphics g, int x, int y, int w, int h, int placement) {
        this.paintDockingDockbarBackground(c, state, g, x, y, w, h, placement);
    }

    private void calcLinePoints(int x, int y, int w, int h, int placement, boolean innerLine, Point p1, Point p2) {
        p1.x = x;
        p1.y = y;
        p2.x = x--;
        p2.y = y;
        if (placement == 3) {
            if (innerLine) {
                ++p1.y;
                ++p2.y;
            }
            p2.x = x + w - 1;
        } else if (placement == 4) {
            if (innerLine) {
                ++p1.x;
                ++p2.x;
            }
            p2.y = y + h - 1;
        } else {
            if (innerLine) {
                // empty if block
            }
            p1.x = x + w - 1;
            p2.x = x + w - 1;
            p2.y = y + h - 1;
        }
    }

    private Shape createDockbarLabelShape(float x, float y, float w, float h, float arc) {
        return new RoundRectangle2D.Float(x, y, w, h, arc, arc);
    }
}

