/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Date;
import net.sf.mpxj.Rate;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;

public final class CostRateTableEntry
implements Comparable<CostRateTableEntry> {
    private final Date m_startDate;
    private final Date m_endDate;
    private final Rate m_standardRate;
    private final TimeUnit m_standardRateFormat;
    private final Rate m_overtimeRate;
    private final TimeUnit m_overtimeRateFormat;
    private final Number m_costPerUse;
    public static final CostRateTableEntry DEFAULT_ENTRY = new CostRateTableEntry();

    private CostRateTableEntry() {
        this(new Rate(0.0, TimeUnit.HOURS), TimeUnit.HOURS, new Rate(0.0, TimeUnit.HOURS), TimeUnit.HOURS, NumberHelper.DOUBLE_ZERO, DateHelper.START_DATE_NA, DateHelper.END_DATE_NA);
    }

    public CostRateTableEntry(Rate standardRate, TimeUnit standardRateFormat, Rate overtimeRate, TimeUnit overtimeRateFormat, Number costPerUse, Date startDate, Date endDate) {
        this.m_startDate = startDate;
        this.m_endDate = endDate;
        this.m_standardRate = standardRate;
        this.m_standardRateFormat = standardRateFormat;
        this.m_overtimeRate = overtimeRate;
        this.m_overtimeRateFormat = overtimeRateFormat;
        this.m_costPerUse = costPerUse;
    }

    public Date getStartDate() {
        return this.m_startDate;
    }

    public Date getEndDate() {
        return this.m_endDate;
    }

    public Rate getStandardRate() {
        return this.m_standardRate;
    }

    public TimeUnit getStandardRateFormat() {
        return this.m_standardRateFormat;
    }

    public Rate getOvertimeRate() {
        return this.m_overtimeRate;
    }

    public TimeUnit getOvertimeRateFormat() {
        return this.m_overtimeRateFormat;
    }

    public Number getCostPerUse() {
        return this.m_costPerUse;
    }

    @Override
    public int compareTo(CostRateTableEntry o) {
        return DateHelper.compare(this.m_endDate, o.m_endDate);
    }

    public String toString() {
        return "[CostRateTableEntry standardRate=" + this.m_standardRate + " overtimeRate=" + this.m_overtimeRate + " costPerUse=" + this.m_costPerUse + " startDate=" + this.m_startDate + " endDate=" + this.m_endDate + "]";
    }
}

