/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpd;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.mpd.MapRow;

final class ResultSetRow
extends MapRow {
    public ResultSetRow(ResultSet rs, Map<String, Integer> meta) throws SQLException {
        super(new HashMap<String, Object>());
        for (Map.Entry<String, Integer> entry : meta.entrySet()) {
            Object value;
            String name = entry.getKey();
            int type = entry.getValue();
            switch (type) {
                case -7: 
                case 16: {
                    value = rs.getBoolean(name);
                    break;
                }
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    value = rs.getString(name);
                    break;
                }
                case 91: {
                    value = rs.getDate(name);
                    break;
                }
                case 93: {
                    Timestamp ts = rs.getTimestamp(name);
                    if (ts != null) {
                        value = new Date(ts.getTime());
                        break;
                    }
                    value = null;
                    break;
                }
                case 2: 
                case 8: {
                    value = NumberHelper.getDouble(rs.getDouble(name));
                    break;
                }
                case 4: 
                case 5: {
                    value = rs.getInt(name);
                    break;
                }
                case -5: {
                    value = rs.getLong(name);
                    break;
                }
                case -4: 
                case -3: {
                    value = rs.getBytes(name);
                    break;
                }
                case -8: 
                case 1111: {
                    value = rs.getObject(name);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported SQL type: " + type + " for column " + name);
                }
            }
            if (rs.wasNull()) {
                value = null;
            }
            this.m_map.put(name, value);
        }
    }
}

