/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.LegacyCheckBoxTree;
import com.jidesoft.swing.LegacyCheckBoxTreeSelectionModel;
import com.jidesoft.swing.LegacyTristateCheckBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class LegacyCheckBoxTreeCellRenderer
extends JPanel
implements TreeCellRenderer,
Serializable {
    private static final long serialVersionUID = 30207434500313004L;
    protected LegacyTristateCheckBox _checkBox = null;
    protected JComponent _emptyBox = null;
    protected JCheckBox _protoType = new LegacyTristateCheckBox();
    protected TreeCellRenderer _actualTreeRenderer;

    public LegacyCheckBoxTreeCellRenderer() {
        this((TreeCellRenderer)null);
    }

    public LegacyCheckBoxTreeCellRenderer(TreeCellRenderer treeCellRenderer) {
        this(treeCellRenderer, null);
    }

    public LegacyCheckBoxTreeCellRenderer(TreeCellRenderer treeCellRenderer, LegacyTristateCheckBox legacyTristateCheckBox) {
        this._checkBox = legacyTristateCheckBox == null ? this.createCheckBox() : legacyTristateCheckBox;
        this._emptyBox = (JComponent)Box.createHorizontalStrut(this._protoType.getPreferredSize().width);
        this.setLayout(new BorderLayout(0, 0));
        this.setOpaque(false);
        this._actualTreeRenderer = treeCellRenderer;
    }

    protected LegacyTristateCheckBox createCheckBox() {
        LegacyTristateCheckBox legacyTristateCheckBox = new LegacyTristateCheckBox();
        legacyTristateCheckBox.setOpaque(false);
        return legacyTristateCheckBox;
    }

    public TreeCellRenderer getActualTreeRenderer() {
        return this._actualTreeRenderer;
    }

    public void setActualTreeRenderer(TreeCellRenderer treeCellRenderer) {
        this._actualTreeRenderer = treeCellRenderer;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Serializable serializable;
        this.removeAll();
        this._checkBox.setPreferredSize(new Dimension(this._protoType.getPreferredSize().width, 0));
        this._emptyBox.setPreferredSize(new Dimension(this._protoType.getPreferredSize().width, 0));
        this.applyComponentOrientation(jTree.getComponentOrientation());
        TreePath treePath = jTree.getPathForRow(n);
        if (treePath != null && jTree instanceof LegacyCheckBoxTree && (serializable = ((LegacyCheckBoxTree)jTree).getCheckBoxTreeSelectionModel()) != null) {
            boolean bl5;
            boolean bl6 = bl5 = jTree.isEnabled() && ((LegacyCheckBoxTree)jTree).isCheckBoxEnabled() && ((LegacyCheckBoxTree)jTree).isCheckBoxEnabled(treePath);
            if (!bl5 && !bl && this.getBackground() != null) {
                this.setForeground(this.getBackground().darker());
            }
            this._checkBox.setEnabled(bl5);
            this.updateCheckBoxState(this._checkBox, treePath, (LegacyCheckBoxTreeSelectionModel)serializable);
        }
        if (this._actualTreeRenderer != null) {
            serializable = (JComponent)this._actualTreeRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Border border = ((JComponent)serializable).getBorder();
            this.setBorder(border);
            ((JComponent)serializable).setBorder(BorderFactory.createEmptyBorder());
            if (treePath == null || !(jTree instanceof LegacyCheckBoxTree) || ((LegacyCheckBoxTree)jTree).isCheckBoxVisible(treePath)) {
                this.remove(this._emptyBox);
                this.add((Component)this._checkBox, "Before");
            } else {
                this.remove(this._checkBox);
                this.add((Component)this._emptyBox, "After");
            }
            this.add((Component)serializable);
        }
        return this;
    }

    protected void updateCheckBoxState(LegacyTristateCheckBox legacyTristateCheckBox, TreePath treePath, LegacyCheckBoxTreeSelectionModel legacyCheckBoxTreeSelectionModel) {
        if (legacyCheckBoxTreeSelectionModel.isPathSelected(treePath, legacyCheckBoxTreeSelectionModel.isDigIn())) {
            legacyTristateCheckBox.setState(LegacyTristateCheckBox.SELECTED);
        } else {
            legacyTristateCheckBox.setState((LegacyTristateCheckBox.State)(legacyCheckBoxTreeSelectionModel.isDigIn() && legacyCheckBoxTreeSelectionModel.isPartiallySelected(treePath) ? null : LegacyTristateCheckBox.NOT_SELECTED));
        }
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (this._actualTreeRenderer instanceof JComponent) {
            Point point = mouseEvent.getPoint();
            point.translate(-this._checkBox.getWidth(), 0);
            MouseEvent mouseEvent2 = new MouseEvent((JComponent)((Object)this._actualTreeRenderer), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            String string = ((JComponent)((Object)this._actualTreeRenderer)).getToolTipText(mouseEvent2);
            if (string != null) {
                return string;
            }
        }
        return super.getToolTipText(mouseEvent);
    }
}

