/*
 * Decompiled with CFR 0.152.
 */
package org.json.zip;

import java.io.IOException;
import java.io.InputStream;
import org.json.zip.BitReader;

public class BitInputStream
implements BitReader {
    static final int[] mask = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255};
    private int available = 0;
    private int unread = 0;
    private InputStream in;
    private long nrBits = 0L;

    public BitInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public BitInputStream(InputStream inputStream, int n) {
        this.in = inputStream;
        this.unread = n;
        this.available = 8;
    }

    public boolean bit() throws IOException {
        return this.read(1) != 0;
    }

    public long nrBits() {
        return this.nrBits;
    }

    public boolean pad(int n) throws IOException {
        int n2 = n - (int)(this.nrBits % (long)n);
        boolean bl = true;
        for (int i = 0; i < n2; ++i) {
            if (!this.bit()) continue;
            bl = false;
        }
        return bl;
    }

    public int read(int n) throws IOException {
        if (n == 0) {
            return 0;
        }
        if (n < 0 || n > 32) {
            throw new IOException("Bad read width.");
        }
        int n2 = 0;
        while (n > 0) {
            int n3;
            if (this.available == 0) {
                this.unread = this.in.read();
                if (this.unread < 0) {
                    throw new IOException("Attempt to read past end.");
                }
                this.available = 8;
            }
            if ((n3 = n) > this.available) {
                n3 = this.available;
            }
            n2 |= (this.unread >>> this.available - n3 & mask[n3]) << n - n3;
            this.nrBits += (long)n3;
            this.available -= n3;
            n -= n3;
        }
        return n2;
    }
}

