/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.geo.map;

import com.macrofocus.color.BtyColormapModel;
import com.macrofocus.color.ColormapModel;
import com.macrofocus.data.matrix.vector.VectorModel;
import com.macrofocus.geo.map.LayerModel;
import com.macrofocus.geo.map.LayerView;
import com.macrofocus.geo.map.Polygon;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;

public class NumericalPolygonRenderer
implements LayerView.PolygonRenderer {
    private ColormapModel colormapModel = new BtyColormapModel();
    private final VectorModel vector;
    private final double min;
    private final double max;
    private final double range;

    public NumericalPolygonRenderer(VectorModel vector, ColormapModel colormapModel, double min, double max) {
        this.vector = vector;
        this.colormapModel = colormapModel;
        this.min = min;
        this.max = max;
        this.range = max - min;
    }

    @Override
    public Color getColor(Polygon polygon, int row, LayerModel layerModel) {
        if (this.vector.isAvailable(row)) {
            double value = this.vector.getDouble(row);
            value = Math.max(value, this.min);
            value = Math.min(value, this.max);
            int entry = (int)((value - this.min) * (double)(this.colormapModel.getColorCount() - 1) / this.range);
            return this.colormapModel.getColor(entry);
        }
        return null;
    }

    @Override
    public void paint(Graphics2D g2, Polygon polygon, int row, LayerModel layerModel) {
        Shape shape = polygon.getShape();
        if (this.vector.isAvailable(row)) {
            g2.setColor(this.getColor(polygon, row, layerModel));
            g2.fill(shape);
            g2.setColor(new Color(191, 190, 191));
            g2.draw(shape);
        } else {
            g2.setColor(Color.lightGray);
            g2.fill(shape);
            g2.setColor(Color.black);
            g2.draw(shape);
        }
    }
}

