/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.geo.map;

import com.macrofocus.data.AbstractDataModel;
import com.macrofocus.data.DataModel;
import com.macrofocus.data.column.ColumnModel;
import com.macrofocus.geo.map.RelationModel;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SimpleRelationModel
extends AbstractDataModel
implements RelationModel {
    private ColumnModel primary;
    private ColumnModel secondary;
    private DataModel dataModel;
    private Map<Integer, List<Integer>> primaryToSecondary = new LinkedHashMap<Integer, List<Integer>>();
    private List<Integer> secondaryToPrimary;

    public SimpleRelationModel(ColumnModel primary, ColumnModel secondary, DataModel dataModel) {
        this.primary = primary;
        this.secondary = secondary;
        this.dataModel = dataModel;
        for (int pr = 0; pr < primary.getRowCount(); ++pr) {
            if (!primary.isAvailable(pr)) continue;
            Object po = primary.getObject(pr);
            for (int sr = 0; sr < secondary.getRowCount(); ++sr) {
                List<Object> list;
                Object so;
                if (!secondary.isAvailable(sr) || !po.equals(so = secondary.getObject(sr))) continue;
                if (this.primaryToSecondary.containsKey(pr)) {
                    list = this.primaryToSecondary.get(pr);
                } else {
                    list = new ArrayList();
                    this.primaryToSecondary.put(pr, list);
                }
                list.add(sr);
            }
        }
        this.secondaryToPrimary = new ArrayList<Integer>(secondary.getRowCount());
        for (int sec = 0; sec < secondary.getRowCount(); ++sec) {
            Integer found = null;
            if (secondary.isAvailable(sec)) {
                Object so = secondary.getObject(sec);
                for (int prim = 0; prim < primary.getRowCount(); ++prim) {
                    if (!primary.isAvailable(prim)) continue;
                    Object po = primary.getObject(prim);
                    if (po.equals(so)) {
                        found = prim;
                        break;
                    }
                    found = null;
                }
            }
            if (found != null) {
                this.secondaryToPrimary.add(found);
                continue;
            }
            this.secondaryToPrimary.add(null);
        }
    }

    public Class getColumnClass(int column) {
        return this.dataModel.getColumnClass(column);
    }

    public int getColumnCount() {
        return this.dataModel.getColumnCount();
    }

    public Object getColumnName(int column) {
        return this.dataModel.getColumnName(column);
    }

    public Object getValueAt(int row, int column) {
        return this.dataModel.getValueAt(this.secondaryToPrimary.get(row).intValue(), column);
    }

    public int getRowCount() {
        return this.secondaryToPrimary.size();
    }

    public boolean isAvailable(int row, int column) {
        if (this.secondaryToPrimary.get(row) != null) {
            return this.dataModel.isAvailable(this.secondaryToPrimary.get(row).intValue(), column);
        }
        return false;
    }

    @Override
    public int getPrimaryRow(int secondaryRow) {
        Integer value = this.secondaryToPrimary.get(secondaryRow);
        if (value != null) {
            return value;
        }
        return -1;
    }

    @Override
    public int getPrimaryRowCount() {
        return this.primary.getRowCount();
    }

    public ColumnModel getPrimary() {
        return this.primary;
    }

    public List<Integer> getSecondaryRow(int primaryRow) {
        List<Integer> value = this.primaryToSecondary.get(primaryRow);
        if (value != null) {
            return value;
        }
        return null;
    }

    public ColumnModel getSecondary() {
        return this.secondary;
    }
}

