/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.synthetica.simple2d;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.synth.SynthContext;

public class ArrowButtonPainter
extends de.javasoft.plaf.synthetica.painter.ArrowButtonPainter {
    public void paintArrowButtonBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintArrowButtonBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintArrowButtonForeground(SynthContext sc, Graphics g, int x, int y, int w, int h, int direction) {
        Color col;
        Graphics2D g2 = this.prepareGraphics2D(sc, g, x, y, true);
        Container parent = sc == null ? null : sc.getComponent().getParent();
        Color foreground = new Color(0x606060);
        if (parent instanceof JComponent && (col = this.getTableCellRendererArrowForeground((JComponent)parent)) != null) {
            foreground = col;
        }
        if (sc != null && (sc.getComponentState() & 4) > 0) {
            foreground = new Color(0xA0A0A0);
        } else if (sc != null && (sc.getComponentState() & 8) > 0) {
            foreground = new Color(0xBBBBBB);
        }
        Shape shape = null;
        if (parent instanceof JScrollBar) {
            int xOffset = direction == 1 || direction == 5 ? 2 : 4;
            int yOffset = direction == 1 || direction == 5 ? 4 : 2;
            float width = ArrowButtonPainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)(xOffset * -2));
            float height = ArrowButtonPainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)(yOffset * -2));
            shape = this.createShape(0.0f, 0.0f, width, height, direction);
            g2.translate(this.calcRelativePos(g2, 0.0f, xOffset), this.calcRelativePos(g2, 0.0f, yOffset));
        } else if (parent instanceof JComboBox) {
            shape = this.createShape(0.0f, 0.0f, ArrowButtonPainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)-5.0f), ArrowButtonPainter.calcRelativeLength((Graphics2D)g2, (float)4.0f, (float)this.getScale()), direction);
            g2.translate(this.calcRelativePos(g2, 0.0f, 3.0f), this.calcRelativePos(g2, h / 2, -2.0f));
        } else if (parent instanceof JTabbedPane) {
            shape = this.createShape(0.0f, 0.0f, ArrowButtonPainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)-9.0f), ArrowButtonPainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)-5.0f), direction);
            g2.translate(this.calcRelativePos(g2, 0.0f, 4.0f), this.calcRelativePos(g2, 0.0f, 2.0f));
        } else if (parent instanceof BasicSplitPaneDivider) {
            int xOffset = direction == 1 || direction == 5 ? 6 : 3;
            int yOffset = direction == 1 || direction == 5 ? 3 : 6;
            float width = ArrowButtonPainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)(xOffset * -2));
            float height = ArrowButtonPainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)(yOffset * -2));
            shape = this.createShape(0.0f, 0.0f, width, height, direction);
            g2.translate(this.calcRelativePos(g2, 0.0f, xOffset), this.calcRelativePos(g2, 0.0f, yOffset));
        } else if (parent instanceof JSpinner) {
            shape = this.createShape(0.0f, 0.0f, ArrowButtonPainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)-3.0f), ArrowButtonPainter.calcRelativeLength((Graphics2D)g2, (float)h, (float)-3.0f), direction);
            g2.translate(this.calcRelativePos(g2, 0.0f, 1.0f), this.calcRelativePos(g2, 0.0f, 1.0f));
        } else {
            shape = this.createShape(0.0f, 0.0f, ArrowButtonPainter.calcRelativeLength((Graphics2D)g2, (float)9.0f, (float)this.getScale()), ArrowButtonPainter.calcRelativeLength((Graphics2D)g2, (float)4.0f, (float)this.getScale()), direction);
        }
        g2.setPaint(foreground);
        g2.fill(shape);
        g2.draw(shape);
        this.restoreGraphics2D(g2);
    }

    private Shape createShape(float x, float y, float w, float h, int direction) {
        GeneralPath path = new GeneralPath();
        switch (direction) {
            case 1: {
                path.moveTo(x + w / 2.0f, y);
                path.lineTo(x + w, y + h);
                path.lineTo(x, y + h);
                break;
            }
            case 5: {
                path.moveTo(x, y);
                path.lineTo(x + w / 2.0f, y + h);
                path.lineTo(x + w, y);
                break;
            }
            case 3: {
                path.moveTo(x, y);
                path.lineTo(x + w, y + h / 2.0f);
                path.lineTo(x, y + h);
                break;
            }
            case 7: {
                path.moveTo(x + w, y);
                path.lineTo(x, y + h / 2.0f);
                path.lineTo(x + w, y + h);
            }
        }
        path.closePath();
        return path;
    }

    private Color getTableCellRendererArrowForeground(JComponent c) {
        return (Color)c.getClientProperty("Synthetica.table.cellRenderer.arrowButton.foreground");
    }

    public int getCacheHash(SynthContext sc, int w, int h, int meta, String id) {
        int hash = super.getCacheHash(sc, w, h, meta, id);
        Container parent = sc.getComponent().getParent();
        Color arrowForeground = parent instanceof JComponent ? this.getTableCellRendererArrowForeground((JComponent)parent) : null;
        hash = arrowForeground == null ? hash : hash * 31 + arrowForeground.getRGB();
        return hash;
    }
}

