/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.synthetica.simple2d;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.Line2D;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.plaf.synth.SynthContext;

public class SeparatorPainter
extends de.javasoft.plaf.synthetica.painter.SeparatorPainter {
    public void paintSeparatorBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JComponent c = sc.getComponent();
        if (c.getParent() instanceof JPopupMenu || c instanceof JPopupMenu.Separator) {
            Graphics2D g2 = this.prepareGraphics2D(sc, g, x, y, false);
            g2.setPaint(new Color(0xE7E7E7));
            g2.draw(this.createShape(this.calcRelativePos(g2, x, 0.0f), this.calcRelativePos(g2, y, 3.0f), this.calcRelativePos(g2, x + w, -1.0f), this.calcRelativePos(g2, y, 3.0f)));
            g2.setPaint(new Color(0xFFFFFF));
            g2.draw(this.createShape(this.calcRelativePos(g2, x, 0.0f), this.calcRelativePos(g2, y, 4.0f), this.calcRelativePos(g2, x + w, -1.0f), this.calcRelativePos(g2, y, 4.0f)));
            this.restoreGraphics2D(g2);
        }
    }

    public void paintSeparatorBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintSeparatorForeground(SynthContext sc, Graphics g, int x, int y, int w, int h, int orientation) {
        JComponent c = sc.getComponent();
        Graphics2D g2 = this.prepareGraphics2D(sc, g, x, y, false);
        Insets stInsets = sc.getStyle().getInsets(sc, null);
        Insets insets = c.getInsets();
        w -= insets.left + insets.right - stInsets.left - stInsets.right;
        h -= insets.top + insets.bottom - stInsets.top - stInsets.bottom;
        x += insets.left - stInsets.left;
        y += insets.top - stInsets.top;
        if (orientation == 1) {
            x += w / 2 - 1;
        } else {
            y += h / 2 - 1;
        }
        float x1 = this.calcRelativePos(g2, x, 0.0f);
        float y1 = this.calcRelativePos(g2, y, 0.0f);
        float x2 = orientation == 0 ? this.calcRelativePos(g2, x + w, -1.0f) : this.calcRelativePos(g2, x, 0.0f);
        float y2 = orientation == 0 ? this.calcRelativePos(g2, y, 0.0f) : this.calcRelativePos(g2, y + h, -1.0f);
        Shape shape = this.createShape(x1, y1, x2, y2);
        g2.setPaint(new Color(0x12000000, true));
        g2.draw(shape);
        x1 = orientation == 0 ? this.calcRelativePos(g2, x, 0.0f) : this.calcRelativePos(g2, x, 1.0f);
        y1 = orientation == 0 ? this.calcRelativePos(g2, y, 1.0f) : this.calcRelativePos(g2, y, 0.0f);
        x2 = orientation == 0 ? this.calcRelativePos(g2, x + w, -1.0f) : this.calcRelativePos(g2, x, 1.0f);
        y2 = orientation == 0 ? this.calcRelativePos(g2, y, 1.0f) : this.calcRelativePos(g2, y + h, -1.0f);
        shape = this.createShape(x1, y1, x2, y2);
        g2.setPaint(new Color(-1426063361, true));
        g2.draw(shape);
        if (c instanceof JToolBar.Separator) {
            Dimension dim = (Dimension)sc.getStyle().get(sc, "ToolBar.separatorSize");
            this.adjustToolBarSeparatorSize((JToolBar.Separator)c, (int)((float)dim.width * this.getScale()), (int)((float)dim.height * this.getScale()));
        }
        this.restoreGraphics2D(g2);
    }

    private Shape createShape(float x1, float y1, float x2, float y2) {
        return new Line2D.Float(x1, y1, x2, y2);
    }
}

