/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.button;

import com.macrofocus.button.ButtonAdapter;
import com.macrofocus.button.ButtonEvent;
import com.macrofocus.button.ButtonModel;
import com.macrofocus.button.ButtonView;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public abstract class AbstractButtonView
extends ButtonView {
    private boolean hasFocus = false;
    private boolean buttonDown = false;
    private ButtonModel buttonModel;

    public AbstractButtonView(final ButtonModel buttonModel) {
        this.buttonModel = buttonModel;
        this.setCursor(Cursor.getPredefinedCursor(12));
        buttonModel.addButtonListener(new ButtonAdapter(){

            @Override
            public void buttonStateChanged(ButtonEvent event) {
                AbstractButtonView.this.buttonDown = buttonModel.isStateOn();
                AbstractButtonView.this.hasFocus = false;
                AbstractButtonView.this.repaint();
            }

            @Override
            public void buttonEnabledChanged(ButtonEvent event) {
                if (buttonModel.isEnabled()) {
                    AbstractButtonView.this.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    AbstractButtonView.this.setCursor(Cursor.getPredefinedCursor(0));
                }
                AbstractButtonView.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent event) {
                if (buttonModel.isEnabled()) {
                    AbstractButtonView.this.hasFocus = true;
                    AbstractButtonView.this.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent event) {
                if (buttonModel.isEnabled()) {
                    AbstractButtonView.this.hasFocus = false;
                    AbstractButtonView.this.repaint();
                }
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        if (!this.buttonModel.isEnabled()) {
            this.hasFocus = false;
        }
        if (this.buttonDown) {
            this.drawButtonDown(g, this.hasFocus);
        } else {
            this.drawButtonUp(g, this.hasFocus);
        }
    }

    protected abstract void drawButtonUp(Graphics var1, boolean var2);

    protected abstract void drawButtonDown(Graphics var1, boolean var2);
}

