/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.layer;

import com.macrofocus.layer.ContainerLayerView;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

public class DoubleBufferLayerView
extends ContainerLayerView {
    private Image doubleBuffer;
    private Graphics doubleBufferGraphics = null;
    private boolean sizeChanged = false;

    public DoubleBufferLayerView() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                DoubleBufferLayerView.this.sizeChanged = true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        Rectangle cr = this.getBounds();
        Rectangle clip = g.getClipBounds();
        if (this.doubleBuffer == null || this.sizeChanged) {
            this.doubleBuffer = this.createImage(cr.width, cr.height);
            this.sizeChanged = false;
        }
        Graphics cg = this.doubleBuffer.getGraphics();
        if (clip != null) {
            cg.setColor(this.getBackground());
            cg.drawRect(clip.x, clip.y, clip.width, clip.height);
            cg.setClip(clip.x, clip.y, clip.width, clip.height);
        } else {
            cg.setColor(this.getBackground());
            cg.setClip(0, 0, cr.width, cr.height);
            cg.drawRect(0, 0, cr.width, cr.height);
        }
        try {
            super.paint(cg);
        }
        finally {
            cg.dispose();
        }
        g.drawImage(this.doubleBuffer, 0, 0, this);
    }
}

