/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.soom.coordinator;

import com.macrofocus.util.range.MBoundedRangeEvent;
import com.macrofocus.util.range.MBoundedRangeListener;
import com.macrofocus.util.range.MBoundedRangeModel;
import org.jdesktop.core.animation.timing.TimingTarget;

public class RangesCoordinateAxisCoordinator {
    private MBoundedRangeModel xRange;
    private MBoundedRangeModel yRange;
    boolean updating = false;
    final MBoundedRangeListener xRangeListener = new MBoundedRangeListener(){

        public void boundedRangeChanged(MBoundedRangeEvent event) {
            if (!(event.getSource() instanceof TimingTarget) && event.getWhat() == MBoundedRangeEvent.What.ValueExtent && !RangesCoordinateAxisCoordinator.this.updating) {
                RangesCoordinateAxisCoordinator.this.updating = true;
                if (RangesCoordinateAxisCoordinator.this.xRange.getValue() == RangesCoordinateAxisCoordinator.this.xRange.getMinimum() && RangesCoordinateAxisCoordinator.this.xRange.getExtent() == RangesCoordinateAxisCoordinator.this.xRange.getMaximum() - RangesCoordinateAxisCoordinator.this.xRange.getMinimum()) {
                    RangesCoordinateAxisCoordinator.this.resetValues(event.getSource(), RangesCoordinateAxisCoordinator.this.yRange);
                } else {
                    double xRangeRatio = RangesCoordinateAxisCoordinator.this.xRange.getExtent() / (RangesCoordinateAxisCoordinator.this.xRange.getMaximum() - RangesCoordinateAxisCoordinator.this.xRange.getMinimum());
                    double yDiff = RangesCoordinateAxisCoordinator.this.yRange.getExtent() - (RangesCoordinateAxisCoordinator.this.yRange.getMaximum() - RangesCoordinateAxisCoordinator.this.yRange.getMinimum()) * xRangeRatio;
                    RangesCoordinateAxisCoordinator.this.adjustValues(event.getSource(), RangesCoordinateAxisCoordinator.this.yRange, yDiff);
                }
                RangesCoordinateAxisCoordinator.this.updating = false;
            }
        }
    };
    final MBoundedRangeListener yRangeListener = new MBoundedRangeListener(){

        public void boundedRangeChanged(MBoundedRangeEvent event) {
            if (!(event.getSource() instanceof TimingTarget) && event.getWhat() == MBoundedRangeEvent.What.ValueExtent && !RangesCoordinateAxisCoordinator.this.updating) {
                RangesCoordinateAxisCoordinator.this.updating = true;
                if (RangesCoordinateAxisCoordinator.this.yRange.getValue() == RangesCoordinateAxisCoordinator.this.yRange.getMinimum() && RangesCoordinateAxisCoordinator.this.yRange.getExtent() == RangesCoordinateAxisCoordinator.this.yRange.getMaximum() - RangesCoordinateAxisCoordinator.this.yRange.getMinimum()) {
                    RangesCoordinateAxisCoordinator.this.resetValues(event.getSource(), RangesCoordinateAxisCoordinator.this.xRange);
                } else {
                    double yRangeRatio = RangesCoordinateAxisCoordinator.this.yRange.getExtent() / (RangesCoordinateAxisCoordinator.this.yRange.getMaximum() - RangesCoordinateAxisCoordinator.this.yRange.getMinimum());
                    double xDiff = RangesCoordinateAxisCoordinator.this.xRange.getExtent() - (RangesCoordinateAxisCoordinator.this.xRange.getMaximum() - RangesCoordinateAxisCoordinator.this.xRange.getMinimum()) * yRangeRatio;
                    RangesCoordinateAxisCoordinator.this.adjustValues(event.getSource(), RangesCoordinateAxisCoordinator.this.xRange, xDiff);
                }
                RangesCoordinateAxisCoordinator.this.updating = false;
            }
        }
    };

    public RangesCoordinateAxisCoordinator(MBoundedRangeModel xRange, MBoundedRangeModel yRange) {
        this.xRange = xRange;
        this.yRange = yRange;
        xRange.addBoundedRangeListener(this.xRangeListener);
        yRange.addBoundedRangeListener(this.yRangeListener);
    }

    private void adjustValues(Object source, MBoundedRangeModel range, double diff) {
        double value = range.getValue() + diff / 2.0;
        double extent = range.getExtent() - diff;
        if (value < range.getMinimum()) {
            value = range.getMinimum();
        }
        if (value + extent > range.getMaximum()) {
            value = range.getMaximum() - extent;
        }
        range.setValue(source, value, extent);
    }

    private void resetValues(Object source, MBoundedRangeModel range) {
        range.setValue(source, range.getMinimum(), range.getMaximum() - range.getMinimum());
    }

    public void setRanges(MBoundedRangeModel xRange, MBoundedRangeModel yRange) {
        if (this.xRange != null) {
            this.xRange.removeBoundedRangeListener(this.xRangeListener);
        }
        this.xRange = xRange;
        this.xRange.addBoundedRangeListener(this.xRangeListener);
        if (this.yRange != null) {
            this.yRange.removeBoundedRangeListener(this.yRangeListener);
        }
        this.yRange = yRange;
        this.yRange.addBoundedRangeListener(this.yRangeListener);
        this.updating = true;
        this.updating = false;
    }
}

