/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing;

import com.macrofocus.util.file.FileHelper;
import com.macrofocus.util.file.filter.AbstractFileFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class MFileChooser
extends JFileChooser {
    public MFileChooser() {
        this.init();
    }

    public MFileChooser(String currentDirectoryPath) {
        super(currentDirectoryPath);
        this.init();
    }

    public MFileChooser(File currentDirectory) {
        super(currentDirectory);
        this.init();
    }

    public MFileChooser(FileSystemView fsv) {
        super(fsv);
        this.init();
    }

    public MFileChooser(File currentDirectory, FileSystemView fsv) {
        super(currentDirectory, fsv);
        this.init();
    }

    public MFileChooser(String currentDirectoryPath, FileSystemView fsv) {
        super(currentDirectoryPath, fsv);
        this.init();
    }

    private void init() {
        this.addPropertyChangeListener("fileFilterChanged", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BasicFileChooserUI fileChooserUI;
                String oldFileName;
                if (MFileChooser.this.getUI() instanceof BasicFileChooserUI && (oldFileName = (fileChooserUI = (BasicFileChooserUI)MFileChooser.this.getUI()).getFileName()) != null && oldFileName.trim().length() > 0) {
                    if (evt.getNewValue() == null || !(evt.getNewValue() instanceof AbstractFileFilter)) {
                        return;
                    }
                    AbstractFileFilter newValue = (AbstractFileFilter)evt.getNewValue();
                    String newExtension = newValue.getDefaultExtension();
                    fileChooserUI.setFileName(FileHelper.replaceSuffix((String)oldFileName, (String)newExtension));
                }
            }
        });
    }

    @Override
    public void updateUI() {
        super.updateUI();
    }
}

