/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.plaf;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.OceanTheme;

public class MacrofocusLightOceanMetalTheme
extends OceanTheme {
    private FontUIResource menuFont;
    private FontUIResource windowTitleFont;
    private FontUIResource monospacedFont;
    private FontUIResource controlFont;
    private FontUIResource systemFont;
    private FontUIResource userFont;
    private FontUIResource smallFont;

    @Override
    public String getName() {
        return "Macrofocus";
    }

    public MacrofocusLightOceanMetalTheme() {
        ImageIcon collapsedIcon = new ImageIcon(this.getClass().getResource("collapsed.gif"));
        ImageIcon expandedIcon = new ImageIcon(this.getClass().getResource("expanded.gif"));
        UIManager.put("Tree.expandedIcon", expandedIcon);
        UIManager.put("Tree.collapsedIcon", collapsedIcon);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontFamilies = graphicsEnvironment.getAvailableFontFamilyNames();
        HashSet<String> hashset = new HashSet<String>(Arrays.asList(fontFamilies));
        boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
        if (isWindows) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            this.controlFont = new FontUIResource((Font)toolkit.getDesktopProperty("win.defaultGUI.font"));
            this.systemFont = new FontUIResource((Font)toolkit.getDesktopProperty("win.tooltip.font"));
            this.userFont = new FontUIResource((Font)toolkit.getDesktopProperty("win.messagebox.font"));
            this.menuFont = new FontUIResource((Font)toolkit.getDesktopProperty("win.menu.font"));
            this.windowTitleFont = new FontUIResource((Font)toolkit.getDesktopProperty("win.defaultGUI.font"));
            this.smallFont = new FontUIResource((Font)toolkit.getDesktopProperty("win.status.font"));
        } else if (hashset.contains("Arial")) {
            this.menuFont = new FontUIResource("Arial", 1, 12);
            this.controlFont = new FontUIResource("Arial", 1, 11);
            this.systemFont = new FontUIResource("Arial", 0, 11);
            this.userFont = new FontUIResource("Arial", 0, 11);
            this.smallFont = new FontUIResource("Arial", 0, 9);
            this.windowTitleFont = new FontUIResource("Arial", 1, 12);
        } else if (hashset.contains("Helvetica")) {
            this.menuFont = new FontUIResource("Helvetica", 1, 12);
            this.controlFont = new FontUIResource("Helvetica", 1, 11);
            this.systemFont = new FontUIResource("Helvetica", 0, 11);
            this.userFont = new FontUIResource("Helvetica", 0, 11);
            this.smallFont = new FontUIResource("Helvetica", 0, 9);
            this.windowTitleFont = new FontUIResource("Helvetica", 1, 12);
        }
    }

    @Override
    public FontUIResource getControlTextFont() {
        if (this.controlFont == null) {
            try {
                this.controlFont = new FontUIResource(this.getPrivilegedFont("swing.plaf.metal.controlFont", new Font("Dialog", 1, 12)));
            }
            catch (Exception e) {
                this.controlFont = new FontUIResource("Dialog", 1, 12);
            }
        }
        return this.controlFont;
    }

    @Override
    public FontUIResource getSystemTextFont() {
        if (this.systemFont == null) {
            try {
                this.systemFont = new FontUIResource(this.getPrivilegedFont("swing.plaf.metal.systemFont", new Font("Dialog", 0, 12)));
            }
            catch (Exception e) {
                this.systemFont = new FontUIResource("Dialog", 0, 12);
            }
        }
        return this.systemFont;
    }

    @Override
    public FontUIResource getUserTextFont() {
        if (this.userFont == null) {
            try {
                this.userFont = new FontUIResource(this.getPrivilegedFont("swing.plaf.metal.userFont", new Font("Dialog", 0, 12)));
            }
            catch (Exception e) {
                this.userFont = new FontUIResource("Dialog", 0, 12);
            }
        }
        return this.userFont;
    }

    @Override
    public FontUIResource getMenuTextFont() {
        if (this.menuFont == null) {
            try {
                this.menuFont = new FontUIResource(this.getPrivilegedFont("swing.plaf.metal.controlFont", new Font("Dialog", 1, 12)));
            }
            catch (Exception e) {
                this.menuFont = new FontUIResource("Dialog", 1, 12);
            }
        }
        return this.menuFont;
    }

    @Override
    public FontUIResource getWindowTitleFont() {
        if (this.windowTitleFont == null) {
            try {
                this.windowTitleFont = new FontUIResource(this.getPrivilegedFont("swing.plaf.metal.controlFont", new Font("Dialog", 1, 12)));
            }
            catch (Exception e) {
                this.windowTitleFont = new FontUIResource("Dialog", 1, 12);
            }
        }
        return this.windowTitleFont;
    }

    @Override
    public FontUIResource getSubTextFont() {
        if (this.smallFont == null) {
            try {
                this.smallFont = new FontUIResource(this.getPrivilegedFont("swing.plaf.metal.smallFont", new Font("Dialog", 0, 10)));
            }
            catch (Exception e) {
                this.smallFont = new FontUIResource("Dialog", 0, 10);
            }
        }
        return this.smallFont;
    }

    private Font getPrivilegedFont(final String property, final Font defaultFont) {
        return (Font)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Font.getFont(property, defaultFont);
            }
        });
    }
}

