/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.axis;

import com.macrofocus.common.interval.BoundedInterval;
import com.macrofocus.common.interval.BoundedIntervalEvent;
import com.macrofocus.common.interval.BoundedIntervalListener;
import com.macrofocus.common.interval.IntervalEvent;
import com.macrofocus.common.interval.IntervalListener;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.scale.Transform;
import com.macrofocus.filter.MutableFilter;
import com.macrofocus.format.CPFormat;
import com.macrofocus.high_d.axis.AxisListener;
import com.macrofocus.high_d.axis.AxisModel;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractAxisModel<Row, Column>
implements AxisModel<Row, Column> {
    private boolean ghostNaN = true;
    private boolean keepOutOfRange = false;
    private final List<AxisListener> listeners = new ArrayList<AxisListener>();
    private CPFormat format;

    @Override
    public CPFormat getFormat() {
        return this.format;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setFormat(CPFormat format) {
        void var1_1;
        this.format = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addAxisListener(AxisListener listener) {
        void var1_1;
        this.listeners.add((AxisListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeAxisListener(AxisListener listener) {
        void var1_1;
        assert (this.listeners.contains(listener));
        this.listeners.remove(var1_1);
    }

    protected void fireAxisChanged() {
        for (AxisListener axisListener : this.listeners) {
            axisListener.axisChanged();
        }
    }

    @Override
    protected abstract String getFormattedValue(double var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public String getFormattedFloorValue(double value) {
        void var1_1;
        return this.getFormattedValue((double)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getFormattedCeilValue(double value) {
        void var1_1;
        return this.getFormattedFloorValue((double)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void addIntervalListener(BoundedInterval interval) {
        void var1_1;
        interval.addBoundedIntervalListener(new BoundedIntervalListener(this){
            private /* synthetic */ AbstractAxisModel this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            public final void boundedIntervalChanged(BoundedIntervalEvent event) {
                this.this$0.fireAxisChanged();
            }
        });
        var1_1.addIntervalListener(new IntervalListener(this){
            private /* synthetic */ AbstractAxisModel this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            public final void intervalChanged(IntervalEvent event) {
                this.this$0.fireAxisChanged();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    protected void registerInterval(BoundedInterval interval) {
        void var1_1;
        interval.addIntervalListener(new IntervalListener(){
            private /* synthetic */ BoundedInterval val$interval;
            private /* synthetic */ AbstractAxisModel this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$interval = boundedInterval;
            }

            /*
             * WARNING - void declaration
             */
            public final void intervalChanged(IntervalEvent event) {
                void var1_1;
                if (this.this$0.getDimension() != null) {
                    void var2_2;
                    Object to;
                    Object from;
                    if (this.val$interval.isFullRange()) {
                        this.this$0.getDimension().filterAll();
                        return;
                    }
                    if (!this.val$interval.isInvertedScale()) {
                        from = this.this$0.getOriginalCeilValue(this.val$interval.getStart());
                        to = this.this$0.getOriginalFloorValue(this.val$interval.getEnd());
                    } else {
                        from = this.this$0.getOriginalCeilValue(this.val$interval.getEnd());
                        to = this.this$0.getOriginalFloorValue(this.val$interval.getStart());
                    }
                    this.this$0.getDimension().filterRange((Object)var1_1, (Object)var2_2);
                    return;
                }
                this.this$0.incrementalProcessing(this.val$interval, (IntervalEvent)var1_1);
            }
        });
        interval.addBoundedIntervalListener(new BoundedIntervalListener(){
            private /* synthetic */ BoundedInterval val$interval;
            private /* synthetic */ AbstractAxisModel this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$interval = boundedInterval;
            }

            /*
             * WARNING - void declaration
             */
            public final void boundedIntervalChanged(BoundedIntervalEvent event) {
                if (this.this$0.getDimension() != null) {
                    void var2_2;
                    void var1_1;
                    Object to;
                    Object from;
                    if (this.val$interval.isFullRange()) {
                        this.this$0.getDimension().filterAll();
                        return;
                    }
                    if (!this.val$interval.isInvertedScale()) {
                        from = this.this$0.getOriginalCeilValue(this.val$interval.getStart());
                        to = this.this$0.getOriginalFloorValue(this.val$interval.getEnd());
                    } else {
                        from = this.this$0.getOriginalCeilValue(this.val$interval.getEnd());
                        to = this.this$0.getOriginalFloorValue(this.val$interval.getStart());
                    }
                    this.this$0.getDimension().filterRange((Object)var1_1, (Object)var2_2);
                    return;
                }
                this.this$0.fullProcessing(this.val$interval);
            }
        });
    }

    @Override
    public MutableProperty<Integer> getBinCount() {
        return null;
    }

    @Override
    public MutableProperty<AxisModel.BinType> getBinType() {
        return null;
    }

    @Override
    public MutableProperty<Transform> getScale() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void incrementalProcessing(BoundedInterval interval, IntervalEvent currentRangeSliderEvent) {
        boolean test;
        Number value;
        void positive22;
        double diffMax;
        double diffMin;
        boolean fullProcessing;
        double lastMax;
        double lastMin;
        double currentMax;
        double currentMin;
        if (!interval.isInvertedScale()) {
            currentMin = currentRangeSliderEvent.getNewStart();
            currentMax = currentRangeSliderEvent.getNewEnd();
            lastMin = currentRangeSliderEvent.getOldStart();
            fullProcessing = lastMin <= (lastMax = currentRangeSliderEvent.getOldEnd()) && currentMin > currentMax ? true : lastMin >= lastMax && currentMin < currentMax;
            diffMin = lastMin - currentRangeSliderEvent.getNewStart();
            diffMax = lastMax - currentRangeSliderEvent.getNewEnd();
        } else {
            currentMin = currentRangeSliderEvent.getNewEnd();
            currentMax = currentRangeSliderEvent.getNewStart();
            lastMin = currentRangeSliderEvent.getOldEnd();
            fullProcessing = lastMin >= (lastMax = currentRangeSliderEvent.getOldStart()) && currentMin < currentMax ? true : lastMin <= lastMax && currentMin > currentMax;
            diffMin = lastMin - currentRangeSliderEvent.getNewEnd();
            diffMax = lastMax - currentRangeSliderEvent.getNewStart();
        }
        if (fullProcessing) {
            this.fullProcessing(interval);
            return;
        }
        assert (diffMin != 0.0 || diffMax != 0.0);
        boolean positive22 = !interval.isInvertedScale() ? interval.getStart() <= interval.getEnd() : positive22.getStart() >= positive22.getEnd();
        AbstractAxisModel model = this;
        MutableFilter filter = this.getFilter();
        ArrayList toFilter = new ArrayList();
        ArrayList toUnfilter = new ArrayList();
        if (diffMin > 0.0) {
            for (Object row : model) {
                boolean test2;
                value = model.getValue(row);
                if (value == null) continue;
                double v = value.doubleValue();
                if (positive22) {
                    test2 = v <= lastMin && v >= currentMin;
                } else {
                    boolean bl = test2 = v < lastMin && v >= currentMin;
                }
                if (!test2 || !filter.isFilteredBy(row, (Object)model)) continue;
                toUnfilter.add(row);
            }
        } else if (diffMin < 0.0) {
            for (Object r : model) {
                value = model.getValue(r);
                if (value == null) continue;
                double v = value.doubleValue();
                if (positive22) {
                    test = v >= lastMin && v < currentMin;
                } else {
                    boolean bl = test = v >= lastMin && v <= currentMin;
                }
                if (!test || filter.isFilteredBy(r, (Object)model)) continue;
                toFilter.add(r);
            }
        }
        if (diffMax > 0.0) {
            for (Object r : this) {
                value = this.getValue(r);
                if (value == null) continue;
                double v = value.doubleValue();
                if (positive22) {
                    test = v <= lastMax && v > currentMax;
                } else {
                    boolean bl = test = v <= lastMax && v >= currentMax;
                }
                if (!test || filter.isFilteredBy(r, (Object)this)) continue;
                toFilter.add(r);
            }
        } else if (diffMax < 0.0) {
            for (Object r : model) {
                value = model.getValue(r);
                if (value == null) continue;
                double v = value.doubleValue();
                if (positive22) {
                    test = v > lastMax && v <= currentMax;
                } else {
                    boolean bl = test = v >= lastMax && v <= currentMax;
                }
                if (!test || !filter.isFilteredBy(r, (Object)model)) continue;
                toUnfilter.add(r);
            }
        }
        if (toFilter.size() > 0) {
            filter.setFilteredIterable(toFilter, true, (Object)model);
        }
        if (toUnfilter.size() > 0) {
            void var2_3;
            filter.setFilteredIterable(toUnfilter, false, (Object)var2_3);
        }
    }

    private void fullProcessing(BoundedInterval interval) {
        boolean isMinRange = interval.getStart() == interval.getMinimum();
        boolean isMaxRange = interval.getEnd() == interval.getMaximum();
        boolean fullRange = isMinRange && isMaxRange;
        boolean positive = interval.getStart() <= interval.getEnd();
        ArrayList toFilter = new ArrayList();
        ArrayList toUnfilter = new ArrayList();
        AbstractAxisModel model = this;
        MutableFilter filter = this.getFilter();
        for (Object r : model) {
            Number value = model.getValue(r);
            if (value != null) {
                boolean shouldBeFiltered;
                double v = value.doubleValue();
                if (!interval.isInvertedScale()) {
                    shouldBeFiltered = positive ? v < interval.getStart() || v > interval.getEnd() : v <= interval.getStart() && v >= interval.getEnd();
                } else if (positive) {
                    shouldBeFiltered = v >= interval.getStart() && v <= interval.getEnd();
                } else {
                    boolean bl = shouldBeFiltered = v > interval.getStart() || v < interval.getEnd();
                }
                if (shouldBeFiltered && !filter.isFilteredBy(r, (Object)model)) {
                    toFilter.add(r);
                    continue;
                }
                if (shouldBeFiltered || !filter.isFilteredBy(r, (Object)model)) continue;
                toUnfilter.add(r);
                continue;
            }
            boolean shouldBeFiltered = !fullRange;
            if (shouldBeFiltered && !filter.isFilteredBy(r, (Object)model)) {
                toFilter.add(r);
                continue;
            }
            if (shouldBeFiltered || !filter.isFilteredBy(r, (Object)model)) continue;
            toUnfilter.add(r);
        }
        if (toFilter.size() > 0) {
            filter.setFilteredIterable(toFilter, true, (Object)model);
        }
        if (toUnfilter.size() > 0) {
            filter.setFilteredIterable(toUnfilter, false, (Object)model);
        }
    }
}

