/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.swing;

import com.macrofocus.crossplatform.AbstractFormPanel;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.swing.AbstractSwingComponent;
import com.macrofocus.crossplatform.swing.SwingFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SwingFormPanel
extends AbstractFormPanel<JComponent> {
    private JPanel nativeComponent;
    private GridBagLayout layout = new GridBagLayout();
    private JPanel grid = new JPanel(this.layout);

    public SwingFormPanel() {
        this.nativeComponent = new JPanel(new BorderLayout());
        this.nativeComponent.add((Component)this.grid, "North");
    }

    public int add(CPComponent<JComponent> label, CPComponent<JComponent> component) {
        return this.add(this.rows.size(), label, component);
    }

    public int[] add(CPComponent<JComponent> label, CPComponent<JComponent> component, CPComponent<JComponent> content) {
        return this.add(this.rows.size(), label, component, content);
    }

    public int add(int index, CPComponent<JComponent> label, CPComponent<JComponent> component) {
        for (int i = index; i < this.rows.size(); ++i) {
            GridBagConstraints c;
            AbstractFormPanel.Row r = (AbstractFormPanel.Row)this.rows.get(i);
            if (r.getLeft() != null) {
                c = this.layout.getConstraints((Component)r.getLeft().getNativeComponent());
                c.gridy = i + 1;
                this.layout.setConstraints((Component)r.getLeft().getNativeComponent(), c);
            }
            if (r.getRight() == null) continue;
            c = this.layout.getConstraints((Component)r.getRight().getNativeComponent());
            c.gridy = i + 1;
            this.layout.setConstraints((Component)r.getRight().getNativeComponent(), c);
        }
        this.rows.add(index, new AbstractFormPanel.Row(label, component));
        if (label != null) {
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 0;
            c.anchor = 13;
            c.weightx = 0.0;
            c.gridx = 0;
            c.gridy = index;
            this.grid.add((Component)label.getNativeComponent(), c);
        }
        if (component != null) {
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.anchor = 17;
            c.weightx = 100.0;
            c.gridx = 1;
            c.gridy = index;
            this.grid.add((Component)component.getNativeComponent(), c);
        }
        return index;
    }

    public int[] add(int index, CPComponent<JComponent> label, CPComponent<JComponent> component, final CPComponent<JComponent> content) {
        final JToggleButton button = new JToggleButton(">");
        Border emptyBorder = BorderFactory.createEmptyBorder();
        button.setBorder(emptyBorder);
        button.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ((JComponent)content.getNativeComponent()).setVisible(button.isSelected());
                button.setText(button.isSelected() ? "\u25bc" : "\u25ba");
            }
        });
        JPanel first = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.anchor = 13;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        first.add((Component)button, c);
        c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.weightx = 100.0;
        c.gridx = 1;
        c.gridy = 0;
        first.add((Component)component.getNativeComponent(), c);
        int r1 = this.add(index, label, SwingFactory.getInstance().createComponent(first));
        if (content != null) {
            ((JComponent)content.getNativeComponent()).setVisible(button.isSelected());
            button.setText(button.isSelected() ? "\u25bc" : "\u25ba");
        } else {
            button.setVisible(false);
        }
        int r2 = this.add(index + 1, null, content);
        return new int[]{r1, r2};
    }

    public void addSeparator() {
        JSeparator sep = new JSeparator();
        sep.setPreferredSize(new Dimension(0, 9));
        this.add(SwingFactory.getInstance().createComponent(sep), null);
        GridBagConstraints c = this.layout.getConstraints(sep);
        c.fill = 2;
        c.anchor = 13;
        c.insets = new Insets(0, 8, 0, 0);
        c.weightx = 1.0;
        c.gridwidth = 2;
        this.layout.setConstraints(sep, c);
        this.grid.revalidate();
    }

    public void remove(List<Integer> indices) {
        Collections.sort(indices, Collections.reverseOrder());
        for (Integer index : indices) {
            AbstractFormPanel.Row r = (AbstractFormPanel.Row)this.rows.get(index);
            if (r.getLeft() != null) {
                this.grid.remove((Component)r.getLeft().getNativeComponent());
            }
            if (r.getRight() != null) {
                this.grid.remove((Component)r.getRight().getNativeComponent());
            }
            this.rows.remove(index);
            for (int i = index.intValue(); i < this.rows.size(); ++i) {
                GridBagConstraints c;
                AbstractFormPanel.Row r2 = (AbstractFormPanel.Row)this.rows.get(i);
                if (r2.getLeft() != null) {
                    c = this.layout.getConstraints((Component)r2.getLeft().getNativeComponent());
                    c.gridy = i;
                    this.layout.setConstraints((Component)r2.getLeft().getNativeComponent(), c);
                }
                if (r2.getRight() == null) continue;
                c = this.layout.getConstraints((Component)r2.getRight().getNativeComponent());
                c.gridy = i;
                this.layout.setConstraints((Component)r2.getRight().getNativeComponent(), c);
            }
        }
        this.grid.revalidate();
    }

    public void setStyleClass(String ... styleClasses) {
        AbstractSwingComponent.setStyleClass(this, styleClasses);
    }

    public JComponent getNativeComponent() {
        return this.nativeComponent;
    }
}

