/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.igraphics.swing;

import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class GeometryShape
implements Shape {
    private final com.macrofocus.geom.Shape geometry;

    public GeometryShape(com.macrofocus.geom.Shape geometry) {
        this.geometry = geometry;
    }

    @Override
    public Rectangle getBounds() {
        com.macrofocus.geom.Rectangle2D b = this.geometry.getBounds2D();
        double width = b.getWidth();
        double height = b.getHeight();
        if (width < 0.0 || height < 0.0) {
            return new Rectangle();
        }
        double x = b.getX();
        double y = b.getY();
        double x1 = Math.floor(x);
        double y1 = Math.floor(y);
        double x2 = Math.ceil(x + width);
        double y2 = Math.ceil(y + height);
        return new Rectangle((int)x1, (int)y1, (int)(x2 - x1), (int)(y2 - y1));
    }

    @Override
    public Rectangle2D getBounds2D() {
        com.macrofocus.geom.Rectangle2D b = this.geometry.getBounds2D();
        return new Rectangle2D.Double(b.getX(), b.getY(), b.getWidth(), b.getHeight());
    }

    @Override
    public boolean contains(double x, double y) {
        return this.geometry.contains((com.macrofocus.geom.Point2D)new Point2D.Double(x, y));
    }

    @Override
    public boolean contains(Point2D p) {
        return this.geometry.contains((com.macrofocus.geom.Point2D)new Point2D.Double(p.getX(), p.getY()));
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.geometry.intersects((com.macrofocus.geom.Rectangle2D)new Rectangle2D.Double(x, y, w, h));
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.geometry.intersects((com.macrofocus.geom.Rectangle2D)new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight()));
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return false;
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return false;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return new GeometryPathIterator(this.geometry.getPathIterator(), at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return new GeometryPathIterator(this.geometry.getFlattenPathIterator(flatness), at);
    }

    private static class GeometryPathIterator
    implements PathIterator {
        private final com.macrofocus.geom.PathIterator pi;
        private final AffineTransform transform;

        public GeometryPathIterator(com.macrofocus.geom.PathIterator pi, AffineTransform transform) {
            this.pi = pi;
            this.transform = transform;
        }

        @Override
        public int getWindingRule() {
            return this.pi.getWindingRule();
        }

        @Override
        public boolean isDone() {
            return this.pi.isDone();
        }

        @Override
        public void next() {
            this.pi.next();
        }

        @Override
        public int currentSegment(float[] coords) {
            int type = this.pi.currentSegment(coords);
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, coords.length / 2);
            }
            return type;
        }

        @Override
        public int currentSegment(double[] coords) {
            int type = this.pi.currentSegment(coords);
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, coords.length / 2);
            }
            return type;
        }
    }
}

