/*
 * Decompiled with CFR 0.152.
 */
package org.lbzip2;

import java.io.IOException;
import org.lbzip2.AbstractDataSource;

class ByteArrayDataSource
extends AbstractDataSource {
    private final byte[] array;
    private int offset;

    public ByteArrayDataSource(byte[] array) {
        this.array = array;
    }

    public boolean isEmpty() throws IOException {
        return this.offset == this.array.length;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        int size = Math.min(len, this.array.length - this.offset);
        System.arraycopy(this.array, this.offset, buf, off, size);
        this.offset += size;
        return size;
    }
}

