/*
 * Decompiled with CFR 0.152.
 */
package org.lbzip2;

import java.util.Arrays;
import org.lbzip2.BWT;
import org.lbzip2.CompressedBlock;
import org.lbzip2.DivBWT;
import org.lbzip2.EntropyCoder;
import org.lbzip2.UncompressedBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Encoder {
    private final Logger logger = LoggerFactory.getLogger(Encoder.class);
    private final int[] cmap = new int[256];
    private final int[] order = new int[255];
    private long b;
    private int k;
    private byte[] p;
    private int p_off;
    private final short[] mtfv;
    private int nmtf;
    private final byte[] selector_mtf = new byte[18001];
    private int bwt_idx;
    private int out_expect_len;
    private final UncompressedBlock col;
    private final EntropyCoder ec;
    private final BWT bwt = new DivBWT();
    private int block_crc;
    private final boolean[] inuse = new boolean[256];

    private Encoder(UncompressedBlock col, EntropyCoder ec) {
        this.col = col;
        this.ec = ec;
        this.mtfv = new short[col.size + 50];
    }

    private int do_mtf(int[] SA, int[] mtffreq, int nblock) {
        int k;
        int i;
        int bwt_off = 0;
        int mtfv_off = 0;
        int j = 0;
        for (i = 0; i < 256; ++i) {
            k = this.col.inuse[i] ? 1 : 0;
            this.cmap[i] = j;
            j += k;
        }
        int EOB = j + 1;
        assert (EOB >= 2);
        assert (EOB < 258);
        Arrays.fill(mtffreq, 0);
        k = 0;
        int u = 0;
        for (i = 0; i < 255; ++i) {
            this.order[i] = i + 1;
        }
        for (i = 0; i < nblock; ++i) {
            int c;
            if ((c = this.cmap[SA[bwt_off++]]) == u) {
                ++k;
                continue;
            }
            while (k != 0) {
                int n = mtfv_off++;
                short s = (short)(--k & 1);
                this.mtfv[n] = s;
                mtffreq[s] = mtffreq[s] + 1;
                k >>= 1;
            }
            int p = 0;
            int t = this.order[0];
            this.order[0] = u;
            while (true) {
                if (c == t) {
                    u = t;
                    break;
                }
                u = this.order[++p];
                this.order[p] = t;
                if (c == u) break;
                t = this.order[++p];
                this.order[p] = u;
            }
            t = p + 2;
            this.mtfv[mtfv_off++] = (short)t;
            int n = t;
            mtffreq[n] = mtffreq[n] + 1;
        }
        while (k != 0) {
            int n = mtfv_off++;
            short s = (short)(--k & 1);
            this.mtfv[n] = s;
            mtffreq[s] = mtffreq[s] + 1;
            k >>= 1;
        }
        this.mtfv[mtfv_off++] = (short)EOB;
        int n = EOB;
        mtffreq[n] = mtffreq[n] + 1;
        return mtfv_off;
    }

    private int encode() {
        int j;
        int c;
        assert (this.col.size > 0);
        int[] SA = new int[this.col.size + 1];
        this.bwt_idx = this.bwt.transform(this.col.block, SA, this.col.size);
        this.nmtf = this.do_mtf(SA, this.ec.code[0], this.col.size);
        this.logger.debug("Block info: bs={}, idx={}, nm={}, as={}", new Object[]{this.col.size, this.bwt_idx, this.nmtf, this.mtfv[this.nmtf - 1] + 1});
        SA = null;
        int cost = 123;
        cost += this.ec.generate_prefix_code(this.mtfv, this.nmtf);
        int sp = 0;
        int smp = 0;
        int p = 5517840;
        assert (this.ec.selector[0] < 6);
        assert (this.ec.tmap_old2new[this.ec.selector[0]] == 0);
        while ((c = this.ec.selector[sp]) != 6) {
            c = this.ec.tmap_old2new[c];
            assert (c < this.ec.num_trees);
            assert (sp < this.ec.num_selectors);
            int v = p ^ 0x111111 * c;
            int z = v + 0xEEEEEF & 0x888888;
            int l = z ^ z - 1;
            int h = ~l;
            p = (p | l) & (p << 4 | h | c);
            j = ((h &= -h) & 0x1010100) != 0 ? 1 : 0;
            h |= h >> 4;
            j |= h >> 11;
            j |= h >> 18;
            ++sp;
            this.selector_mtf[smp++] = (byte)(j &= 7);
            cost += j + 1;
        }
        j = cost & 7;
        j = 8 - j & 7;
        this.ec.num_selectors += j;
        cost += j;
        while (j-- > 0) {
            this.selector_mtf[smp++] = 0;
        }
        assert (cost % 8 == 0);
        for (int i = 0; i < 16; ++i) {
            int pk = 0;
            for (j = 0; j < 16; ++j) {
                pk |= this.col.inuse[16 * i + j] ? 16 : 0;
            }
            cost += pk;
        }
        assert ((cost += 16) % 8 == 0);
        this.out_expect_len = cost >>= 3;
        this.block_crc = this.col.crc;
        System.arraycopy(this.col.inuse, 0, this.inuse, 0, 256);
        this.logger.debug("Block transmission cost is {} bytes", (Object)cost);
        this.logger.debug("Block CRC is {}", (Object)String.format("%08X", ~this.col.crc));
        return cost;
    }

    private void SEND(int n, int v) {
        long b = this.b;
        int k = this.k;
        b = b << n | (long)v & 0xFFFFFFFFL;
        if ((k += n) >= 32) {
            this.p[this.p_off++] = (byte)(b >> (k -= 8));
            this.p[this.p_off++] = (byte)(b >> (k -= 8));
            this.p[this.p_off++] = (byte)(b >> (k -= 8));
            this.p[this.p_off++] = (byte)(b >> (k -= 8));
        }
        this.b = b;
        this.k = k;
    }

    private void transmit(byte[] buf) {
        int v;
        int i;
        this.b = 0L;
        this.k = 0;
        this.p = buf;
        this.p_off = 0;
        int as = this.mtfv[this.nmtf - 1] + 1;
        int ns = (this.nmtf + 50 - 1) / 50;
        this.SEND(24, 3227993);
        this.SEND(24, 2511705);
        this.SEND(32, ~this.block_crc);
        this.SEND(1, 0);
        this.SEND(24, this.bwt_idx);
        int[] pack = new int[16];
        int big = 0;
        for (i = 0; i < 16; ++i) {
            big <<= 1;
            int small = 0;
            for (int j = 0; j < 16; ++j) {
                small <<= 1;
                if (!this.inuse[16 * i + j]) continue;
                small |= 1;
                big |= 1;
            }
            pack[i] = small;
        }
        this.SEND(16, big);
        for (i = 0; i < 16; ++i) {
            if (pack[i] == 0) continue;
            this.SEND(16, pack[i]);
        }
        assert (this.ec.num_trees >= 2 && this.ec.num_trees <= 6);
        this.SEND(3, this.ec.num_trees);
        int t = this.ec.num_selectors;
        this.SEND(15, t);
        int sp = 0;
        while (t-- > 0) {
            v = 1 + this.selector_mtf[sp++];
            this.SEND(v, (1 << v) - 2);
        }
        for (t = 0; t < this.ec.num_trees; ++t) {
            byte[] len = this.ec.length[this.ec.tmap_new2old[t]];
            int a = len[0];
            this.SEND(6, a << 1);
            for (v = 1; v < as; ++v) {
                byte c = len[v];
                while (a < c) {
                    this.SEND(2, 2);
                    ++a;
                }
                while (a > c) {
                    this.SEND(2, 3);
                    --a;
                }
                this.SEND(1, 0);
            }
        }
        int mtfv_off = 0;
        for (int gr = 0; gr < ns; ++gr) {
            t = this.ec.selector[gr];
            int[] L = this.ec.code[t];
            byte[] B = this.ec.length[t];
            for (int i2 = 0; i2 < 50; ++i2) {
                short mv = this.mtfv[mtfv_off++];
                this.SEND(B[mv], L[mv]);
            }
        }
        while (this.k > 0) {
            this.p[this.p_off++] = (byte)(this.b << 56 - (this.k -= 8) >> 56);
        }
        assert (this.p_off == this.out_expect_len);
    }

    static CompressedBlock encode(UncompressedBlock uncompressedBlock) {
        Encoder encoder = new Encoder(uncompressedBlock, new EntropyCoder(10));
        int blockSize = uncompressedBlock.size;
        int compressedSize = encoder.encode();
        byte[] buffer = new byte[compressedSize];
        int crc = encoder.block_crc;
        encoder.transmit(buffer);
        return new CompressedBlock(buffer, blockSize, crc);
    }
}

