/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.common.geom.Dimension;
import com.macrofocus.data.type.HtmlString;
import com.macrofocus.igraphics.Insets;
import com.macrofocus.labeling.EnhancedLabel;
import com.treemap.TreeMapField;
import com.treemap.TreeMapFieldSettings;
import com.treemap.TreeMapTooltipRenderer;
import com.treemap.TreeMapView;

public class DefaultTreeMapTooltipRenderer<C, N, Row, Column, Color, Font>
extends EnhancedLabel<Color, Font>
implements TreeMapTooltipRenderer<C, N, Row, Column, Color, Font> {
    public static final Insets DEFAULT_BORDER = new Insets(0, 2, 0, 1);

    public DefaultTreeMapTooltipRenderer() {
        this.setOpaque(false);
        this.setName("TreeMap.tooltipRenderer");
        this.setInsets(DefaultTreeMapTooltipRenderer.DEFAULT_BORDER.top, DefaultTreeMapTooltipRenderer.DEFAULT_BORDER.left, DefaultTreeMapTooltipRenderer.DEFAULT_BORDER.bottom, DefaultTreeMapTooltipRenderer.DEFAULT_BORDER.right);
        this.setEffect(EnhancedLabel.Effect.Plain);
        this.setHorizontalAlignment(2);
        this.setRendering(EnhancedLabel.Rendering.WordWrap);
    }

    @Override
    public EnhancedLabel<Color, Font> getTooltipRendererComponent(TreeMapView<C, N, Row, Column, Color, Font> view, TreeMapField<N, Column> field, TreeMapFieldSettings<Color, Font> settings, N node, Dimension dimension) {
        String string = view.getModel().getStringValue(node, field, settings);
        this.setText(string);
        this.setHTML(field.getType() == HtmlString.class);
        EnhancedLabel.Rendering rendering = settings.getTooltipRendering();
        if (rendering != null) {
            this.setRendering(rendering);
        }
        if (view.getModel().isNumericType(field)) {
            this.setHorizontalAlignment(4);
        } else {
            this.setHorizontalAlignment(2);
        }
        this.setDesiredWidth(dimension.width);
        this.setDesiredHeight(dimension.height);
        return this;
    }
}

