/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.Core;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.X3DConcreteStatement;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.sai.Core.X3DChildNode;
import org.web3d.x3d.sai.Core.X3DMetadataObject;
import org.web3d.x3d.sai.InvalidFieldValueException;

public class ROUTE
extends X3DConcreteStatement
implements X3DChildNode {
    private ArrayList<String> commentsList;
    private String fromField;
    private String fromNode;
    private String toField;
    private String toNode;
    public static final String NAME = "ROUTE";
    public static final String COMPONENT = "Core";
    public static final int LEVEL = 1;
    public static final String FROMFIELD_DEFAULT_VALUE = "";
    public static final String FROMNODE_DEFAULT_VALUE = "";
    public static final String TOFIELD_DEFAULT_VALUE = "";
    public static final String TONODE_DEFAULT_VALUE = "";

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return COMPONENT;
    }

    @Override
    public final int getComponentLevel() {
        return 1;
    }

    @Override
    public String getFieldType(String fieldName) {
        String result;
        switch (fieldName) {
            case "containerField": {
                result = "SFString";
                break;
            }
            case "fromField": {
                result = "SFString";
                break;
            }
            case "fromNode": {
                result = "SFString";
                break;
            }
            case "toField": {
                result = "SFString";
                break;
            }
            case "toNode": {
                result = "SFString";
                break;
            }
            default: {
                result = fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
            }
        }
        return result;
    }

    @Override
    public String getAccessType(String fieldName) {
        String result;
        switch (fieldName) {
            case "fromField": {
                result = "inputOutput";
                break;
            }
            case "fromNode": {
                result = "inputOutput";
                break;
            }
            case "toField": {
                result = "inputOutput";
                break;
            }
            case "toNode": {
                result = "inputOutput";
                break;
            }
            default: {
                result = fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
            }
        }
        return result;
    }

    public ROUTE() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.fromField = "";
        this.fromNode = "";
        this.toField = "";
        this.toNode = "";
        this.commentsList = new ArrayList();
    }

    public String getFromField() {
        return this.fromField;
    }

    public ROUTE setFromField(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("ROUTE fromField newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.fromField = newValue;
        return this;
    }

    public ROUTE setFromField(SFString newValue) {
        this.setFromField(newValue.getPrimitiveValue());
        return this;
    }

    public String getFromNode() {
        return this.fromNode;
    }

    public ROUTE setFromNode(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("ROUTE fromNode newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.fromNode = newValue;
        return this;
    }

    public ROUTE setFromNode(SFString newValue) {
        this.setFromNode(newValue.getPrimitiveValue());
        return this;
    }

    public String getToField() {
        return this.toField;
    }

    public ROUTE setToField(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("ROUTE toField newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.toField = newValue;
        return this;
    }

    public ROUTE setToField(SFString newValue) {
        this.setToField(newValue.getPrimitiveValue());
        return this;
    }

    public String getToNode() {
        return this.toNode;
    }

    public ROUTE setToNode(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("ROUTE toNode newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.toNode = newValue;
        return this;
    }

    public ROUTE setToNode(SFString newValue) {
        this.setToNode(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public ROUTE addComments(String newComment) {
        this.commentsList.add(newComment);
        return this;
    }

    @Override
    public ROUTE addComments(String[] newComments) {
        this.commentsList.addAll(Arrays.asList(newComments));
        return this;
    }

    @Override
    public ROUTE addComments(CommentsBlock newCommentsBlock) {
        this.commentsList.addAll(newCommentsBlock.toStringList());
        return this;
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasAttributes = true;
        boolean hasChild = !this.commentsList.isEmpty();
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<ROUTE");
        if (hasAttributes) {
            if (!this.getFromField().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" fromField='").append(new SFString(this.getFromField()).toStringX3D()).append("'");
            }
            if (!this.getFromNode().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" fromNode='").append(new SFString(this.getFromNode()).toStringX3D()).append("'");
            }
            if (!this.getToField().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" toField='").append(new SFString(this.getToField()).toStringX3D()).append("'");
            }
            if (!this.getToNode().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                stringX3D.append(" toNode='").append(new SFString(this.getToNode()).toStringX3D()).append("'");
            }
        }
        if (hasChild) {
            stringX3D.append(">").append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</ROUTE>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean hasChild = !this.commentsList.isEmpty();
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        stringClassicVRML.append("ROUTE ").append(this.fromNode).append(".").append(this.fromField).append(" TO ").append(this.toNode).append(".").append(this.toField).append("\n").append((CharSequence)indent);
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        return this.toStringClassicVRML(indentLevel);
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, "");
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        this.validationResult = new StringBuilder();
        if (this.getFromField().isEmpty()) {
            String errorNotice = "ERROR_VALUE_NOT_FOUND, ROUTE fromField field is required but no value found. ";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setFromField(this.getFromField());
        if (this.getFromNode().isEmpty()) {
            String errorNotice = "ERROR_VALUE_NOT_FOUND, ROUTE fromNode field is required but no value found. ";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setFromNode(this.getFromNode());
        if (this.getToField().isEmpty()) {
            String errorNotice = "ERROR_VALUE_NOT_FOUND, ROUTE toField field is required but no value found. ";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setToField(this.getToField());
        if (this.getToNode().isEmpty()) {
            String errorNotice = "ERROR_VALUE_NOT_FOUND, ROUTE toNode field is required but no value found. ";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setToNode(this.getToNode());
        String errorNotice = new String();
        String ROUTE_description = "<ROUTE fromNode='" + this.fromNode + "' fromField='" + this.fromField + "' toNode='" + this.toNode + "' toField='" + this.toField + "'/>";
        X3DConcreteNode fromNodeObject = null;
        X3DConcreteNode toNodeObject = null;
        if (this.findAncestorScene() == null && this.findAncestorProtoBody() == null && !ConfigurationProperties.isCreationConnectionValidationExceptionAllowed()) {
            errorNotice = "ERROR_NOT_CONNECTED_TO_SCENE_GRAPH, ROUTE is not currently connected to scene graph and thus fromNode/toNode fields cannot be checked, must first be connected to scene graph in order to get checked. ";
            this.validationResult.append(ROUTE_description).append("\n").append(errorNotice).append("\n");
        }
        if (this.getFromField().isEmpty()) {
            errorNotice = " ROUTE has no DEF value for source node since fromNode value is empty. ";
            this.validationResult.append(errorNotice).append("\n");
        } else if (this.findAncestorProtoBody() != null) {
            fromNodeObject = this.findAncestorProtoBody().findNodeByDEF(this.getFromNode());
            if (fromNodeObject == null) {
                errorNotice = " ROUTE fromNode='" + this.getFromNode() + "' was not found within connected ProtoBody. ";
                this.validationResult.append(errorNotice).append("\n");
            }
        } else if (this.findAncestorScene() != null && (fromNodeObject = this.findAncestorScene().findNodeByDEF(this.getFromNode())) == null) {
            errorNotice = " ROUTE fromNode='" + this.getFromNode() + "' was not found in connected scene graph. ";
            this.validationResult.append(errorNotice).append("\n");
        }
        if (this.getToField().isEmpty()) {
            errorNotice = " ROUTE has no DEF value for target node since toNode value is empty. ";
            this.validationResult.append(errorNotice).append("\n");
        } else if (this.findAncestorProtoBody() != null) {
            toNodeObject = this.findAncestorProtoBody().findNodeByDEF(this.getToNode());
            if (toNodeObject == null) {
                errorNotice = " ROUTE toNode='" + this.getToNode() + "' was not found within connected ProtoBody. ";
                this.validationResult.append(errorNotice).append("\n");
            }
        } else if (this.findAncestorScene() != null && (toNodeObject = this.findAncestorScene().findNodeByDEF(this.getToNode())) == null) {
            errorNotice = " ROUTE toNode='" + this.getToNode() + "' was not found in connected scene graph. ";
            this.validationResult.append(errorNotice).append("\n");
        }
        if (this.fromNode.equals(this.toNode) && this.fromField.equals(this.toField)) {
            errorNotice = " ROUTE source and destination are identical. ";
            this.validationResult.append(errorNotice).append("\n");
        }
        if (!errorNotice.isEmpty() || fromNodeObject == null || toNodeObject == null) {
            this.validationResult.append(ROUTE_description).append("\n");
        } else {
            String toFieldAccessType = new String();
            String fromNodeType = fromNodeObject.getClass().getSimpleName().split("Object")[0];
            String toNodeType = toNodeObject.getClass().getSimpleName().split("Object")[0];
            String fromFieldType = fromNodeObject.getFieldType(this.fromField);
            String toFieldType = toNodeObject.getFieldType(this.toField);
            String fromFieldAccessType = fromNodeObject.getAccessType(this.fromField);
            toFieldAccessType = toNodeObject.getAccessType(this.toField);
            ROUTE_description = "ROUTE details: FROM " + this.fromNode + "." + this.fromField + " [" + fromNodeType + "," + fromFieldType + "," + fromFieldAccessType + "] TO " + this.toNode + "." + this.toField + " [" + toNodeType + "," + toFieldType + "," + toFieldAccessType + "]";
            if (!fromFieldType.equals(toFieldType)) {
                errorNotice = " ROUTE has source-destination type mismatch, fromField='" + this.fromField + "' source and toField='" + this.toField + "' destination have different types. ";
            }
            if (!fromFieldAccessType.equals("inputOutput") && !fromFieldAccessType.equals("outputOnly")) {
                errorNotice = " ROUTE fromField (source) event can only have accessType='inputOutput' or accessType='outputOnly'. ";
            }
            if (!toFieldAccessType.equals("inputOutput") && !toFieldAccessType.equals("inputOnly")) {
                errorNotice = " ROUTE toField (destination) event can only have accessType='inputOutput' or accessType='inputOnly'. ";
            }
            if (!errorNotice.isEmpty()) {
                this.validationResult.append(errorNotice).append("\n").append(ROUTE_description).append("\n");
                throw new InvalidFieldValueException(ROUTE_description + "\n" + errorNotice);
            }
        }
        return this.validationResult.toString();
    }

    @Override
    @Deprecated
    public X3DMetadataObject getMetadata() {
        return null;
    }

    @Override
    @Deprecated
    public ROUTE setMetadata(X3DMetadataObject newValue) {
        return this;
    }

    @Deprecated
    public ROUTE setDEF(String newValue) {
        return this;
    }

    @Deprecated
    public ROUTE setUSE(String newValue) {
        return this;
    }

    @Deprecated
    public ROUTE setCssClass(String newValue) {
        return this;
    }
}

