/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.x3d.jsail.VolumeRendering;

import java.util.ArrayList;
import java.util.Arrays;
import org.web3d.x3d.jsail.ConfigurationProperties;
import org.web3d.x3d.jsail.Core.CommentsBlock;
import org.web3d.x3d.jsail.Core.IS;
import org.web3d.x3d.jsail.Core.ProtoInstance;
import org.web3d.x3d.jsail.Core.connect;
import org.web3d.x3d.jsail.X3DConcreteElement;
import org.web3d.x3d.jsail.X3DConcreteNode;
import org.web3d.x3d.jsail.fields.MFBool;
import org.web3d.x3d.jsail.fields.MFString;
import org.web3d.x3d.jsail.fields.SFBool;
import org.web3d.x3d.jsail.fields.SFString;
import org.web3d.x3d.jsail.fields.SFVec3f;
import org.web3d.x3d.sai.Core.X3DMetadataObject;
import org.web3d.x3d.sai.Core.X3DNode;
import org.web3d.x3d.sai.InvalidFieldException;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.InvalidProtoException;
import org.web3d.x3d.sai.Texturing3D.X3DTexture3DNode;
import org.web3d.x3d.sai.VolumeRendering.X3DVolumeRenderStyleNode;

public class SegmentedVolumeData
extends X3DConcreteNode
implements org.web3d.x3d.sai.VolumeRendering.SegmentedVolumeData {
    private ArrayList<String> commentsList;
    private float[] bboxCenter;
    private boolean bboxDisplay;
    private float[] bboxSize;
    private float[] dimensions;
    private IS IS;
    private X3DMetadataObject metadata;
    private ProtoInstance metadataProtoInstance;
    private ArrayList<X3DNode> renderStyle = new ArrayList();
    private ArrayList<Boolean> segmentEnabled = new ArrayList();
    private X3DTexture3DNode segmentIdentifiers;
    private ProtoInstance segmentIdentifiersProtoInstance;
    private boolean visible;
    private X3DTexture3DNode voxels;
    private ProtoInstance voxelsProtoInstance;
    public static final String NAME = "SegmentedVolumeData";
    public static final String COMPONENT = "VolumeRendering";
    public static final int LEVEL = 2;
    public static final float[] BBOXCENTER_DEFAULT_VALUE = new float[]{0.0f, 0.0f, 0.0f};
    public static final boolean BBOXDISPLAY_DEFAULT_VALUE = false;
    public static final float[] BBOXSIZE_DEFAULT_VALUE = new float[]{-1.0f, -1.0f, -1.0f};
    public static final float[] DIMENSIONS_DEFAULT_VALUE = new float[]{1.0f, 1.0f, 1.0f};
    public static final IS IS_DEFAULT_VALUE = null;
    public static final X3DMetadataObject METADATA_DEFAULT_VALUE = null;
    public static final ArrayList<Boolean> SEGMENTENABLED_DEFAULT_VALUE = new ArrayList<Boolean>(Arrays.asList(new Boolean[0]));
    public static final X3DTexture3DNode SEGMENTIDENTIFIERS_DEFAULT_VALUE = null;
    public static final boolean VISIBLE_DEFAULT_VALUE = true;
    public static final X3DTexture3DNode VOXELS_DEFAULT_VALUE = null;
    public static final String containerField_DEFAULT_VALUE = "children";
    public static final String fromField_BBOXDISPLAY = "bboxDisplay";
    public static final String toField_BBOXDISPLAY = "bboxDisplay";
    public static final String fromField_DIMENSIONS = "dimensions";
    public static final String toField_DIMENSIONS = "dimensions";
    public static final String fromField_IS = "IS";
    public static final String fromField_METADATA = "metadata";
    public static final String toField_METADATA = "metadata";
    public static final String fromField_RENDERSTYLE = "renderStyle";
    public static final String toField_RENDERSTYLE = "renderStyle";
    public static final String fromField_SEGMENTENABLED = "segmentEnabled";
    public static final String toField_SEGMENTENABLED = "segmentEnabled";
    public static final String fromField_SEGMENTIDENTIFIERS = "segmentIdentifiers";
    public static final String toField_SEGMENTIDENTIFIERS = "segmentIdentifiers";
    public static final String fromField_VISIBLE = "visible";
    public static final String toField_VISIBLE = "visible";
    public static final String fromField_VOXELS = "voxels";
    public static final String toField_VOXELS = "voxels";

    @Override
    public final String getElementName() {
        return NAME;
    }

    @Override
    public final String getComponent() {
        return COMPONENT;
    }

    @Override
    public final int getComponentLevel() {
        return 2;
    }

    @Override
    public String getFieldType(String fieldName) {
        String result;
        switch (fieldName) {
            case "containerField": {
                result = "SFString";
                break;
            }
            case "bboxCenter": {
                result = "SFVec3f";
                break;
            }
            case "bboxDisplay": {
                result = "SFBool";
                break;
            }
            case "bboxSize": {
                result = "SFVec3f";
                break;
            }
            case "dimensions": {
                result = "SFVec3f";
                break;
            }
            case "IS": {
                result = "SFNode";
                break;
            }
            case "metadata": {
                result = "SFNode";
                break;
            }
            case "renderStyle": {
                result = "MFNode";
                break;
            }
            case "segmentEnabled": {
                result = "MFBool";
                break;
            }
            case "segmentIdentifiers": {
                result = "SFNode";
                break;
            }
            case "visible": {
                result = "SFBool";
                break;
            }
            case "voxels": {
                result = "SFNode";
                break;
            }
            case "DEF": {
                result = "SFString";
                break;
            }
            case "USE": {
                result = "SFString";
                break;
            }
            case "class": {
                result = "SFString";
                break;
            }
            default: {
                result = fieldName.trim().startsWith("set_") ? this.getFieldType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getFieldType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_TYPE");
            }
        }
        return result;
    }

    @Override
    public String getAccessType(String fieldName) {
        String result;
        switch (fieldName) {
            case "bboxCenter": {
                result = "initializeOnly";
                break;
            }
            case "bboxDisplay": {
                result = "inputOutput";
                break;
            }
            case "bboxSize": {
                result = "initializeOnly";
                break;
            }
            case "dimensions": {
                result = "inputOutput";
                break;
            }
            case "IS": {
                result = "inputOutput";
                break;
            }
            case "metadata": {
                result = "inputOutput";
                break;
            }
            case "renderStyle": {
                result = "inputOutput";
                break;
            }
            case "segmentEnabled": {
                result = "inputOutput";
                break;
            }
            case "segmentIdentifiers": {
                result = "inputOutput";
                break;
            }
            case "visible": {
                result = "inputOutput";
                break;
            }
            case "voxels": {
                result = "inputOutput";
                break;
            }
            case "DEF": {
                result = "inputOutput";
                break;
            }
            case "USE": {
                result = "inputOutput";
                break;
            }
            case "class": {
                result = "inputOutput";
                break;
            }
            default: {
                result = fieldName.trim().startsWith("set_") ? this.getAccessType(fieldName.trim().substring(4)) : (fieldName.trim().endsWith("_changed") ? this.getAccessType(fieldName.trim().substring(0, fieldName.length() - 8)) : "ERROR_UNKNOWN_FIELD_ACCESSTYPE");
            }
        }
        return result;
    }

    @Override
    public final String getContainerFieldDefault() {
        return containerField_DEFAULT_VALUE;
    }

    public SegmentedVolumeData() {
        this.initialize();
    }

    @Override
    public final void initialize() {
        super.initialize();
        this.setContainerFieldOverride("");
        this.containerField_ALTERNATE_VALUES = new String[]{containerField_DEFAULT_VALUE};
        this.bboxCenter = BBOXCENTER_DEFAULT_VALUE;
        this.bboxDisplay = false;
        this.bboxSize = BBOXSIZE_DEFAULT_VALUE;
        this.dimensions = DIMENSIONS_DEFAULT_VALUE;
        this.IS = null;
        this.metadata = null;
        this.metadataProtoInstance = null;
        this.renderStyle = new ArrayList();
        this.segmentEnabled = new ArrayList();
        this.segmentIdentifiers = null;
        this.segmentIdentifiersProtoInstance = null;
        this.visible = true;
        this.voxels = null;
        this.voxelsProtoInstance = null;
        this.commentsList = new ArrayList();
    }

    @Override
    public float[] getBboxCenter() {
        return this.bboxCenter;
    }

    @Override
    public SegmentedVolumeData setBboxCenter(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        if (newValue.length != 3) {
            throw new InvalidFieldValueException("SegmentedVolumeData bboxCenter newValue=" + SFVec3f.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
        }
        this.bboxCenter = newValue;
        return this;
    }

    public SegmentedVolumeData setBboxCenter(SFVec3f newValue) {
        this.setBboxCenter(newValue.getPrimitiveValue());
        return this;
    }

    public SegmentedVolumeData setBboxCenter(float x, float y, float z) {
        this.setBboxCenter(new float[]{x, y, z});
        return this;
    }

    public SegmentedVolumeData setBboxCenter(double x, double y, double z) {
        return this.setBboxCenter(new SFVec3f(x, y, z));
    }

    public SegmentedVolumeData setBboxCenter(double[] newArray) {
        return this.setBboxCenter(new SFVec3f(newArray));
    }

    @Override
    public boolean getBboxDisplay() {
        return this.bboxDisplay;
    }

    @Override
    public SegmentedVolumeData setBboxDisplay(boolean newValue) {
        this.bboxDisplay = newValue;
        return this;
    }

    public SegmentedVolumeData setBboxDisplay(SFBool newValue) {
        this.setBboxDisplay(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public float[] getBboxSize() {
        return this.bboxSize;
    }

    @Override
    public SegmentedVolumeData setBboxSize(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        if (newValue.length != 3) {
            throw new InvalidFieldValueException("SegmentedVolumeData bboxSize newValue=" + SFVec3f.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
        }
        if ((newValue[0] < 0.0f || newValue[1] < 0.0f || newValue[2] < 0.0f) && (newValue[0] != -1.0f || newValue[1] != -1.0f || newValue[2] != -1.0f)) {
            throw new InvalidFieldValueException("SegmentedVolumeData bboxSize newValue=" + SFVec3f.toString(newValue) + " has negative value but is not equal to sentinel {-1,-1,-1} value.");
        }
        this.bboxSize = newValue;
        return this;
    }

    public SegmentedVolumeData setBboxSize(SFVec3f newValue) {
        this.setBboxSize(newValue.getPrimitiveValue());
        return this;
    }

    public SegmentedVolumeData setBboxSize(float x, float y, float z) {
        this.setBboxSize(new float[]{x, y, z});
        return this;
    }

    public SegmentedVolumeData setBboxSize(double x, double y, double z) {
        return this.setBboxSize(new SFVec3f(x, y, z));
    }

    public SegmentedVolumeData setBboxSize(double[] newArray) {
        return this.setBboxSize(new SFVec3f(newArray));
    }

    @Override
    public float[] getDimensions() {
        return this.dimensions;
    }

    @Override
    public SegmentedVolumeData setDimensions(float[] newValue) {
        if (newValue == null) {
            newValue = new float[]{};
        }
        if (newValue.length != 3) {
            throw new InvalidFieldValueException("SegmentedVolumeData dimensions newValue=" + SFVec3f.toString(newValue) + " has length=" + newValue.length + " instead of required length 3");
        }
        if (newValue[0] <= 0.0f || newValue[1] <= 0.0f || newValue[2] <= 0.0f) {
            throw new InvalidFieldValueException("SegmentedVolumeData dimensions newValue=" + newValue + " has component value less than (or equal to) restriction minExclusive=0");
        }
        this.dimensions = newValue;
        return this;
    }

    public SegmentedVolumeData setDimensions(SFVec3f newValue) {
        this.setDimensions(newValue.getPrimitiveValue());
        return this;
    }

    public SegmentedVolumeData setDimensions(float x, float y, float z) {
        this.setDimensions(new float[]{x, y, z});
        return this;
    }

    public SegmentedVolumeData setDimensions(double x, double y, double z) {
        return this.setDimensions(new SFVec3f(x, y, z));
    }

    public SegmentedVolumeData setDimensions(double[] newArray) {
        return this.setDimensions(new SFVec3f(newArray));
    }

    @Override
    public IS getIS() {
        return this.IS;
    }

    @Override
    public SegmentedVolumeData setIS(IS newValue) {
        this.IS = newValue;
        if (newValue != null) {
            this.IS.setParent(this);
        }
        return this;
    }

    public SegmentedVolumeData clearIS() {
        this.IS.clearParent();
        this.IS = null;
        return this;
    }

    public boolean hasIS() {
        return this.IS != null;
    }

    @Override
    public X3DMetadataObject getMetadata() {
        return this.metadata;
    }

    @Override
    public SegmentedVolumeData setMetadata(X3DMetadataObject newValue) {
        this.metadata = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(this);
        }
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
            this.metadataProtoInstance = null;
        }
        return this;
    }

    public SegmentedVolumeData clearMetadata() {
        ((X3DConcreteElement)((Object)this.metadata)).clearParent();
        this.metadata = null;
        return this;
    }

    @Override
    public SegmentedVolumeData setMetadata(ProtoInstance newValue) {
        if (this.metadataProtoInstance != null) {
            this.metadataProtoInstance.setParent(null);
        }
        this.metadataProtoInstance = newValue;
        if (newValue != null) {
            this.metadataProtoInstance.setParent(this);
            this.metadataProtoInstance.setContainerField("metadata");
        }
        if (this.metadata != null) {
            ((X3DConcreteElement)((Object)this.metadata)).setParent(null);
            this.metadata = null;
        }
        return this;
    }

    private ProtoInstance getMetadataProtoInstance() {
        return this.metadataProtoInstance;
    }

    public boolean hasMetadata() {
        return this.metadata != null || this.metadataProtoInstance != null;
    }

    @Override
    public X3DNode[] getRenderStyle() {
        X3DNode[] valuesArray = new X3DNode[this.renderStyle.size()];
        int i = 0;
        for (X3DNode arrayElement : this.renderStyle) {
            valuesArray[i++] = arrayElement;
        }
        return valuesArray;
    }

    public ArrayList<X3DNode> getRenderStyleList() {
        return this.renderStyle;
    }

    @Override
    public SegmentedVolumeData setRenderStyle(X3DNode[] newValue) {
        if (newValue == null) {
            this.clearRenderStyle();
            return this;
        }
        this.clearRenderStyle();
        for (int i = 0; i < newValue.length; ++i) {
            if (!(newValue[i] instanceof X3DNode) && !(newValue[i] instanceof ProtoInstance)) {
                throw new InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode[] newValue[" + i + "] is not instanceof org.web3d.x3d.sai.Core.X3DNode or ProtoInstance array newValue=" + Arrays.toString(newValue));
            }
            this.renderStyle.add(newValue[i]);
            ((X3DConcreteElement)((Object)newValue[i])).setParent(this);
        }
        return this;
    }

    public SegmentedVolumeData setRenderStyle(ArrayList<X3DVolumeRenderStyleNode> newValue) {
        if (newValue == null) {
            this.clearRenderStyle();
            return this;
        }
        if (newValue.isEmpty()) {
            this.clearRenderStyle();
        } else {
            X3DNode[] newArray = new X3DNode[newValue.size()];
            for (int i = 0; i < newValue.size(); ++i) {
                newArray[i] = newValue.get(i);
            }
            this.setRenderStyle(newArray);
        }
        for (X3DVolumeRenderStyleNode element : newValue) {
            this.renderStyle.add(element);
            ((X3DConcreteElement)((Object)element)).setParent(this);
        }
        return this;
    }

    public SegmentedVolumeData addRenderStyle(X3DNode newValue) {
        if (newValue == null) {
            return this;
        }
        this.renderStyle.add(newValue);
        ((X3DConcreteElement)((Object)newValue)).setParent(this);
        return this;
    }

    public SegmentedVolumeData addRenderStyle(ProtoInstance newValue) {
        if (newValue == null) {
            return this;
        }
        this.renderStyle.add(newValue);
        newValue.setParent(this);
        return this;
    }

    @Override
    public void addRenderStyle(X3DNode[] newValue) {
        if (newValue == null) {
            return;
        }
        for (int i = 0; i < newValue.length; ++i) {
            if (newValue[i] instanceof X3DNode || newValue[i] instanceof ProtoInstance) {
                this.renderStyle.add(newValue[i]);
                ((X3DConcreteElement)((Object)newValue[i])).setParent(this);
                if (!(newValue[i] instanceof ProtoInstance)) continue;
                ((ProtoInstance)newValue[i]).setContainerField("renderStyle");
                continue;
            }
            throw new InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode[] newValue[" + i + "] is not instanceof org.web3d.x3d.sai.Core.X3DNode or ProtoInstance, array newValue=" + Arrays.toString(newValue));
        }
    }

    @Override
    public void setRenderStyle(X3DNode newValue) {
        if (newValue == null) {
            this.clearRenderStyle();
            return;
        }
        if (newValue instanceof X3DNode) {
            for (X3DNode element : this.renderStyle) {
                ((X3DConcreteElement)((Object)element)).clearParent();
            }
        } else {
            throw new InvalidFieldValueException("org.web3d.x3d.sai.Core.X3DNode newValue is not instanceof org.web3d.x3d.sai.Core.X3DNode; newValue=" + newValue);
        }
        this.clearRenderStyle();
        ((X3DConcreteElement)((Object)newValue)).setParent(this);
        this.renderStyle.add(newValue);
    }

    public SegmentedVolumeData clearRenderStyle() {
        for (X3DNode element : this.renderStyle) {
            ((X3DConcreteElement)((Object)element)).clearParent();
        }
        this.renderStyle.clear();
        return this;
    }

    public boolean hasRenderStyle() {
        return !this.renderStyle.isEmpty();
    }

    @Override
    public boolean[] getSegmentEnabled() {
        boolean[] valuesArray = new boolean[this.segmentEnabled.size()];
        int i = 0;
        for (Boolean arrayElement : this.segmentEnabled) {
            valuesArray[i++] = arrayElement;
        }
        return valuesArray;
    }

    public ArrayList<Boolean> getSegmentEnabledList() {
        return this.segmentEnabled;
    }

    public String getSegmentEnabledString() {
        StringBuilder result = new StringBuilder();
        for (Boolean arrayElement : this.segmentEnabled) {
            result.append(arrayElement.toString());
            result.append(" ");
        }
        return result.toString().trim();
    }

    @Override
    public SegmentedVolumeData setSegmentEnabled(boolean[] newValue) {
        if (newValue == null) {
            this.clearSegmentEnabled();
            return this;
        }
        this.clearSegmentEnabled();
        for (int i = 0; i < newValue.length; ++i) {
            this.segmentEnabled.add(newValue[i]);
        }
        return this;
    }

    public SegmentedVolumeData setSegmentEnabled(MFBool newValue) {
        if (newValue == null) {
            this.clearSegmentEnabled();
            return this;
        }
        this.setSegmentEnabled(newValue.getPrimitiveValue());
        return this;
    }

    public SegmentedVolumeData setSegmentEnabled(ArrayList<Boolean> newValue) {
        if (newValue == null) {
            this.clearSegmentEnabled();
            return this;
        }
        if (newValue.isEmpty()) {
            this.clearSegmentEnabled();
        } else {
            boolean[] newArray = new boolean[newValue.size()];
            for (int i = 0; i < newValue.size(); ++i) {
                newArray[i] = newValue.get(i);
            }
            this.setSegmentEnabled(newArray);
        }
        return this;
    }

    public SegmentedVolumeData clearSegmentEnabled() {
        this.segmentEnabled.clear();
        return this;
    }

    public SegmentedVolumeData addSegmentEnabled(boolean newValue) {
        this.segmentEnabled.add(newValue);
        return this;
    }

    public SegmentedVolumeData addSegmentEnabled(SFBool newValue) {
        if (newValue == null) {
            return this;
        }
        this.segmentEnabled.add(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public X3DTexture3DNode getSegmentIdentifiers() {
        return this.segmentIdentifiers;
    }

    @Override
    public SegmentedVolumeData setSegmentIdentifiers(X3DTexture3DNode newValue) {
        this.segmentIdentifiers = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.segmentIdentifiers)).setParent(this);
        }
        if (this.segmentIdentifiersProtoInstance != null) {
            this.segmentIdentifiersProtoInstance.setParent(null);
            this.segmentIdentifiersProtoInstance = null;
        }
        return this;
    }

    public SegmentedVolumeData clearSegmentIdentifiers() {
        ((X3DConcreteElement)((Object)this.segmentIdentifiers)).clearParent();
        this.segmentIdentifiers = null;
        return this;
    }

    public SegmentedVolumeData setSegmentIdentifiers(ProtoInstance newValue) {
        if (this.segmentIdentifiersProtoInstance != null) {
            this.segmentIdentifiersProtoInstance.setParent(null);
        }
        this.segmentIdentifiersProtoInstance = newValue;
        if (newValue != null) {
            this.segmentIdentifiersProtoInstance.setParent(this);
            this.segmentIdentifiersProtoInstance.setContainerField("segmentIdentifiers");
        }
        if (this.segmentIdentifiers != null) {
            ((X3DConcreteElement)((Object)this.segmentIdentifiers)).setParent(null);
            this.segmentIdentifiers = null;
        }
        return this;
    }

    private ProtoInstance getSegmentIdentifiersProtoInstance() {
        return this.segmentIdentifiersProtoInstance;
    }

    public boolean hasSegmentIdentifiers() {
        return this.segmentIdentifiers != null || this.segmentIdentifiersProtoInstance != null;
    }

    @Override
    public boolean getVisible() {
        return this.visible;
    }

    @Override
    public SegmentedVolumeData setVisible(boolean newValue) {
        this.visible = newValue;
        return this;
    }

    public SegmentedVolumeData setVisible(SFBool newValue) {
        this.setVisible(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public X3DTexture3DNode getVoxels() {
        return this.voxels;
    }

    @Override
    public SegmentedVolumeData setVoxels(X3DTexture3DNode newValue) {
        this.voxels = newValue;
        if (newValue != null) {
            ((X3DConcreteElement)((Object)this.voxels)).setParent(this);
        }
        if (this.voxelsProtoInstance != null) {
            this.voxelsProtoInstance.setParent(null);
            this.voxelsProtoInstance = null;
        }
        return this;
    }

    public SegmentedVolumeData clearVoxels() {
        ((X3DConcreteElement)((Object)this.voxels)).clearParent();
        this.voxels = null;
        return this;
    }

    public SegmentedVolumeData setVoxels(ProtoInstance newValue) {
        if (this.voxelsProtoInstance != null) {
            this.voxelsProtoInstance.setParent(null);
        }
        this.voxelsProtoInstance = newValue;
        if (newValue != null) {
            this.voxelsProtoInstance.setParent(this);
            this.voxelsProtoInstance.setContainerField("voxels");
        }
        if (this.voxels != null) {
            ((X3DConcreteElement)((Object)this.voxels)).setParent(null);
            this.voxels = null;
        }
        return this;
    }

    private ProtoInstance getVoxelsProtoInstance() {
        return this.voxelsProtoInstance;
    }

    public boolean hasVoxels() {
        return this.voxels != null || this.voxelsProtoInstance != null;
    }

    @Override
    public String getDEF() {
        return super.getDEF();
    }

    @Override
    public final SegmentedVolumeData setDEF(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("SegmentedVolumeData DEF newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteUSE("");
        this.setConcreteDEF(newValue);
        return this;
    }

    public SegmentedVolumeData setDEF(SFString newValue) {
        this.setDEF(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getUSE() {
        return super.getUSE();
    }

    @Override
    public final SegmentedVolumeData setUSE(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        if (!newValue.isEmpty() && !SFString.isNMTOKEN(newValue)) {
            throw new InvalidFieldValueException("SegmentedVolumeData USE newValue='" + newValue + "' has illegal name value, cannot be empty and must be defined with valid NMTOKEN name string (with legal characters and no embedded whitespace).");
        }
        this.setConcreteDEF("");
        this.setConcreteUSE(newValue);
        return this;
    }

    public SegmentedVolumeData setUSE(SFString newValue) {
        this.setUSE(newValue.getPrimitiveValue());
        return this;
    }

    @Override
    public String getCssClass() {
        return super.getCssClass();
    }

    @Override
    public final SegmentedVolumeData setCssClass(String newValue) {
        if (newValue == null) {
            newValue = new String();
        }
        this.setConcreteCssClass(newValue);
        return this;
    }

    public SegmentedVolumeData setCssClass(SFString newValue) {
        this.setCssClass(newValue.getPrimitiveValue());
        return this;
    }

    public SegmentedVolumeData setUSE(SegmentedVolumeData DEFnode) {
        if (DEFnode.getDEF().isEmpty()) {
            String errorNotice = "setUSE(DEFnode) invoked on SegmentedVolumeData that has no DEF name defined, thus a copy cannot be referenced as a USE node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.setUSE(DEFnode.getDEF());
        return this;
    }

    public SegmentedVolumeData(String DEFlabel) {
        this.initialize();
        this.setDEF(DEFlabel);
    }

    @Override
    public SegmentedVolumeData addComments(String newComment) {
        if (this.isUSE()) {
            String errorNotice = "addComments(\"" + newComment + "\")\ncannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.add(newComment);
        return this;
    }

    @Override
    public SegmentedVolumeData addComments(String[] newComments) {
        if (this.isUSE()) {
            String errorNotice = "addComments(" + Arrays.toString(newComments) + ")\ncannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.addAll(Arrays.asList(newComments));
        return this;
    }

    @Override
    public SegmentedVolumeData addComments(CommentsBlock newCommentsBlock) {
        if (this.isUSE()) {
            String errorNotice = "addComments(CommentsBlock) cannot be applied to a USE node (USE='" + this.getUSE() + "') which only contains a reference to a DEF node";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        this.commentsList.addAll(newCommentsBlock.toStringList());
        return this;
    }

    @Override
    public String toStringX3D(int indentLevel) {
        boolean hasChild;
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || !this.renderStyle.isEmpty() || this.segmentIdentifiers != null || this.segmentIdentifiersProtoInstance != null || this.voxels != null || this.voxelsProtoInstance != null || !this.commentsList.isEmpty();
        if (this.isUSE()) {
            hasChild = false;
        }
        StringBuilder indent = new StringBuilder();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        StringBuilder stringX3D = new StringBuilder();
        stringX3D.append((CharSequence)indent).append("<SegmentedVolumeData");
        if (hasAttributes) {
            if (!this.getDEF().equals("") && !this.isUSE()) {
                stringX3D.append(" DEF='").append(SFString.toString(this.getDEF())).append("'");
            }
            if (!this.getUSE().equals("")) {
                stringX3D.append(" USE='").append(SFString.toString(this.getUSE())).append("'");
            }
            if (!this.getContainerFieldOverride().isEmpty() && !this.getContainerFieldOverride().equals(this.getContainerFieldDefault())) {
                stringX3D.append(" containerField='").append(this.getContainerFieldOverride()).append("'");
            }
            if (!(Arrays.equals(this.getBboxCenter(), BBOXCENTER_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" bboxCenter='").append(SFVec3f.toString(this.getBboxCenter())).append("'");
            }
            if (!(!this.getBboxDisplay() && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" bboxDisplay='").append(SFBool.toString(this.getBboxDisplay())).append("'");
            }
            if (!(Arrays.equals(this.getBboxSize(), BBOXSIZE_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" bboxSize='").append(SFVec3f.toString(this.getBboxSize())).append("'");
            }
            if (!(this.getCssClass().equals("") && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" class='").append(new SFString(this.getCssClass()).toStringX3D()).append("'");
            }
            if (!(Arrays.equals(this.getDimensions(), DIMENSIONS_DEFAULT_VALUE) && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" dimensions='").append(SFVec3f.toString(this.getDimensions())).append("'");
            }
            if (!(this.getSegmentEnabled().length <= 0 && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" segmentEnabled='").append(MFBool.toString(this.getSegmentEnabled())).append("'");
            }
            if (!(this.getVisible() && ConfigurationProperties.getStripDefaultAttributes() || this.isUSE())) {
                stringX3D.append(" visible='").append(SFBool.toString(this.getVisible())).append("'");
            }
        }
        if (hasChild && !this.isUSE()) {
            stringX3D.append(">").append("\n");
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringX3D.append(commentsBlock.toStringX3D(indentLevel + indentIncrement));
            }
            if (this.metadata != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.metadata)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.metadataProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.metadataProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.IS != null) {
                stringX3D.append(((X3DConcreteElement)this.IS).toStringX3D(indentLevel + indentIncrement));
            }
            for (X3DNode element : this.renderStyle) {
                stringX3D.append(((X3DConcreteElement)((Object)element)).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.segmentIdentifiers != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.segmentIdentifiers)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.segmentIdentifiersProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.segmentIdentifiersProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            if (this.voxels != null) {
                stringX3D.append(((X3DConcreteElement)((Object)this.voxels)).toStringX3D(indentLevel + indentIncrement));
            } else if (this.voxelsProtoInstance != null) {
                stringX3D.append(((X3DConcreteElement)this.voxelsProtoInstance).toStringX3D(indentLevel + indentIncrement));
            }
            stringX3D.append((CharSequence)indent).append("</SegmentedVolumeData>").append("\n");
        } else {
            stringX3D.append("/>").append("\n");
        }
        return stringX3D.toString();
    }

    @Override
    public String toStringClassicVRML(int indentLevel) {
        boolean hasChild;
        StringBuilder stringClassicVRML = new StringBuilder();
        boolean hasAttributes = true;
        boolean bl = hasChild = this.IS != null || this.IS != null || this.metadata != null || this.metadataProtoInstance != null || !this.renderStyle.isEmpty() || this.segmentIdentifiers != null || this.segmentIdentifiersProtoInstance != null || this.voxels != null || this.voxelsProtoInstance != null || !this.commentsList.isEmpty();
        if (this.isUSE()) {
            hasAttributes = false;
            hasChild = false;
        }
        StringBuilder indent = new StringBuilder();
        char indentCharacter = ConfigurationProperties.getIndentCharacter();
        int indentIncrement = ConfigurationProperties.getIndentIncrement();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(indentCharacter);
        }
        if (!this.getDEF().equals("")) {
            stringClassicVRML.append("DEF ").append(SFString.toString(this.getDEF())).append(" ");
        }
        if (!this.getUSE().equals("")) {
            stringClassicVRML.append("USE ").append(SFString.toString(this.getUSE())).append("\n");
        } else {
            stringClassicVRML.append(NAME).append(" { ");
            if (hasAttributes || hasChild) {
                stringClassicVRML.append("\n").append((CharSequence)indent).append(indentCharacter);
            }
            if (hasAttributes) {
                boolean hasISconnect;
                boolean bl2 = hasISconnect = this.getIS() != null && !this.getIS().getConnectList().isEmpty();
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("bboxCenter")) continue;
                        stringClassicVRML.append(indentCharacter).append("bboxCenter").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getBboxCenter(), BBOXCENTER_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("bboxCenter ").append(SFVec3f.toString(this.getBboxCenter())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("bboxDisplay")) continue;
                        stringClassicVRML.append(indentCharacter).append("bboxDisplay").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getBboxDisplay() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("bboxDisplay ").append(SFBool.toString(this.getBboxDisplay())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("bboxSize")) continue;
                        stringClassicVRML.append(indentCharacter).append("bboxSize").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getBboxSize(), BBOXSIZE_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("bboxSize ").append(SFVec3f.toString(this.getBboxSize())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("class")) continue;
                        stringClassicVRML.append(indentCharacter).append("class").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getCssClass().equals("") || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("# class ").append("\"").append(SFString.toString(this.getCssClass())).append("\"").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("dimensions")) continue;
                        stringClassicVRML.append(indentCharacter).append("dimensions").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!Arrays.equals(this.getDimensions(), DIMENSIONS_DEFAULT_VALUE) || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("dimensions ").append(SFVec3f.toString(this.getDimensions())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("segmentEnabled")) continue;
                        stringClassicVRML.append(indentCharacter).append("segmentEnabled").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (this.getSegmentEnabled().length > 0 || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("segmentEnabled ").append("[ ").append(MFBool.toString(this.getSegmentEnabled())).append(" ]").append("\n").append((CharSequence)indent).append(indentCharacter);
                }
                if (hasISconnect) {
                    for (connect element : this.getIS().getConnectList()) {
                        if (!element.getNodeField().equals("visible")) continue;
                        stringClassicVRML.append(indentCharacter).append("visible").append(" IS ").append(element.getProtoField()).append("\n").append((CharSequence)indent).append(indentCharacter);
                    }
                } else if (!this.getVisible() || !ConfigurationProperties.getStripDefaultAttributes()) {
                    stringClassicVRML.append("visible ").append(SFBool.toString(this.getVisible())).append("\n").append((CharSequence)indent).append(indentCharacter);
                }
            }
        }
        if (hasChild) {
            if (this.metadata != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.metadata)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.metadataProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("metadata").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.metadataProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (this.IS != null) {
                stringClassicVRML.append(((X3DConcreteElement)this.IS).toStringClassicVRML(indentLevel));
            }
            if (this.renderStyle.size() > 0) {
                stringClassicVRML.append(indentCharacter).append(indentCharacter).append("renderStyle").append(" [").append("\n").append((CharSequence)indent).append(indentCharacter).append(indentCharacter);
                for (X3DNode element : this.renderStyle) {
                    stringClassicVRML.append(((X3DConcreteElement)((Object)element)).toStringClassicVRML(indentLevel + indentIncrement + indentIncrement));
                }
                stringClassicVRML.append((CharSequence)indent).append(indentCharacter).append(indentCharacter).append("]").append("\n").append((CharSequence)indent);
            }
            if (this.segmentIdentifiers != null) {
                stringClassicVRML.append(indentCharacter).append("segmentIdentifiers").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.segmentIdentifiers)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.segmentIdentifiersProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("segmentIdentifiers").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.segmentIdentifiersProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (this.voxels != null) {
                stringClassicVRML.append(indentCharacter).append("voxels").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)((Object)this.voxels)).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            } else if (this.voxelsProtoInstance != null) {
                stringClassicVRML.append(indentCharacter).append("voxels").append(" ");
                stringClassicVRML.append(((X3DConcreteElement)this.voxelsProtoInstance).toStringClassicVRML(indentLevel + indentIncrement));
                stringClassicVRML.append((CharSequence)indent);
            }
            if (!this.commentsList.isEmpty()) {
                CommentsBlock commentsBlock = new CommentsBlock(this.commentsList);
                stringClassicVRML.append(commentsBlock.toStringClassicVRML(indentLevel));
                stringClassicVRML.append((CharSequence)indent);
            }
        }
        if (hasAttributes || hasChild) {
            stringClassicVRML.append("}").append("\n");
        }
        return stringClassicVRML.toString();
    }

    @Override
    public String toStringVRML97(int indentLevel) {
        return this.toStringClassicVRML(indentLevel);
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue) {
        return this.findElementByNameValue(nameValue, "");
    }

    @Override
    public X3DConcreteElement findElementByNameValue(String nameValue, String elementName) {
        X3DConcreteElement referenceElement;
        if (nameValue == null || nameValue.isEmpty()) {
            String errorNotice = "findElementByNameValue(\"\", " + elementName + ") cannot use empty string to find a name attribute";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.IS != null && (referenceElement = ((X3DConcreteElement)this.IS).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadata != null && (referenceElement = ((X3DConcreteElement)((Object)this.metadata)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.metadataProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.metadataProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        for (X3DNode element : this.renderStyle) {
            if (!(element instanceof X3DConcreteElement) || (referenceElement = ((X3DConcreteElement)((Object)element)).findElementByNameValue(nameValue, elementName)) == null) continue;
            return referenceElement;
        }
        if (this.segmentIdentifiers != null && (referenceElement = ((X3DConcreteElement)((Object)this.segmentIdentifiers)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.segmentIdentifiersProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.segmentIdentifiersProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.voxels != null && (referenceElement = ((X3DConcreteElement)((Object)this.voxels)).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        if (this.voxelsProtoInstance != null && (referenceElement = ((X3DConcreteElement)this.voxelsProtoInstance).findElementByNameValue(nameValue, elementName)) != null) {
            return referenceElement;
        }
        return null;
    }

    public boolean hasElementByNameValue(String nameValue, String elementName) {
        return this.findElementByNameValue(nameValue, elementName) != null;
    }

    @Override
    public X3DConcreteNode findNodeByDEF(String DEFvalue) {
        X3DConcreteNode referenceNode;
        if (DEFvalue == null || DEFvalue.isEmpty()) {
            String errorNotice = "findNodeByDEF(\"\") cannot use empty string to find a name";
            this.validationResult.append(errorNotice).append("\n");
            throw new InvalidFieldValueException(errorNotice);
        }
        if (this.getDEF().equals(DEFvalue)) {
            return this;
        }
        if (this.IS != null && (referenceNode = ((X3DConcreteElement)this.IS).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadata != null && (referenceNode = ((X3DConcreteElement)((Object)this.metadata)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.metadataProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.metadataProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        for (X3DNode element : this.renderStyle) {
            if (!(element instanceof X3DConcreteNode) || (referenceNode = ((X3DConcreteElement)((Object)element)).findNodeByDEF(DEFvalue)) == null) continue;
            return referenceNode;
        }
        if (this.segmentIdentifiers != null && (referenceNode = ((X3DConcreteElement)((Object)this.segmentIdentifiers)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.segmentIdentifiersProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.segmentIdentifiersProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.voxels != null && (referenceNode = ((X3DConcreteElement)((Object)this.voxels)).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        if (this.voxelsProtoInstance != null && (referenceNode = ((X3DConcreteElement)this.voxelsProtoInstance).findNodeByDEF(DEFvalue)) != null) {
            return referenceNode;
        }
        return null;
    }

    public boolean hasNodeByDEF(String DEFvalue) {
        return this.findNodeByDEF(DEFvalue) != null;
    }

    @Override
    public String validate() {
        Object errorNotice6;
        this.validationResult = new StringBuilder();
        this.setBboxCenter(this.getBboxCenter());
        this.setBboxDisplay(this.getBboxDisplay());
        this.setBboxSize(this.getBboxSize());
        this.setDimensions(this.getDimensions());
        this.setSegmentEnabled(this.getSegmentEnabled());
        this.setVisible(this.getVisible());
        if (!this.isUSE()) {
            this.setDEF(this.getDEF());
        }
        if (this.isUSE()) {
            this.setUSE(this.getUSE());
        }
        this.setCssClass(this.getCssClass());
        if (this.IS != null) {
            this.setIS(this.getIS());
            ((X3DConcreteElement)this.IS).validate();
            this.validationResult.append(this.IS.getValidationResult());
        }
        if (this.isUSE() && this.hasIS()) {
            String errorNotice2 = "SegmentedVolumeData USE='" + this.getUSE() + "' is not allowed to have contained SFNode IS";
            this.validationResult.append(errorNotice2);
            throw new InvalidFieldValueException(errorNotice2);
        }
        if (this.isUSE() && !this.commentsList.isEmpty()) {
            String errorNotice3 = "SegmentedVolumeData USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice3);
            throw new InvalidFieldValueException(errorNotice3);
        }
        if (this.metadata != null) {
            this.setMetadata(this.getMetadata());
            ((X3DConcreteElement)((Object)this.metadata)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.metadata)).getValidationResult());
        }
        if (this.metadataProtoInstance != null) {
            this.setMetadata(this.getMetadataProtoInstance());
            ((X3DConcreteElement)this.metadataProtoInstance).validate();
            this.validationResult.append(this.metadataProtoInstance.getValidationResult());
        }
        if (this.metadata != null && this.metadataProtoInstance != null) {
            String errorNotice4 = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both metadata and metadataProtoInstance are set simultaneously";
            this.validationResult.append(errorNotice4);
            throw new InvalidProtoException(errorNotice4);
        }
        if (this.isUSE() && this.hasMetadata()) {
            String errorNotice5 = "SegmentedVolumeData USE='" + this.getUSE() + "' is not allowed to have contained SFNode metadata";
            this.validationResult.append(errorNotice5);
            throw new InvalidFieldValueException(errorNotice5);
        }
        if (this.isUSE() && !this.commentsList.isEmpty()) {
            String errorNotice6 = "SegmentedVolumeData USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append(errorNotice6);
            throw new InvalidFieldValueException(errorNotice6);
        }
        for (X3DNode element : this.renderStyle) {
            ((X3DConcreteElement)((Object)element)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)element)).getValidationResult());
        }
        this.setRenderStyle(this.getRenderStyle());
        if (this.isUSE() && this.hasRenderStyle()) {
            errorNotice6 = "SegmentedVolumeData USE='" + this.getUSE() + "' is not allowed to have contained MFNode renderStyle";
            this.validationResult.append((String)errorNotice6);
            throw new InvalidFieldValueException((String)errorNotice6);
        }
        if (this.segmentIdentifiers != null) {
            this.setSegmentIdentifiers(this.getSegmentIdentifiers());
            ((X3DConcreteElement)((Object)this.segmentIdentifiers)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.segmentIdentifiers)).getValidationResult());
        }
        if (this.segmentIdentifiersProtoInstance != null) {
            this.setSegmentIdentifiers(this.getSegmentIdentifiersProtoInstance());
            ((X3DConcreteElement)this.segmentIdentifiersProtoInstance).validate();
            this.validationResult.append(this.segmentIdentifiersProtoInstance.getValidationResult());
        }
        if (this.segmentIdentifiers != null && this.segmentIdentifiersProtoInstance != null) {
            errorNotice6 = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both segmentIdentifiers and segmentIdentifiersProtoInstance are set simultaneously";
            this.validationResult.append((String)errorNotice6);
            throw new InvalidProtoException((String)errorNotice6);
        }
        if (this.isUSE() && this.hasSegmentIdentifiers()) {
            errorNotice6 = "SegmentedVolumeData USE='" + this.getUSE() + "' is not allowed to have contained SFNode segmentIdentifiers";
            this.validationResult.append((String)errorNotice6);
            throw new InvalidFieldValueException((String)errorNotice6);
        }
        if (this.isUSE() && !this.commentsList.isEmpty()) {
            errorNotice6 = "SegmentedVolumeData USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append((String)errorNotice6);
            throw new InvalidFieldValueException((String)errorNotice6);
        }
        if (this.voxels != null) {
            this.setVoxels(this.getVoxels());
            ((X3DConcreteElement)((Object)this.voxels)).validate();
            this.validationResult.append(((X3DConcreteElement)((Object)this.voxels)).getValidationResult());
        }
        if (this.voxelsProtoInstance != null) {
            this.setVoxels(this.getVoxelsProtoInstance());
            ((X3DConcreteElement)this.voxelsProtoInstance).validate();
            this.validationResult.append(this.voxelsProtoInstance.getValidationResult());
        }
        if (this.voxels != null && this.voxelsProtoInstance != null) {
            errorNotice6 = "Internal X3DJSAIL error: incorrect handling of contained SFNode field, both voxels and voxelsProtoInstance are set simultaneously";
            this.validationResult.append((String)errorNotice6);
            throw new InvalidProtoException((String)errorNotice6);
        }
        if (this.isUSE() && this.hasVoxels()) {
            errorNotice6 = "SegmentedVolumeData USE='" + this.getUSE() + "' is not allowed to have contained SFNode voxels";
            this.validationResult.append((String)errorNotice6);
            throw new InvalidFieldValueException((String)errorNotice6);
        }
        if (this.isUSE() && !this.commentsList.isEmpty()) {
            errorNotice6 = "SegmentedVolumeData USE='" + this.getUSE() + "' is not allowed to have contained comments";
            this.validationResult.append((String)errorNotice6);
            throw new InvalidFieldValueException((String)errorNotice6);
        }
        if (this.getIS() != null && this.getIS().getConnectList().isEmpty()) {
            errorNotice6 = "IS statement present, but contains no connect statements";
            this.validationResult.append((String)errorNotice6).append("\n");
            throw new InvalidProtoException((String)errorNotice6);
        }
        if (!this.getContainerFieldOverride().isEmpty() && !Arrays.asList(this.containerField_ALTERNATE_VALUES).contains(this.getContainerFieldOverride())) {
            errorNotice6 = "ERROR_ILLEGAL_VALUE: illegal value encountered, containerField='" + this.getContainerFieldOverride() + "' but allowed values are containerField_ALTERNATE_VALUES='" + new MFString(this.containerField_ALTERNATE_VALUES).toStringX3D() + "'.";
            this.validationResult.append((String)errorNotice6).append("\n");
            throw new InvalidFieldException((String)errorNotice6);
        }
        if (this.findAncestorX3D() != null) {
            String modelProfile = this.findAncestorX3D().getProfile();
            boolean hasSatisfactorySupport = this.findAncestorX3D().supportsX3dComponent(COMPONENT, 2);
            if (!hasSatisfactorySupport) {
                String errorNotice7 = "ERROR_ILLEGAL_VALUE insufficient X3D profile='" + modelProfile + "' for parent X3D model containing 'SegmentedVolumeData' node, add head statement <component name='VolumeRendering' level='2'/>\nor Java source-code assignment:  findAncestorX3D().getHead().addComponent(\"VolumeRendering\").setLevel(2);";
                this.validationResult.append(errorNotice7).append("\n");
                throw new InvalidFieldException(errorNotice7);
            }
        }
        return this.validationResult.toString();
    }
}

