/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.syntheticaaddons.SyntheticaAddons;
import de.javasoft.syntheticaaddons.systemmonitor.Collector;
import de.javasoft.syntheticaaddons.systemmonitor.ModelChangedEvent;
import de.javasoft.syntheticaaddons.systemmonitor.ModelChangedListener;
import de.javasoft.syntheticaaddons.systemmonitor.SystemMonitorModel;
import de.javasoft.syntheticaaddons.ui.SystemMonitorUI;
import de.javasoft.syntheticaaddons.ui.addons.SystemMonitorAddon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jdesktop.swingx.plaf.ComponentAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class SystemMonitor
extends JPanel
implements ModelChangedListener {
    private static final long serialVersionUID = 4415684173640314897L;
    public static final String uiClassID = "SystemMonitorUI";
    private boolean autoStop = false;
    private SystemMonitorModel model = null;
    private RepaintThread repaintThread = null;
    private Color gridColor = null;
    private Integer gridSize = null;
    private Integer gradientStartAlpha = null;
    private Integer gradientEndAlpha = null;
    private boolean spotlightEnabled = true;
    private int refreshTime = 1000;
    private int collectorBufferSize = 400;
    private int collectorDelay = 500;
    private LinkedHashMap<String, JLabel> valueLabels = new LinkedHashMap();
    private HashMap<String, String> popupMenuCaptions = new HashMap();
    private Integer popupMonitorGridSize = 0;
    private int popupMonitorWidth = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(300));
    private int popupMonitorHeight = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(150));

    static {
        SyntheticaAddons.contribute((ComponentAddon)new SystemMonitorAddon());
    }

    public SystemMonitor() {
        this(true);
    }

    public SystemMonitor(boolean autoStop) {
        this.autoStop = autoStop;
        this.setModel(new SystemMonitorModel());
        this.setPopupMonitorGridSize(this.getGridSize());
        this.addAncestorListener(new MonitorAncestorListener());
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                SystemMonitor.this.initPopupMenu((JPopupMenu)e.getSource());
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.setComponentPopupMenu(popupMenu);
        this.enableEvents(16L);
        this.updateUI();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(LookAndFeelAddons.getUI((JComponent)this, SystemMonitorUI.class));
        if (this.getComponentPopupMenu() != null) {
            this.getComponentPopupMenu().updateUI();
        }
    }

    public void addCollector(String id, Collector collector) {
        this.addCollector(id, this.collectorDelay, collector);
    }

    public void addCollector(String id, int delay, Collector collector) {
        this.addCollector(id, this.collectorBufferSize, delay, collector);
    }

    public void addCollector(String id, int bufferSize, int delay, Collector collector) {
        this.model.addCollector(id, bufferSize, delay, collector);
    }

    public void stop() {
        this.stopRepaintThread();
        this.model.removeAll();
    }

    public void stopRepaintThread() {
        if (this.repaintThread != null) {
            this.repaintThread.interrupt();
        }
    }

    protected void initPopupMenu(JPopupMenu popupMenu) {
        popupMenu.removeAll();
        for (String id : this.getModel().getIds()) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(new VisibilityAction(id));
            item.setSelected(this.getVisible(id));
            popupMenu.add(item);
        }
    }

    public void setPopupMenuCaption(String id, String caption) {
        this.popupMenuCaptions.put(id, caption);
    }

    public Map<String, String> getPopupMenuCaptions() {
        return this.popupMenuCaptions;
    }

    public JPanel getCaptionPanel() {
        if (!(this.getLayout() instanceof BorderLayout)) {
            return null;
        }
        return (JPanel)((BorderLayout)this.getLayout()).getLayoutComponent("South");
    }

    public void addCaption(final String id, String caption, String format, boolean popupOnly) {
        JPanel panel = this.getCaptionPanel();
        boolean visible = this.getVisible(id);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = this.valueLabels.size();
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 18;
        JLabel captionLabel = new JLabel(caption){
            private static final long serialVersionUID = -4720079886913206351L;

            @Override
            public void updateUI() {
                super.updateUI();
                Color foreground = SystemMonitor.this.getColor(id) == null ? SystemMonitor.this.getForeground() : SystemMonitor.this.getColor(id);
                this.setForeground(foreground);
            }
        };
        captionLabel.setVisible(visible);
        if (!popupOnly) {
            panel.add((Component)captionLabel, gbc);
        }
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        JLabel valueLabel = new JLabel(){
            private static final long serialVersionUID = 8576091583872363920L;

            @Override
            public void updateUI() {
                super.updateUI();
                Color foreground = SystemMonitor.this.getColor(id) == null ? SystemMonitor.this.getForeground() : SystemMonitor.this.getColor(id);
                this.setForeground(foreground);
            }
        };
        valueLabel.setVisible(visible);
        valueLabel.putClientProperty("id", id);
        valueLabel.putClientProperty("caption", caption);
        valueLabel.putClientProperty("format", format);
        valueLabel.putClientProperty("popupOnly", popupOnly);
        valueLabel.putClientProperty("captionLabel", captionLabel);
        this.valueLabels.put(id, valueLabel);
        if (!popupOnly) {
            panel.add((Component)valueLabel, gbc);
        }
    }

    public void setRefreshTime(int time) {
        this.refreshTime = time;
    }

    public int getRefreshTime() {
        return this.refreshTime;
    }

    public void setModel(SystemMonitorModel model) {
        this.model = model;
        if (model != null) {
            model.addModelChangedListener(this, new int[0]);
        }
    }

    public SystemMonitorModel getModel() {
        return this.model;
    }

    public void setVisible(String id, boolean visible) {
        this.getModel().setVisible(id, visible);
    }

    public boolean getVisible(String id) {
        return this.getModel().getVisible(id);
    }

    public boolean isVisible(String id) {
        return this.getVisible(id);
    }

    public void setColor(String id, Color color) {
        if (this.getModel() != null) {
            this.getModel().setColor(id, color);
        }
    }

    public Color getColor(String id) {
        if (this.getModel() != null) {
            return this.getModel().getColor(id);
        }
        return null;
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridSize(Integer size) {
        this.gridSize = size;
    }

    public Integer getGridSize() {
        return this.gridSize;
    }

    public void setGradientStartAlpha(Integer alpha) {
        this.gradientStartAlpha = alpha;
    }

    public Integer getGradientStartAlpha() {
        return this.gradientStartAlpha;
    }

    public void setGradientEndAlpha(Integer alpha) {
        this.gradientEndAlpha = alpha;
    }

    public Integer getGradientEndAlpha() {
        return this.gradientEndAlpha;
    }

    public void setSpotlightEnabled(boolean value) {
        this.spotlightEnabled = value;
    }

    public boolean getSpotlightEnabled() {
        return this.spotlightEnabled;
    }

    public boolean isSpotlightEnabled() {
        return this.getSpotlightEnabled();
    }

    public Map<String, JLabel> getValueLabels() {
        return this.valueLabels;
    }

    public void setPopupEnabled(boolean value) {
        if (value) {
            this.setToolTipText(" ");
        } else {
            this.setToolTipText(null);
        }
    }

    public boolean getPopupEnabled() {
        return this.getToolTipText() != null;
    }

    public boolean isPopupEnabled() {
        return this.getPopupEnabled();
    }

    public void setPopupMonitorSize(Dimension d) {
        this.popupMonitorWidth = d.width;
        this.popupMonitorHeight = d.height;
    }

    public Dimension getPopupMonitorSize() {
        return new Dimension(this.popupMonitorWidth, this.popupMonitorHeight);
    }

    public void setPopupMonitorGridSize(Integer size) {
        this.popupMonitorGridSize = size;
    }

    public int getPopupMonitorGridSize() {
        return this.popupMonitorGridSize;
    }

    @Override
    public void modelChanged(ModelChangedEvent<?> evt) {
        JLabel label = this.getValueLabels().get(evt.getId());
        if (label == null) {
            return;
        }
        Object value = evt.getValue();
        switch (evt.getType()) {
            case 3: {
                label.setVisible((Boolean)value);
                ((JLabel)label.getClientProperty("captionLabel")).setVisible((Boolean)value);
                this.repaint();
                break;
            }
            case 2: {
                label.setForeground((Color)value);
                ((JLabel)label.getClientProperty("captionLabel")).setForeground((Color)value);
                this.repaint();
            }
        }
    }

    @Override
    public JToolTip createToolTip() {
        return new MonitorPopup(this);
    }

    protected SystemMonitor createPopupMonitor() {
        SystemMonitor monitor = new SystemMonitor();
        monitor.setModel(this.getModel());
        monitor.setPreferredSize(new Dimension(this.popupMonitorWidth, this.popupMonitorHeight));
        monitor.setGridSize(this.popupMonitorGridSize);
        return monitor;
    }

    private class MonitorAncestorListener
    implements AncestorListener {
        private boolean moved = false;
        private boolean added = false;

        private MonitorAncestorListener() {
        }

        @Override
        public void ancestorAdded(AncestorEvent evt) {
            this.added = true;
            if (SystemMonitor.this.repaintThread == null) {
                SystemMonitor.this.repaintThread = new RepaintThread();
            }
        }

        @Override
        public void ancestorRemoved(AncestorEvent evt) {
            if (!SystemMonitor.this.autoStop) {
                return;
            }
            this.added = false;
            this.moved = false;
            SystemMonitor monitor = (SystemMonitor)evt.getSource();
            if (monitor.getParent() instanceof MonitorPopup) {
                monitor.getModel().removeModelChangedListener(monitor);
                monitor.stopRepaintThread();
            } else {
                Container parent = evt.getAncestorParent();
                if (!(parent instanceof JTabbedPane)) {
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (!MonitorAncestorListener.this.added && !MonitorAncestorListener.this.moved) {
                                SystemMonitor.this.getModel().removeModelChangedListener(SystemMonitor.this);
                                SystemMonitor.this.stop();
                            }
                        }
                    };
                    t.setDaemon(true);
                    t.start();
                }
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent evt) {
            this.moved = true;
        }
    }

    public class MonitorPopup
    extends JToolTip {
        private static final long serialVersionUID = -3047512396032229021L;

        public MonitorPopup(SystemMonitor parent) {
            this.setName("SystemMonitor.monitorPopup");
            SystemMonitor monitor = SystemMonitor.this.createPopupMonitor();
            if (monitor.getModel() == parent.getModel()) {
                for (JLabel label : parent.getValueLabels().values()) {
                    String id = (String)label.getClientProperty("id");
                    String caption = (String)label.getClientProperty("caption");
                    String format = (String)label.getClientProperty("format");
                    monitor.addCaption(id, caption, format, false);
                    monitor.setPopupMenuCaption(id, (String)SystemMonitor.this.popupMenuCaptions.get(id));
                }
            }
            this.setLayout(new BorderLayout());
            this.add(monitor);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getLayout().preferredLayoutSize(this);
        }

        @Override
        public void setTipText(String tipText) {
        }

        @Override
        public boolean isManagingFocus() {
            return true;
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }
    }

    private class RepaintThread
    extends Thread {
        public RepaintThread() {
            this.setDaemon(true);
            this.setName("SystemMonitor RepaintThread " + SystemMonitor.this.refreshTime);
            this.start();
        }

        private void updateLabels() {
            for (String id : SystemMonitor.this.valueLabels.keySet()) {
                this.updateLabel(id);
            }
        }

        private void updateLabel(String id) {
            final JLabel label = (JLabel)SystemMonitor.this.valueLabels.get(id);
            String format = (String)label.getClientProperty("format");
            final String fformat = format.replace("{value}", "1$").replace("{maxValue}", "2$").replace("{percentValue}", "3$");
            final double lastValue = SystemMonitor.this.model.getLastValue(id);
            final double lastMaxValue = SystemMonitor.this.model.getLastMaxValue(id);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    label.setText(String.format(fformat, lastValue, lastMaxValue, lastValue / lastMaxValue * 100.0));
                }
            });
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    SystemMonitor.this.repaint();
                    this.updateLabels();
                    Thread.sleep(SystemMonitor.this.refreshTime);
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
            }
        }
    }

    private class VisibilityAction
    extends AbstractAction {
        private static final long serialVersionUID = 3588456282246735885L;
        private String id;

        public VisibilityAction(String id) {
            this.id = id;
            String caption = SystemMonitor.this.popupMenuCaptions.get(id) == null ? id : (String)SystemMonitor.this.popupMenuCaptions.get(id);
            this.putValue("Name", caption);
            this.putValue("SmallIcon", new Icon(){

                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    Color oldColor = g.getColor();
                    Color color = SystemMonitor.this.getColor(VisibilityAction.this.id);
                    if (color == null) {
                        color = SystemMonitor.this.getForeground();
                    }
                    g.setColor(SystemMonitor.this.getBackground());
                    g.fillRect(x, y, this.getIconWidth() - 1, this.getIconHeight() - 1);
                    g.setColor(color);
                    g.drawRect(x, y, this.getIconWidth() - 1, this.getIconHeight() - 1);
                    color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 128);
                    g.setColor(color);
                    g.fillRect(x, y, this.getIconWidth() - 1, this.getIconHeight() - 1);
                    g.setColor(oldColor);
                }

                @Override
                public int getIconWidth() {
                    return 16;
                }

                @Override
                public int getIconHeight() {
                    return 8;
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JCheckBoxMenuItem item = (JCheckBoxMenuItem)evt.getSource();
            SystemMonitor.this.setVisible(this.id, item.isSelected());
        }
    }
}

