/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data;

import java.io.File;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Utils {
    public static String DOM2String(Node node) throws TransformerException, TransformerFactoryConfigurationError {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        StringWriter stringWriter = new StringWriter();
        transformerFactory.newTransformer().transform(new DOMSource(node), new StreamResult(stringWriter));
        String string = stringWriter.getBuffer().toString();
        return string;
    }

    public static String DOM2HTML(Node node) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        StringWriter stringWriter = new StringWriter();
        StreamSource streamSource = new StreamSource(Utils.class.getResourceAsStream("xml2html.xslt"));
        Transformer transformer = transformerFactory.newTransformer(streamSource);
        StreamResult streamResult = new StreamResult(System.out);
        transformer.transform(new DOMSource(node), streamResult);
        return stringWriter.getBuffer().toString();
    }

    public static String leftPad(String string, int n) {
        return Utils.leftPad(string, n, ' ');
    }

    public static String leftPad(String string, int n, char c) {
        int n2 = n - string.length();
        if (n2 > 0) {
            char[] cArray = new char[n2];
            for (int i = 0; i < n2; ++i) {
                cArray[i] = c;
            }
            return new String(cArray) + string;
        }
        return string;
    }

    public static void writeXmlFile(Document document, String string) throws TransformerFactoryConfigurationError, TransformerException {
        DOMSource dOMSource = new DOMSource(document);
        File file = new File(string);
        StreamResult streamResult = new StreamResult(file);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.transform(dOMSource, streamResult);
    }

    public static void writeXmlFileAsHtml(Document document, String string) throws TransformerFactoryConfigurationError, TransformerException {
        DOMSource dOMSource = new DOMSource(document);
        File file = new File(string);
        StreamResult streamResult = new StreamResult(file);
        StreamSource streamSource = new StreamSource(Utils.class.getResourceAsStream("xml2html.xslt"));
        Transformer transformer = TransformerFactory.newInstance().newTransformer(streamSource);
        transformer.transform(dOMSource, streamResult);
    }

    public static void setDDIIdentifiableId(Element element, String string) {
        element.setAttribute("id", string);
        element.setAttribute("isIdentifiable", "true");
    }

    public static void setDDIMaintainableId(Element element, String string) {
        element.setAttribute("id", string);
        element.setAttribute("isMaintainable", "true");
    }

    public static void setDDIVersionableId(Element element, String string) {
        element.setAttribute("id", string);
        element.setAttribute("isVersionable", "true");
    }
}

