/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.resources;

import com.macrofocus.resources.ResourcesEvent;
import com.macrofocus.resources.ResourcesListener;
import com.macrofocus.resources.ResourcesModel;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractResourcesModel
implements ResourcesModel {
    private final List<ResourcesListener> listeners = new ArrayList<ResourcesListener>();

    @Override
    public void addResourcesListener(ResourcesListener listener) {
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWeakResourcesListener(ResourcesListener listener) {
        List<ResourcesListener> list = this.listeners;
        synchronized (list) {
            WeakResourcesListener weakListener = new WeakResourcesListener(listener);
            this.listeners.add(weakListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeResourcesListener(ResourcesListener listener) {
        List<ResourcesListener> list = this.listeners;
        synchronized (list) {
            if (listener instanceof WeakResourcesListener) {
                boolean removed = this.listeners.remove(listener);
                assert (removed) : listener;
            } else {
                ResourcesListener toRemove = null;
                for (ResourcesListener ResourcesListener2 : this.listeners) {
                    ResourcesListener comparable = ResourcesListener2 instanceof WeakResourcesListener ? ((WeakResourcesListener)ResourcesListener2).getReference() : ResourcesListener2;
                    if (!listener.equals(comparable)) continue;
                    toRemove = ResourcesListener2;
                }
                if (toRemove != null) {
                    boolean removed = this.listeners.remove(toRemove);
                    assert (removed) : listener;
                }
            }
        }
        this.listeners.remove(listener);
    }

    @Override
    public void removeAllResourcesListener() {
        ArrayList<ResourcesListener> listeners = new ArrayList<ResourcesListener>(this.listeners);
        for (ResourcesListener listener : listeners) {
            this.removeResourcesListener(listener);
        }
    }

    protected void notifyResourcesLocaleChanged(ResourcesEvent event) {
        for (ResourcesListener listener : this.listeners) {
            listener.resourcesLocaleChanged(event);
        }
    }

    private class WeakResourcesListener<E>
    implements ResourcesListener {
        private final WeakReference<ResourcesListener> l_ref;

        public WeakResourcesListener(ResourcesListener listener) {
            this.l_ref = new WeakReference<ResourcesListener>(listener);
        }

        @Override
        public void resourcesLocaleChanged(ResourcesEvent event) {
            ResourcesListener l = this.getReference();
            if (l != null) {
                l.resourcesLocaleChanged(event);
            } else {
                AbstractResourcesModel.this.removeResourcesListener(this);
            }
        }

        private ResourcesListener getReference() {
            return (ResourcesListener)this.l_ref.get();
        }

        public String toString() {
            ResourcesListener l = this.getReference();
            if (l != null) {
                return "Weak[" + String.valueOf(l) + "]";
            }
            return super.toString();
        }
    }
}

