/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.resources.properties;

import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AbstractPropertiesModel
implements PropertiesModel {
    private final List<PropertiesListener> listeners = new CopyOnWriteArrayList<PropertiesListener>();

    @Override
    public void addPropertiesListener(PropertiesListener listener) {
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWeakPropertiesListener(PropertiesListener listener) {
        List<PropertiesListener> list = this.listeners;
        synchronized (list) {
            WeakPropertiesListener weakListener = new WeakPropertiesListener(listener);
            this.listeners.add(weakListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePropertiesListener(PropertiesListener listener) {
        List<PropertiesListener> list = this.listeners;
        synchronized (list) {
            if (listener instanceof WeakPropertiesListener) {
                boolean removed = this.listeners.remove(listener);
                assert (removed) : listener;
            } else {
                PropertiesListener toRemove = null;
                for (PropertiesListener propertiesListener : this.listeners) {
                    PropertiesListener comparable = propertiesListener instanceof WeakPropertiesListener ? ((WeakPropertiesListener)propertiesListener).getReference() : propertiesListener;
                    if (!listener.equals(comparable)) continue;
                    toRemove = propertiesListener;
                }
                if (toRemove != null) {
                    boolean removed = this.listeners.remove(toRemove);
                    assert (removed) : listener;
                }
            }
        }
        this.listeners.remove(listener);
    }

    protected void notifyPropertiesChanged(PropertiesEvent event) {
        for (PropertiesListener listener : this.listeners) {
            listener.propertiesChanged(event);
        }
    }

    private class WeakPropertiesListener
    implements PropertiesListener {
        private final WeakReference<PropertiesListener> l_ref;

        public WeakPropertiesListener(PropertiesListener listener) {
            this.l_ref = new WeakReference<PropertiesListener>(listener);
        }

        @Override
        public void propertiesChanged(PropertiesEvent event) {
            PropertiesListener l = this.getReference();
            if (l != null) {
                l.propertiesChanged(event);
            } else {
                AbstractPropertiesModel.this.removePropertiesListener(this);
            }
        }

        private PropertiesListener getReference() {
            return (PropertiesListener)this.l_ref.get();
        }

        public String toString() {
            PropertiesListener l = this.getReference();
            if (l != null) {
                return "Weak[" + String.valueOf(l) + "]";
            }
            return super.toString();
        }
    }
}

