/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.action;

import com.macrofocus.colormap.swing.SwingColorMapPanel;
import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.util.file.FileHelper;
import com.macrofocus.util.file.filter.AbstractFileFilter;
import com.macrofocus.util.swing.FileChooserFactory;
import com.macrofocus.util.swing.action.AbstractMAction;
import com.treemap.TreeMapField;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class ExportColorMapAction
extends AbstractMAction {
    private final FileChooserFactory fileChooserFactory;
    private final Container contentPane;
    private SwingColorMapPanel<TreeMapField> colorMapPanel;

    public ExportColorMapAction(Container contentPane, FileChooserFactory fileChooserFactory, ResourcesModel resourcesModel) {
        super("Export Colormap", "action.exportcolormap.label", true, resourcesModel);
        this.contentPane = contentPane;
        this.fileChooserFactory = fileChooserFactory;
    }

    public void actionPerformed(ActionEvent e) {
        int input;
        File file;
        FileFilter fileFilter = null;
        do {
            JFileChooser fileChooser;
            int value;
            if ((value = (fileChooser = this.fileChooserFactory.getFileChooser()).showSaveDialog(this.contentPane)) != 0) {
                return;
            }
            file = fileChooser.getSelectedFile();
            fileFilter = fileChooser.getFileFilter();
        } while ((file = FileHelper.replaceSuffix((File)file, (String)((AbstractFileFilter)fileFilter).getDefaultExtension())) == null || fileFilter == null);
        if (file.exists() && (input = JOptionPane.showConfirmDialog(this.contentPane, "File " + file.getName() + " already exist! Overwrite?", "File already exist", 0, 2)) == 1) {
            return;
        }
        try {
            this.colorMapPanel.saveColorMap((OutputStream)new FileOutputStream(file));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setColorMapPanel(SwingColorMapPanel<TreeMapField> colorMapPanel) {
        this.colorMapPanel = colorMapPanel;
    }
}

