/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.benchmark;

import com.macrofocus.colormap.swing.SwingColorMapFactory;
import com.macrofocus.common.geom.Dimension;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.igraphics.CPImageFactory;
import com.macrofocus.igraphics.swing.SwingImageFactory;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import com.macrofocus.molap.dataframe.swing.SwingDataFrameFactory;
import com.treemap.AbstractTreeMapNode;
import com.treemap.TreeMapField;
import com.treemap.TreeMapView;
import com.treemap.TreeMapWorker;
import com.treemap.app.swing.benchmark.BenchmarkTreeMapModel;
import com.treemap.swing.SwingTreeMapView;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class LayoutBenchmark {
    public static void main(String[] args) {
        BenchmarkTreeMapModel model;
        String localStore = "/Users/luc/macrofocus/dataset/treemap/Forbes Global 2000 - 2025";
        long start = System.currentTimeMillis();
        int iterations = 10000;
        try {
            MutableDataFrame dataFrame = SwingDataFrameFactory.fromCSV((URL)new File("/Users/luc/macrofocus/dataset/treemap/Forbes Global 2000 - 2025.csv").toURL());
            model = new BenchmarkTreeMapModel(dataFrame, SwingFactory.getInstance(), SwingColorMapFactory.getInstance(), (CPImageFactory)SwingImageFactory.getInstance());
            for (int i = 0; i < 10000; ++i) {
                TreeMapField sizeTreeMapField = model.getSettings().getSizeTreeMapField();
                AbstractTreeMapNode rootNode = model.createRootNode(sizeTreeMapField);
                TreeMapWorker worker = new TreeMapWorker(){

                    public void cancel() {
                    }

                    public boolean isCancelled() {
                        return false;
                    }

                    public void setProgress(int progress) {
                    }
                };
                model.doGroupBy(rootNode, worker);
                model.doLayout(rootNode, worker);
                model.doColors(rootNode, worker);
            }
            long duration = System.currentTimeMillis() - start;
            long durationPerLayout = duration / 10000L;
            long fps = (long)(10000.0 / (double)duration * 1000.0);
            System.out.println(duration + " ms (" + durationPerLayout + " ms per layout, " + fps + " layouts per second)");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        SwingTreeMapView view = new SwingTreeMapView();
        view.setSize(new Dimension(1024, 768));
        view.setProgressive(TreeMapView.Progressive.Disabled);
        view.setModel(model);
        view.waitUntilReady();
        BufferedImage image = new BufferedImage(view.getSize().width, view.getSize().height, 1);
        start = System.currentTimeMillis();
        for (int i = 0; i < 10000; ++i) {
            view.getNativeComponent().paint(image.createGraphics());
        }
        long duration = System.currentTimeMillis() - start;
        long durationPerLayout = duration / 10000L;
        long fps = (long)(10000.0 / (double)duration * 1000.0);
        System.out.println(duration + " ms (" + durationPerLayout + " ms per layout, " + fps + " frames per second)");
    }
}

