/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.configuration;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.EditorContext;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.format.CPFormat;
import com.macrofocus.molap.dataframe.DataFrameEvent;
import com.macrofocus.molap.dataframe.DataFrameListener;
import com.treemap.TreeMapField;
import com.treemap.TreeMapModel;
import com.treemap.app.swing.configuration.SwingDetails;
import javax.swing.table.AbstractTableModel;

class DetailsTableModel<N, Row, Column, Color, Font>
extends AbstractTableModel
implements ContextSensitiveTableModel {
    private final TreeMapModel model;
    private N current;

    public DetailsTableModel(final TreeMapModel<N, Row, Column, Color, Font> model) {
        this.model = model;
        model.getProbing().addSingleSelectionListener(new SingleSelectionListener<N>(){

            public void selectionChanged(SingleSelectionEvent<N> event) {
                if (event.getCurrentSelection() != null) {
                    DetailsTableModel.this.current = event.getCurrentSelection();
                } else if (model.getSelection().isActive() && model.getSelection().getSelectedCount() == 1) {
                    for (Object node : model.getSelection()) {
                        DetailsTableModel.this.current = node;
                    }
                } else {
                    DetailsTableModel.this.current = null;
                }
                DetailsTableModel.this.fireTableDataChanged();
            }
        });
        model.getDataFrame().addDataFrameListener(new DataFrameListener(){

            public void dataFrameChanged(DataFrameEvent event) {
                DetailsTableModel.this.fireTableDataChanged();
            }
        });
    }

    @Override
    public int getRowCount() {
        return this.model.getDataFrame().getColumnCount();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object row = this.model.getDataFrame().getColumnKey(rowIndex);
        switch (columnIndex) {
            case 0: {
                return this.model.getDataFrame().getColumnName(row);
            }
            case 1: {
                if (this.current == null) break;
                TreeMapField treeMapField = this.model.getTreeMapField(rowIndex);
                if (this.model.hasNoChildren(this.current)) {
                    Object valueAt = this.model.getValueAt(this.current, row);
                    if (valueAt != null && valueAt.getClass().isArray()) {
                        return this.model.getStringValue(this.current, treeMapField, this.model.getSettings().getFieldSettings(treeMapField));
                    }
                    return valueAt;
                }
                return this.model.getAggregateValue(this.current, treeMapField);
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Object.class;
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Variable";
            }
            case 1: {
                return "Value";
            }
        }
        return null;
    }

    public ConverterContext getConverterContextAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 1: {
                CPFormat format = this.model.getSettings().getFieldSettings(this.model.getTreeMapField(rowIndex)).getFormat();
                return new ConverterContext("details", format != null ? format.getNativeFormat() : format);
            }
        }
        return null;
    }

    public EditorContext getEditorContextAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            default: 
        }
        return SwingDetails.editorContext;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            default: 
        }
        return false;
    }

    public Class<?> getCellClassAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return this.model.getDataFrame().getColumnClass(this.model.getDataFrame().getColumnKey(rowIndex));
            }
        }
        return null;
    }
}

