/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.presentation.implementation.treedee;

import com.treemap.TreeMapEvent;
import com.treemap.TreeMapListener;
import com.treemap.TreeMapModel;
import com.treemap.app.swing.presentation.implementation.treedee.ThreeDeeListener;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;

public class TreeDeeModel<N, Row, Column> {
    private TreeMapModel<N, Row, Column, Color, Font> treeMapModel;
    private List<ThreeDeeListener> listeners;
    private final TreeMapListener treeMapListener = new TreeMapListener(){

        public void tableModelChanged() {
        }

        public void treeMapChanged(TreeMapEvent event) {
            TreeDeeModel.this.fireModelChanged();
        }
    };

    public TreeDeeModel() {
        this.listeners = new ArrayList<ThreeDeeListener>();
    }

    public void setTreeMapModel(TreeMapModel<N, Row, Column, Color, Font> treeMapModel) {
        if (this.treeMapModel != null) {
            this.treeMapModel.removeListener(this.treeMapListener);
        }
        this.treeMapModel = treeMapModel;
        this.treeMapModel.addListener(this.treeMapListener);
        this.fireModelChanged();
    }

    public TreeMapModel<N, Row, Column, Color, Font> getTreeMapModel() {
        return this.treeMapModel;
    }

    public void addListener(ThreeDeeListener listener) {
        this.listeners.add(listener);
    }

    private void fireModelChanged() {
        for (ThreeDeeListener listener : this.listeners) {
            listener.modelChanged();
        }
    }
}

