/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.presentation.implementation.treetable;

import com.jidesoft.grid.AutoResizePopupMenuCustomizer;
import com.jidesoft.grid.RolloverTableUtils;
import com.jidesoft.grid.TableColumnChooser;
import com.jidesoft.grid.TableColumnChooserPopupMenuCustomizer;
import com.jidesoft.grid.TableHeaderPopupMenuCustomizer;
import com.jidesoft.grid.TableHeaderPopupMenuInstaller;
import com.jidesoft.grid.TableUtils;
import com.jidesoft.grid.TreeTable;
import com.jidesoft.grid.TreeTableSearchable;
import com.jidesoft.swing.CornerScroller;
import com.jidesoft.swing.JideScrollPane;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.treemap.AbstractTreeMapNode;
import com.treemap.TreeMapEvent;
import com.treemap.TreeMapField;
import com.treemap.TreeMapListener;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapNode;
import com.treemap.app.swing.presentation.implementation.TreeMapRow;
import com.treemap.app.swing.presentation.implementation.treetable.RowStripeTreeTable;
import com.treemap.app.swing.presentation.implementation.treetable.TreeMapTreeTableModel;
import com.treemap.app.swing.presentation.implementation.treetable.TreeTableSelectionCoordinator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

public class TreeTablePanel
extends JPanel {
    private final RowStripeTreeTable treeTable;
    private TreeMapModel tmm;
    private Thread autoSizeAllThread;
    private Thread autoSizeThread;
    private final boolean expertMode;
    private boolean allAutoSize = false;
    private final TreeMapListener treeMapListener = new TreeMapListener(){

        public void tableModelChanged() {
        }

        public void treeMapChanged(TreeMapEvent event) {
            if (event.isGroupByChanged()) {
                try {
                    TreeTablePanel.this.updateColumnVisibility();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    TreeTablePanel.this.autoSize();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    };
    private SingleSelectionListener probingListener = new SingleSelectionListener(){

        public void selectionChanged(SingleSelectionEvent event) {
            TreeTablePanel.this.updateTreeTableRollover(TreeTablePanel.this.tmm);
        }
    };
    private MouseMotionListener mouseMotionListener = new MouseMotionListener(){

        @Override
        public void mouseDragged(MouseEvent e) {
            TreeTablePanel.this.updateTreeMapHighlighting(TreeTablePanel.this.tmm);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            TreeTablePanel.this.updateTreeMapHighlighting(TreeTablePanel.this.tmm);
        }
    };

    private void updateColumnVisibility() {
        TreeMapField[] treeMapFields = this.tmm.getSettings().getGroupByTreeMapFields();
        ArrayList<Integer> indices = new ArrayList<Integer>(treeMapFields.length);
        for (int i = 0; i < treeMapFields.length; ++i) {
            TreeMapField treeMapField = treeMapFields[i];
            indices.add(this.tmm.getDataFrame().getColumnAddress(treeMapField.getIndex()) + 2);
        }
        final int[] i = new int[indices.size()];
        for (int j = 0; j < indices.size(); ++j) {
            Integer integer = (Integer)indices.get(j);
            i[j] = integer;
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    TableColumnChooser.hideColumns((JTable)((Object)TreeTablePanel.this.treeTable), (int[])i);
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public TreeTablePanel(boolean expertMode) {
        this.expertMode = expertMode;
        this.treeTable = new RowStripeTreeTable();
        JideScrollPane scrollPane = new JideScrollPane((Component)((Object)this.treeTable));
        scrollPane.setVerticalScrollBarPolicy(22);
        this.treeTable.setShowHorizontalLines(false);
        this.treeTable.setAutoResizeMode(0);
        this.treeTable.setColumnResizable(true);
        this.treeTable.setColumnAutoResizable(true);
        this.treeTable.setAutoscrolls(true);
        this.treeTable.setShowGrid(false);
        this.treeTable.setIntercellSpacing(new Dimension(0, 0));
        this.treeTable.setShowTreeLines(true);
        this.treeTable.setShowLeafNodeTreeLines(true);
        this.treeTable.setExpandAllAllowed(true);
        this.treeTable.setExpandIconVisible(true);
        this.treeTable.setFadeIcon(false);
        this.treeTable.setNonContiguousCellSelection(false);
        this.treeTable.setRowSelectionAllowed(true);
        this.treeTable.setColumnSelectionAllowed(false);
        TreeTableSearchable treeTableSearchable = new TreeTableSearchable((JTable)((Object)this.treeTable)){

            protected String convertElementToString(Object item) {
                if (item instanceof TreeMapRow) {
                    return ((TreeMapRow)((Object)item)).getNode().getLabelName();
                }
                String s = super.convertElementToString(item);
                return s;
            }
        };
        treeTableSearchable.setMainIndex(0);
        treeTableSearchable.setRecursive(true);
        TableHeaderPopupMenuInstaller installer = new TableHeaderPopupMenuInstaller((JTable)((Object)this.treeTable));
        installer.addTableHeaderPopupMenuCustomizer((TableHeaderPopupMenuCustomizer)new AutoResizePopupMenuCustomizer());
        installer.addTableHeaderPopupMenuCustomizer((TableHeaderPopupMenuCustomizer)new TableColumnChooserPopupMenuCustomizer());
        AbstractButton tableColumnChooserButton = TableColumnChooser.getTableColumnChooserButton((JTable)((Object)this.treeTable));
        tableColumnChooserButton.setContentAreaFilled(false);
        scrollPane.setCorner("UPPER_RIGHT_CORNER", (Component)tableColumnChooserButton);
        CornerScroller scroller = new CornerScroller((JScrollPane)scrollPane);
        scroller.setSelectionBorderColor(Color.GRAY);
        scrollPane.setCorner("LOWER_RIGHT_CORNER", (Component)scroller);
        this.setLayout(new OverlayLayout(this));
        this.add((Component)scrollPane);
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new AbstractAction("Expand All"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeTablePanel.this.treeTable.expandAll();
            }
        });
        popupMenu.add(new AbstractAction("Expand First Level"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeTablePanel.this.treeTable.expandFirstLevel();
            }
        });
        popupMenu.add(new AbstractAction("Collapse All"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeTablePanel.this.treeTable.collapseAll();
            }
        });
        this.treeTable.setComponentPopupMenu(popupMenu);
        RolloverTableUtils.install((JTable)((Object)this.treeTable));
    }

    private TreeMapTreeTableModel createTreeTableModel(TreeMapModel tmm) {
        return new TreeMapTreeTableModel(tmm, this.expertMode);
    }

    public void setModel(final TreeMapModel tmm) {
        if (this.tmm != null) {
            this.tmm.removeListener(this.treeMapListener);
            this.tmm.getProbing().removeSingleSelectionListener(this.probingListener);
            this.treeTable.removeMouseMotionListener(this.mouseMotionListener);
        }
        this.tmm = tmm;
        this.tmm.addListener(this.treeMapListener);
        if (tmm.getRoot() != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        Future workerFuture = tmm.getWorkerFuture();
                        if (workerFuture != null && !workerFuture.isDone()) {
                            workerFuture.get();
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                    TreeTablePanel.this.autoSize();
                }
            });
        }
        this.tmm.getProbing().addSingleSelectionListener(this.probingListener);
        this.treeTable.addMouseMotionListener(this.mouseMotionListener);
        this.treeTable.setTreeMapModel(tmm);
        this.treeTable.setModel((TableModel)((Object)this.createTreeTableModel(tmm)));
        new TreeTableSelectionCoordinator((TreeTable)this.treeTable, this.treeTable.getSelectionModel(), (MutableSelection<AbstractTreeMapNode>)tmm.getSelection());
    }

    private void autoSize() {
        if (!this.allAutoSize) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeTablePanel.this.autoSizeAll();
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeTablePanel.this.autoSizeFirstColumn();
                }
            });
        }
    }

    private void autoSizeAll() {
        if (this.autoSizeAllThread != null) {
            this.autoSizeAllThread.interrupt();
        }
        if (this.autoSizeThread != null) {
            this.autoSizeThread.interrupt();
        }
        this.autoSizeAllThread = new Thread(new Runnable(){

            @Override
            public void run() {
                int columnCount = TreeTablePanel.this.treeTable.getColumnCount();
                int[] minimumWidth = new int[columnCount];
                Arrays.fill(minimumWidth, 20);
                int[] maximumWidth = new int[columnCount];
                Arrays.fill(maximumWidth, 150);
                if (maximumWidth.length > 0) {
                    minimumWidth[0] = 50;
                    maximumWidth[0] = 250;
                }
                TableUtils.autoResizeAllColumns((JTable)((Object)TreeTablePanel.this.treeTable), (int[])minimumWidth, (int[])maximumWidth, (boolean)true, (boolean)false, (boolean)true, (boolean)false);
                TreeTablePanel.this.allAutoSize = true;
            }
        });
        this.autoSizeAllThread.start();
    }

    private void autoSizeFirstColumn() {
        if (this.autoSizeThread != null) {
            this.autoSizeThread.interrupt();
        }
        this.autoSizeThread = new Thread(new Runnable(){

            @Override
            public void run() {
                TableUtils.autoResizeColumn((JTable)((Object)TreeTablePanel.this.treeTable), (int)0, (boolean)true, (boolean)false, (int)20, (int)250, (boolean)true, (boolean)false);
            }
        });
        this.autoSizeThread.start();
    }

    private void updateTreeTableRollover(TreeMapModel tmm) {
        TreeMapNode node = (TreeMapNode)tmm.getProbing().getSelected();
        int found = -1;
        if (node != null) {
            for (int i = 0; i < this.treeTable.getModel().getRowCount(); ++i) {
                AbstractTreeMapNode o;
                TreeMapRow hierarchyRow = (TreeMapRow)this.treeTable.getRowAt(i);
                if (hierarchyRow == null || node != (o = hierarchyRow.getNode())) continue;
                found = i;
                break;
            }
        }
        this.treeTable.setNavigationRolloverRow(found);
    }

    private void updateTreeMapHighlighting(TreeMapModel tmm) {
        TreeMapRow hierarchyRow = (TreeMapRow)this.treeTable.getRowAt(this.treeTable.getNavigationRolloverRow());
        if (hierarchyRow != null) {
            tmm.getHighlighting().setSelectedIterable(Collections.singletonList(hierarchyRow.getNode()));
        } else {
            tmm.getHighlighting().clearSelection();
        }
    }

    public TreeTable getTreeTable() {
        return this.treeTable;
    }
}

