/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.swing.screenshots;

import com.macrofocus.colormap.editor.ColorMapPanel;
import com.treemap.LabelingFactory;
import com.treemap.RenderingFactory;
import com.treemap.TreeMapModel;
import com.treemap.app.swing.TreeMap;
import com.treemap.app.swing.document.SwingTreeMapApplication;
import com.treemap.app.swing.document.SwingTreeMapView;
import com.treemap.app.swing.screenshots.ScreenShotsHelper;
import com.treemap.app.swing.v4.settings.algorithm.MAlgorithmFactory;
import java.io.File;

public class MappingCircles<Row, Column> {
    public MappingCircles() {
        try {
            String home = System.getProperty("user.home");
            File datasets = new File(home, "/macrofocus/dataset/treemap");
            File output = new File(home, "/build/treemap/mappingcircles");
            if (!output.exists()) {
                output.mkdirs();
            }
            System.setProperty("macrofocus.laf.useScreenMenuBar", "false");
            TreeMap app = new TreeMap();
            SwingTreeMapApplication application = null;
            ScreenShotsHelper.open(new File(datasets, "Forbes Global 2000 - 2014.mtm"), application);
            File dest = new File(output, "Global 2000");
            if (!dest.exists()) {
                dest.mkdirs();
            }
            SwingTreeMapView treeMapDataView = application.getFocusedView();
            TreeMapModel model = treeMapDataView.getTreeMapModel();
            SwingTreeMapView focusedView = application.getFocusedView();
            model.getProbing().clearSelection();
            model.getSettings().setColorByName("Profits");
            focusedView.getConfiguration().getColorMapPanel().setType(ColorMapPanel.Type.Predefined);
            model.getSettings().getDefaultFieldSettings().setLabelingVerticalAlignment(0);
            model.getSettings().getDefaultFieldSettings().setAlgorithm(MAlgorithmFactory.CIRCULAR);
            ScreenShotsHelper.takeScreenShot(dest, "layout-circular", application);
            model.getSettings().getDefaultFieldSettings().setAlgorithm(MAlgorithmFactory.VORONOI);
            ScreenShotsHelper.takeScreenShot(dest, "layout-voronoi", application);
            model.getSettings().getDefaultFieldSettings().setAlgorithm(MAlgorithmFactory.CIRCULAR);
            model.getSettings().getFieldSettings(model.getTreeMapField(1)).setAlgorithm(MAlgorithmFactory.PIE);
            ScreenShotsHelper.takeScreenShot(dest, "layout-circular-pie", application);
            model.getSettings().getDefaultFieldSettings().setAlgorithm(MAlgorithmFactory.CIRCULAR);
            model.getSettings().getFieldSettings(model.getTreeMapField(1)).setAlgorithm(MAlgorithmFactory.VORONOI);
            ScreenShotsHelper.takeScreenShot(dest, "layout-circular-voronoi", application);
            ScreenShotsHelper.close(application);
            ScreenShotsHelper.open(new File(datasets, "DB-Engines Ranking - August 2013.mtm"), application);
            dest = new File(output, "DB-Engines Ranking");
            if (!dest.exists()) {
                dest.mkdirs();
            }
            treeMapDataView = application.getFocusedView();
            model = treeMapDataView.getTreeMapModel();
            model.getSettings().getDefaultFieldSettings().setAlgorithm(MAlgorithmFactory.CIRCULAR);
            ScreenShotsHelper.takeScreenShot(dest, "layout-circular", application);
            model.getSettings().getDefaultFieldSettings().setAlgorithm(MAlgorithmFactory.VORONOI);
            ScreenShotsHelper.takeScreenShot(dest, "layout-voronoi", application);
            model.getSettings().getDefaultFieldSettings().setAlgorithm(MAlgorithmFactory.CIRCULAR);
            model.getSettings().getFieldSettings(model.getTreeMapFieldByName("Database Model")).setAlgorithm(MAlgorithmFactory.VORONOI);
            ScreenShotsHelper.takeScreenShot(dest, "layout-circular-voronoi", application);
            ScreenShotsHelper.close(application);
            ScreenShotsHelper.open(new File(datasets, "Lipper Ch120501.mtm"), application);
            dest = new File(output, "Investment Funds");
            if (!dest.exists()) {
                dest.mkdirs();
            }
            treeMapDataView = application.getFocusedView();
            model = treeMapDataView.getTreeMapModel();
            model.getSettings().getDefaultFieldSettings().setLabeling(LabelingFactory.OVERLAY);
            model.getSettings().getDefaultFieldSettings().setHeaderHorizontalAlignment(Integer.valueOf(0));
            model.getSettings().getDefaultFieldSettings().setHeaderVerticalAlignment(Integer.valueOf(0));
            model.getSettings().setLabels(new int[0]);
            model.getSettings().setRendering(RenderingFactory.FLAT);
            model.getSettings().getDefaultFieldSettings().setBorderThickness(0.01);
            model.getSettings().getDefaultFieldSettings().setAlgorithm(MAlgorithmFactory.CIRCULAR);
            ScreenShotsHelper.takeScreenShot(dest, "layout-circular", application);
            model.getSettings().getDefaultFieldSettings().setAlgorithm(MAlgorithmFactory.CIRCULAR);
            model.getSettings().getFieldSettings(model.getTreeMapFieldByName("Global Classification")).setAlgorithm(MAlgorithmFactory.VORONOI);
            ScreenShotsHelper.takeScreenShot(dest, "layout-circular-voronoi", application);
            ScreenShotsHelper.close(application);
            ScreenShotsHelper.open(new File(datasets, "GROWup - Ethnic Power Relations - 2013.mtm"), application);
            dest = new File(output, "Ethnic Power Relations");
            if (!dest.exists()) {
                dest.mkdirs();
            }
            treeMapDataView = application.getFocusedView();
            model = treeMapDataView.getTreeMapModel();
            model.getSettings().getDefaultFieldSettings().setAlgorithm(MAlgorithmFactory.CIRCULAR);
            ScreenShotsHelper.takeScreenShot(dest, "layout-circular", application);
            model.getSettings().getDefaultFieldSettings().setAlgorithm(MAlgorithmFactory.CIRCULAR);
            model.getSettings().getFieldSettings(model.getTreeMapFieldByName("countryname")).setAlgorithm(MAlgorithmFactory.VORONOI);
            ScreenShotsHelper.takeScreenShot(dest, "layout-circular-voronoi", application);
            ScreenShotsHelper.close(application);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    public static void main(String[] args) {
        new MappingCircles();
    }
}

