/*
 * Decompiled with CFR 0.152.
 */
package org.openexi.proc.common;

import org.openexi.proc.common.AlignmentType;
import org.openexi.proc.common.EXIOptionsException;
import org.openexi.proc.common.EventDescription;
import org.openexi.proc.common.GrammarOptions;
import org.openexi.proc.common.QName;
import org.openexi.proc.common.SchemaId;

public final class EXIOptions {
    public static final int ADD_LESSCOMMON = 1;
    public static final int ADD_UNCOMMON = 2;
    public static final int ADD_ALIGNMENT = 4;
    public static final int ADD_PRESERVE = 8;
    public static final int ADD_COMMON = 16;
    public static final int ADD_VALUE_MAX_LENGTH = 32;
    public static final int ADD_VALUE_PARTITION_CAPACITY = 64;
    public static final int ADD_FRAGMENT = 128;
    public static final int ADD_DTRM = 256;
    public static final int BLOCKSIZE_DEFAULT = 1000000;
    public static final int VALUE_MAX_LENGTH_UNBOUNDED = -1;
    public static final int VALUE_PARTITION_CAPACITY_UNBOUNDED = -1;
    private AlignmentType m_alignmentType;
    private boolean m_isFragment;
    private boolean m_isStrict;
    private boolean m_preserveComments;
    private boolean m_preservePIs;
    private boolean m_preserveDTD;
    private boolean m_preserveNS;
    private boolean m_infuseSC;
    private SchemaId m_schemaId;
    private int m_blockSize;
    private int m_valueMaxLength;
    private int m_valuePartitionCapacity;
    private boolean m_preserveLexicalValues;
    private int m_n_datatypeRepresentationMapBindings;
    private QName[] m_datatypeRepresentationMap;

    public EXIOptions() {
        this.init();
        this.m_datatypeRepresentationMap = new QName[16];
        for (int i = 0; i < this.m_datatypeRepresentationMap.length; ++i) {
            this.m_datatypeRepresentationMap[i] = new QName();
        }
    }

    public void init() {
        this.m_alignmentType = AlignmentType.bitPacked;
        this.m_isFragment = false;
        this.m_isStrict = false;
        this.m_preserveComments = false;
        this.m_preservePIs = false;
        this.m_preserveDTD = false;
        this.m_preserveNS = false;
        this.m_preserveLexicalValues = false;
        this.m_infuseSC = false;
        this.m_schemaId = null;
        this.m_blockSize = 1000000;
        this.m_valueMaxLength = -1;
        this.m_valuePartitionCapacity = -1;
        this.m_n_datatypeRepresentationMapBindings = 0;
    }

    public AlignmentType getAlignmentType() {
        return this.m_alignmentType;
    }

    public boolean isFragment() {
        return this.m_isFragment;
    }

    public boolean isStrict() {
        return this.m_isStrict;
    }

    public boolean getPreserveComments() {
        return this.m_preserveComments;
    }

    public boolean getPreservePIs() {
        return this.m_preservePIs;
    }

    public boolean getPreserveDTD() {
        return this.m_preserveDTD;
    }

    public boolean getPreserveNS() {
        return this.m_preserveNS;
    }

    public boolean getInfuseSC() {
        return this.m_infuseSC;
    }

    public SchemaId getSchemaId() {
        return this.m_schemaId;
    }

    public int getBlockSize() {
        return this.m_blockSize;
    }

    public int getValueMaxLength() {
        return this.m_valueMaxLength;
    }

    public int getValuePartitionCapacity() {
        return this.m_valuePartitionCapacity;
    }

    public boolean getPreserveLexicalValues() {
        return this.m_preserveLexicalValues;
    }

    public int getDatatypeRepresentationMapBindingsCount() {
        return this.m_n_datatypeRepresentationMapBindings;
    }

    public QName[] getDatatypeRepresentationMap() {
        return this.m_datatypeRepresentationMap;
    }

    public void setAlignmentType(AlignmentType alignmentType) throws EXIOptionsException {
        if (this.m_infuseSC) {
            if (this.m_alignmentType == AlignmentType.compress) {
                throw new EXIOptionsException("selfContained option and compression option cannot be used together.");
            }
            if (this.m_alignmentType == AlignmentType.preCompress) {
                throw new EXIOptionsException("selfContained option and pre-compression option cannot be used together.");
            }
        }
        this.m_alignmentType = alignmentType;
    }

    public void setFragment(boolean bl) {
        this.m_isFragment = bl;
    }

    public void setStrict(boolean bl) throws EXIOptionsException {
        if (this.m_preserveComments) {
            throw new EXIOptionsException("Preserve.comments option and strict option cannot be used together.");
        }
        if (this.m_preservePIs) {
            throw new EXIOptionsException("Preserve.pis option and strict option cannot be used together.");
        }
        if (this.m_preserveDTD) {
            throw new EXIOptionsException("Preserve.dtd option and strict option cannot be used together.");
        }
        if (this.m_preserveNS) {
            throw new EXIOptionsException("Preserve.prefixes option and strict option cannot be used together.");
        }
        if (this.m_infuseSC) {
            throw new EXIOptionsException("selfContained option and strict option cannot be used together.");
        }
        this.m_isStrict = bl;
    }

    public void setPreserveComments(boolean bl) throws EXIOptionsException {
        if (this.m_isStrict && bl) {
            throw new EXIOptionsException("Preserve.comments option and strict option cannot be used together.");
        }
        this.m_preserveComments = bl;
    }

    public void setPreservePIs(boolean bl) throws EXIOptionsException {
        if (this.m_isStrict && bl) {
            throw new EXIOptionsException("Preserve.pis option and strict option cannot be used together.");
        }
        this.m_preservePIs = bl;
    }

    public void setPreserveDTD(boolean bl) throws EXIOptionsException {
        if (this.m_isStrict && bl) {
            throw new EXIOptionsException("Preserve.dtd option and strict option cannot be used together.");
        }
        this.m_preserveDTD = bl;
    }

    public void setPreserveNS(boolean bl) throws EXIOptionsException {
        if (this.m_isStrict && bl) {
            throw new EXIOptionsException("Preserve.prefixes option and strict option cannot be used together.");
        }
        this.m_preserveNS = bl;
    }

    public void setInfuseSC(boolean bl) throws EXIOptionsException {
        if (this.m_infuseSC != bl) {
            if (bl) {
                if (this.m_alignmentType == AlignmentType.compress) {
                    throw new EXIOptionsException("selfContained option and compression option cannot be used together.");
                }
                if (this.m_alignmentType == AlignmentType.preCompress) {
                    throw new EXIOptionsException("selfContained option and pre-compression option cannot be used together.");
                }
                if (this.m_isStrict) {
                    throw new EXIOptionsException("selfContained option and strict option cannot be used together.");
                }
            }
            this.m_infuseSC = bl;
        }
    }

    public void setSchemaId(SchemaId schemaId) {
        this.m_schemaId = schemaId;
    }

    public void setBlockSize(int n) throws EXIOptionsException {
        if (n <= 0) {
            throw new EXIOptionsException("blockSize option value cannot be a negative number.");
        }
        this.m_blockSize = n;
    }

    public void setValueMaxLength(int n) {
        this.m_valueMaxLength = n;
    }

    public void setValuePartitionCapacity(int n) {
        this.m_valuePartitionCapacity = n;
    }

    public void setPreserveLexicalValues(boolean bl) throws EXIOptionsException {
        this.m_preserveLexicalValues = bl;
    }

    public void setDatatypeRepresentationMap(QName[] qNameArray, int n) throws EXIOptionsException {
        int n2;
        int n3 = 2 * n;
        for (n2 = 0; n2 < n; ++n2) {
            int n4 = n2 << 1;
            if (qNameArray[n4] != null && qNameArray[n4 + 1] != null) continue;
            throw new EXIOptionsException("A qname in datatypeRepresentationMap cannot be null.");
        }
        if (this.m_datatypeRepresentationMap.length < n3) {
            QName[] qNameArray2 = new QName[n3];
            for (n2 = 0; n2 < this.m_datatypeRepresentationMap.length; ++n2) {
                qNameArray2[n2] = this.m_datatypeRepresentationMap[n2];
            }
            while (n2 < qNameArray2.length) {
                qNameArray2[n2] = new QName();
                ++n2;
            }
            this.m_datatypeRepresentationMap = qNameArray2;
        }
        for (n2 = 0; n2 < 2 * n; ++n2) {
            QName qName = qNameArray[n2];
            this.m_datatypeRepresentationMap[n2].setValue(qName.namespaceName, qName.localName, qName.prefix, qName.qName);
        }
        this.m_n_datatypeRepresentationMapBindings = n;
    }

    public void appendDatatypeRepresentationMap(EventDescription eventDescription, EventDescription eventDescription2) throws EXIOptionsException {
        if (eventDescription == null || eventDescription2 == null) {
            throw new EXIOptionsException("A qname in datatypeRepresentationMap cannot be null.");
        }
        this.appendDatatypeRepresentationMap(eventDescription.getURI(), eventDescription.getName(), eventDescription2.getURI(), eventDescription2.getName());
    }

    public void appendDatatypeRepresentationMap(String string, String string2, String string3, String string4) throws EXIOptionsException {
        int n = this.m_n_datatypeRepresentationMapBindings + 1;
        int n2 = 2 * n;
        if (this.m_datatypeRepresentationMap.length < n2) {
            int n3;
            QName[] qNameArray = new QName[n2];
            for (n3 = 0; n3 < this.m_datatypeRepresentationMap.length; ++n3) {
                qNameArray[n3] = this.m_datatypeRepresentationMap[n3];
            }
            while (n3 < qNameArray.length) {
                qNameArray[n3] = new QName();
                ++n3;
            }
            this.m_datatypeRepresentationMap = qNameArray;
        }
        int n4 = 2 * this.m_n_datatypeRepresentationMapBindings;
        this.m_datatypeRepresentationMap[n4++].setValue(string, string2, null, null);
        this.m_datatypeRepresentationMap[n4++].setValue(string3, string4, null, null);
        assert (n4 == n2);
        this.m_n_datatypeRepresentationMapBindings = n;
    }

    public short toGrammarOptions() {
        short s = 2;
        if (this.m_isStrict) {
            return 1;
        }
        if (this.m_preserveComments) {
            s = GrammarOptions.addCM(s);
        }
        if (this.m_preservePIs) {
            s = GrammarOptions.addPI(s);
        }
        if (this.m_preserveDTD) {
            s = GrammarOptions.addDTD(s);
        }
        if (this.m_preserveNS) {
            s = GrammarOptions.addNS(s);
        }
        if (this.m_infuseSC) {
            s = GrammarOptions.addSC(s);
        }
        return s;
    }

    public void setGrammarOptions(short s) throws EXIOptionsException {
        this.m_isStrict = s == 1;
        if (this.m_isStrict) {
            this.m_preserveComments = false;
            this.m_preservePIs = false;
            this.m_preserveDTD = false;
            this.m_preserveNS = false;
            this.m_infuseSC = false;
        } else {
            this.m_preserveComments = GrammarOptions.hasCM(s);
            this.m_preservePIs = GrammarOptions.hasPI(s);
            this.m_preserveDTD = GrammarOptions.hasDTD(s);
            this.m_preserveNS = GrammarOptions.hasNS(s);
            this.setInfuseSC(GrammarOptions.hasSC(s));
        }
    }

    public int getOutline(boolean bl) {
        int n = 0;
        boolean bl2 = false;
        if (this.m_alignmentType == AlignmentType.byteAligned || this.m_alignmentType == AlignmentType.preCompress) {
            bl2 = true;
        }
        boolean bl3 = this.m_valuePartitionCapacity != -1;
        boolean bl4 = this.m_valueMaxLength != -1;
        boolean bl5 = this.m_n_datatypeRepresentationMapBindings != 0 && !this.m_preserveLexicalValues;
        boolean bl6 = false;
        if (bl2) {
            bl6 = true;
        } else if (this.m_infuseSC) {
            bl6 = true;
        } else if (bl4) {
            bl6 = true;
        } else if (bl3) {
            bl6 = true;
        } else if (bl5) {
            bl6 = true;
        }
        boolean bl7 = false;
        if (this.m_preserveComments || this.m_preservePIs || this.m_preserveDTD || this.m_preserveNS || this.m_preserveLexicalValues) {
            bl7 = true;
        }
        boolean bl8 = false;
        if (this.m_blockSize != 1000000) {
            bl8 = true;
        }
        boolean bl9 = false;
        if (bl6 || bl7 || bl8) {
            bl9 = true;
        }
        boolean bl10 = false;
        if (this.m_alignmentType == AlignmentType.compress) {
            bl10 = true;
        } else if (this.m_isFragment) {
            bl10 = true;
        } else if (bl) {
            bl10 = true;
        }
        if (bl9) {
            n |= 1;
        }
        if (bl6) {
            n |= 2;
            if (bl2) {
                n |= 4;
            }
            if (bl4) {
                n |= 0x20;
            }
            if (bl3) {
                n |= 0x40;
            }
            if (bl5) {
                n |= 0x100;
            }
        }
        if (bl7) {
            n |= 8;
        }
        if (bl10) {
            n |= 0x10;
            if (this.m_isFragment) {
                n |= 0x80;
            }
        }
        return n;
    }
}

