/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.Scalable;
import de.javasoft.plaf.synthetica.ScalableIcon;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.util.OS;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthUI;
import sun.swing.DefaultLookup;

public class SyntheticaDefaultLookup
extends DefaultLookup {
    @Override
    public Object getDefault(JComponent c, ComponentUI ui, String key) {
        SynthContext sc;
        if (OS.getCurrentOS() == OS.Mac && this.isSynthUI(ui) && SyntheticaLookAndFeel.getBoolean("Synthetica.metaKeySupportOnMacEnabled", c, true) && ("TextField.focusInputMap".equals(key) || "FormattedTextField.focusInputMap".equals(key) || "PasswordField.focusInputMap".equals(key) || "TextArea.focusInputMap".equals(key) || "TextPane.focusInputMap".equals(key) || "EditorPane.focusInputMap".equals(key) || "List.focusInputMap".equals(key) || "Tree.focusInputMap".equals(key) || "Spinner.focusInputMap".equals(key))) {
            SynthContext context = this.getContext(ui, c);
            InputMap inputMap = (InputMap)context.getStyle().get(context, key);
            LookAndFeel.loadKeyBindings(inputMap, new Object[]{"meta X", "cut-to-clipboard", "meta C", "copy-to-clipboard", "meta V", "paste-from-clipboard", "meta A", "select-all"});
            if ("TextField.focusInputMap".equals(key) || "FormattedTextField.focusInputMap".equals(key) || "PasswordField.focusInputMap".equals(key) || "TextArea.focusInputMap".equals(key) || "TextPane.focusInputMap".equals(key) || "EditorPane.focusInputMap".equals(key)) {
                Object[] map = this.asArray(this.getMacMap4JTextComponent());
                LookAndFeel.loadKeyBindings(inputMap, map);
            }
            return inputMap;
        }
        if (this.isSynthUI(ui) && ("TextField.focusInputMap".equals(key) || "FormattedTextField.focusInputMap".equals(key) || "PasswordField.focusInputMap".equals(key) || "TextArea.focusInputMap".equals(key) || "TextPane.focusInputMap".equals(key) || "EditorPane.focusInputMap".equals(key))) {
            SynthContext context = this.getContext(ui, c);
            InputMap inputMap = (InputMap)context.getStyle().get(context, key);
            Object[] map = this.asArray(this.getCustomMap4TextComponent());
            LookAndFeel.loadKeyBindings(inputMap, map);
            return inputMap;
        }
        if ("Button.defaultButtonFollowsFocus".equals(key)) {
            return UIManager.getBoolean("Button.defaultButtonFollowsFocus");
        }
        if ("SplitPane.oneTouchButtonOffset".equals(key) && UIManager.getBoolean("Syntetica.splitPane.centerOneTouchButtons") && this.isSynthUI(ui)) {
            JSplitPane sp = (JSplitPane)c;
            Insets ins = sp.getInsets();
            int size = 0;
            size = sp.getOrientation() == 0 ? sp.getWidth() - ins.left - ins.right : sp.getHeight() - ins.top - ins.bottom;
            SynthContext sc2 = this.getContext(ui, c);
            int buttonSize = (Integer)sc2.getStyle().get(sc2, "SplitPane.oneTouchButtonSize");
            int spSize = sp.getDividerSize();
            return size / 2 - buttonSize - spSize;
        }
        if ("OptionPane.buttonPadding".equals(key)) {
            return SyntheticaLookAndFeel.getInt("OptionPane.buttonPadding", null, 8, true);
        }
        if ("OptionPane.buttonOrientation".equals(key)) {
            return UIManager.get("OptionPane.buttonOrientation");
        }
        if ("ProgressBar.horizontalSize".equals(key)) {
            Dimension dim = SyntheticaLookAndFeel.getDim("ProgressBar.horizontalSize", c, null, false);
            if (dim == null) {
                dim = new Dimension(146, 12);
            }
            return SyntheticaLookAndFeel.getInstance().scaleDimension(dim);
        }
        if ("ProgressBar.vertictalSize".equals(key) || "ProgressBar.verticalSize".equals(key)) {
            Dimension dim = SyntheticaLookAndFeel.getDim("ProgressBar.verticalSize", c, null, false);
            if (dim == null) {
                dim = new Dimension(12, 146);
            }
            return SyntheticaLookAndFeel.getInstance().scaleDimension(dim);
        }
        if ("Slider.horizontalSize".equals(key)) {
            Dimension dim = SyntheticaLookAndFeel.getDim("Slider.horizontalSize", c, null, false);
            if (dim == null) {
                dim = new Dimension(200, 21);
            }
            return SyntheticaLookAndFeel.getInstance().scaleDimension(dim);
        }
        if ("Slider.verticalSize".equals(key)) {
            Dimension dim = SyntheticaLookAndFeel.getDim("Slider.verticalSize", c, null, false);
            if (dim == null) {
                dim = new Dimension(21, 200);
            }
            return SyntheticaLookAndFeel.getInstance().scaleDimension(dim);
        }
        if ("Slider.tickColor".equals(key) && !c.isEnabled() && SyntheticaLookAndFeel.get("Slider.tickColor.disabled", c) != null) {
            return SyntheticaLookAndFeel.get("Slider.tickColor.disabled", c);
        }
        if ("Slider.tickColor".equals(key) && SyntheticaLookAndFeel.get("Slider.tickColor", c) != null) {
            return SyntheticaLookAndFeel.get("Slider.tickColor", c);
        }
        if ("TabbedPane.labelShift".equals(key)) {
            return SyntheticaLookAndFeel.getInt("TabbedPane.labelShift", c, 1, false);
        }
        if ("TabbedPane.selectedLabelShift".equals(key)) {
            return SyntheticaLookAndFeel.getInt("TabbedPane.selectedLabelShift", c, -1, false);
        }
        Object o = SyntheticaLookAndFeel.get(key, c);
        if (o instanceof Icon && !(o instanceof Scalable)) {
            o = new ScalableIcon((Icon)o);
        }
        if (o != null) {
            return o;
        }
        if (this.isSynthUI(ui) && (sc = this.getContext(ui, c)) != null && sc.getStyle() != null) {
            Object value = sc.getStyle().get(sc, key);
            return value;
        }
        return super.getDefault(c, ui, key);
    }

    private boolean isSynthUI(Object ui) {
        return SynthUI.class.isAssignableFrom(ui.getClass());
    }

    private SynthContext getContext(Object ui, JComponent c) {
        return ((SynthUI)ui).getContext(c);
    }

    private Object[] asArray(Map<Object, Object> map) {
        Object[] o = new Object[map.size() * 2];
        int index = 0;
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            o[index++] = entry.getKey();
            o[index++] = entry.getValue();
        }
        return o;
    }

    private Map<Object, Object> getMacMap4JTextComponent() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put("meta A", "select-all");
        map.put("meta LEFT", "caret-begin-line");
        map.put("meta KP_LEFT", "caret-begin-line");
        map.put("meta RIGHT", "caret-end-line");
        map.put("meta KP_RIGHT", "caret-end-line");
        map.put("meta UP", "caret-begin");
        map.put("meta KP_UP", "caret-begin");
        map.put("meta DOWN", "caret-end");
        map.put("meta KP_DOWN", "caret-end");
        map.put("meta shift LEFT", "selection-begin-line");
        map.put("meta shift KP_LEFT", "selection-begin-line");
        map.put("meta shift RIGHT", "selection-end-line");
        map.put("meta shift KP_RIGHT", "selection-end-line");
        map.put("meta shift UP", "selection-begin");
        map.put("meta shift KP_UP", "selection-begin");
        map.put("meta shift DOWN", "selection-end");
        map.put("meta shift KP_DOWN", "selection-end");
        map.put("meta shift PAGE_UP", "selection-page-up");
        map.put("meta shift PAGE_DOWN", "selection-page-down");
        map.put("meta BACK_SLASH", "unselect");
        map.put("meta T", "next-link-action");
        map.put("meta shift T", "previous-link-action");
        map.put("meta SPACE", "activate-link-action");
        map.put("ctrl H", "delete-previous");
        map.put("ctrl D", "delete-next");
        map.put("ctrl W", "delete-previous-word");
        map.put("ctrl F", "caret-forward");
        map.put("ctrl B", "caret-backward");
        map.put("alt RIGHT", "caret-next-word");
        map.put("alt KP_RIGHT", "caret-next-word");
        map.put("alt LEFT", "caret-previous-word");
        map.put("alt KP_LEFT", "caret-previous-word");
        map.put("alt DELETE", "delete-next-word");
        map.put("alt BACK_SPACE", "delete-previous-word");
        map.put("shift alt RIGHT", "selection-next-word");
        map.put("shift alt KP_RIGHT", "selection-next-word");
        map.put("shift alt LEFT", "selection-previous-word");
        map.put("shift alt KP_LEFT", "selection-previous-word");
        Map customMap = (Map)UIManager.get("Synthetica.textComponent.macFocusInputMap");
        if (customMap != null) {
            map.putAll(customMap);
        }
        return map;
    }

    private Map<Object, Object> getCustomMap4TextComponent() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        Map customMap = (Map)UIManager.get("Synthetica.textComponent.focusInputMap");
        if (customMap != null) {
            map.putAll(customMap);
        }
        return map;
    }
}

