/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Component;
import java.awt.Insets;
import java.lang.reflect.Field;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;

public class SyntheticaDesktopManager
extends DefaultDesktopManager {
    private static final long serialVersionUID = -4402279640030928428L;

    @Override
    public void beginDraggingFrame(JComponent f) {
        boolean opaque = f.isOpaque();
        if (!opaque) {
            f.setOpaque(true);
        }
        super.beginDraggingFrame(f);
        f.setOpaque(opaque);
    }

    @Override
    public void dragFrame(JComponent f, int newX, int newY) {
        super.dragFrame(f, newX, newY);
        if (f instanceof JInternalFrame) {
            this.setDragging(f, false);
            this.repaintBorder(f);
            this.setDragging(f, true);
        }
    }

    private void repaintBorder(JComponent f) {
        Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.internalFrame.border.insets", (Component)f, false, true);
        int w = f.getWidth();
        int h = f.getHeight();
        f.paintImmediately(0, 0, w, insets.top);
        f.paintImmediately(0, insets.top, insets.left, h - insets.top - insets.bottom);
        f.paintImmediately(0, h - insets.bottom, w, insets.bottom);
        f.paintImmediately(w - insets.right, insets.top, insets.right, h - insets.top - insets.bottom);
    }

    private void setDragging(JComponent f, boolean dragging) {
        if (SyntheticaLookAndFeel.getJVMCompatibilityMode() == SyntheticaLookAndFeel.JVMCompatibilityMode.SUN) {
            try {
                Class<JInternalFrame> clazz = JInternalFrame.class;
                Field field = clazz.getDeclaredField("isDragging");
                field.setAccessible(true);
                field.set(f, dragging);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

