/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthStyleFactory;
import sun.swing.BakedArrayList;
import sun.swing.plaf.synth.DefaultSynthStyle;
import sun.swing.plaf.synth.StyleAssociation;

class SyntheticaStyleFactory {
    public static final int NAME = 0;
    public static final int REGION = 1;
    private List<StyleAssociation> styles;
    private BakedArrayList<Object> tmpList;
    private Map<BakedArrayList<Object>, SynthStyle> resolvedStyles;
    private SynthStyle defaultStyle;

    SyntheticaStyleFactory(SynthStyleFactory defaultFactory) {
        try {
            Class<?> clazz = Class.forName("javax.swing.plaf.synth.DefaultSynthStyleFactory");
            Field _styles = clazz.getDeclaredField("_styles");
            _styles.setAccessible(true);
            this.styles = (List)_styles.get(defaultFactory);
            Field _tmpList = clazz.getDeclaredField("_tmpList");
            _tmpList.setAccessible(true);
            this.tmpList = (BakedArrayList)_tmpList.get(defaultFactory);
            Field _resolvedStyles = clazz.getDeclaredField("_resolvedStyles");
            _resolvedStyles.setAccessible(true);
            this.resolvedStyles = (Map)_resolvedStyles.get(defaultFactory);
            Field _defaultStyle = clazz.getDeclaredField("_defaultStyle");
            _defaultStyle.setAccessible(true);
            this.defaultStyle = (SynthStyle)_defaultStyle.get(defaultFactory);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized SynthStyle getStyle(JComponent c, Region region) {
        SynthStyle style;
        BakedArrayList<Object> matches = this.tmpList;
        matches.clear();
        this.getMatchingStyles(matches, this.styles, c, region);
        if (matches.size() == 0) {
            if (this.defaultStyle == null) {
                this.defaultStyle = new DefaultSynthStyle();
                ((DefaultSynthStyle)this.defaultStyle).setFont(new FontUIResource("Dialog", 0, 12));
            }
            return this.defaultStyle;
        }
        matches.cacheHashCode();
        SynthStyle synthStyle = style = matches.size() == 0 ? null : this.resolvedStyles.get(matches);
        if (style == null && (style = this.mergeStyles(matches)) != null) {
            this.resolvedStyles.put(new BakedArrayList<Object>((List<Object>)matches), style);
        }
        return style;
    }

    private void getMatchingStyles(List<Object> matches, List<StyleAssociation> styles, JComponent c, Region region) {
        String idName = region.getName().toLowerCase(Locale.ENGLISH);
        String name = SyntheticaLookAndFeel.getStyleName(c);
        if (name == null) {
            name = "";
        }
        int counter = styles.size() - 1;
        while (counter >= 0) {
            String path;
            StyleAssociation sa = styles.get(counter);
            String string = path = sa.getID() == 0 ? name : idName;
            if (sa.matches(path) && matches.indexOf(sa.getStyle()) == -1) {
                matches.add(sa.getStyle());
            }
            --counter;
        }
    }

    private SynthStyle mergeStyles(BakedArrayList<Object> styles) {
        int size = styles.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return (SynthStyle)((DefaultSynthStyle)styles.get(0)).clone();
        }
        DefaultSynthStyle style = (DefaultSynthStyle)styles.get(size - 1);
        style = (DefaultSynthStyle)style.clone();
        int counter = size - 2;
        while (counter >= 0) {
            style = ((DefaultSynthStyle)styles.get(counter)).addTo(style);
            --counter;
        }
        return style;
    }
}

