/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class TableUtilities {
    public static boolean isDataChanged(TableModelEvent e) {
        if (e == null) {
            return false;
        }
        return e.getType() == 0 && e.getFirstRow() == 0 && e.getLastRow() == Integer.MAX_VALUE;
    }

    public static boolean isUpdate(TableModelEvent e) {
        if (TableUtilities.isStructureChanged(e)) {
            return false;
        }
        return e.getType() == 0 && e.getLastRow() < Integer.MAX_VALUE;
    }

    public static boolean isInsert(TableModelEvent e) {
        if (e == null) {
            return false;
        }
        return 1 == e.getType();
    }

    public static boolean isStructureChanged(TableModelEvent e) {
        return e == null || e.getFirstRow() == -1;
    }

    public static int getPreferredRowHeight(JTable table, int row) {
        int pref = 0;
        int column = 0;
        while (column < table.getColumnCount()) {
            TableCellRenderer renderer = table.getCellRenderer(row, column);
            Component comp = table.prepareRenderer(renderer, row, column);
            pref = Math.max(pref, comp.getPreferredSize().height);
            ++column;
        }
        return pref > 0 ? pref : table.getRowHeight();
    }

    public static void setPreferredRowHeight(JTable table, int row) {
        int prefHeight = TableUtilities.getPreferredRowHeight(table, row);
        table.setRowHeight(row, prefHeight);
    }

    public static void setPreferredRowHeights(JTable table) {
        int row = 0;
        while (row < table.getRowCount()) {
            TableUtilities.setPreferredRowHeight(table, row);
            ++row;
        }
    }

    public static int[] ordinalsOf(Enum<?> ... values) {
        int[] cols = new int[values.length];
        int i = 0;
        while (i < values.length) {
            cols[i] = values[i].ordinal();
            ++i;
        }
        return cols;
    }

    public static void clear(TableColumnModel model, boolean includeHidden) {
        if (model instanceof TableColumnModelExt) {
            TableUtilities.clear(model, ((TableColumnModelExt)model).getColumns(includeHidden));
        } else {
            TableUtilities.clear(model, Collections.list(model.getColumns()));
        }
    }

    private static void clear(TableColumnModel model, List<TableColumn> columns) {
        for (TableColumn tableColumn : columns) {
            model.removeColumn(tableColumn);
        }
    }

    private TableUtilities() {
    }
}

