/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.dataframe.matrix;

import com.macrofocus.molap.dataframe.matrix.AbstractMatrix;
import com.macrofocus.molap.dataframe.matrix.Matrix;
import com.macrofocus.molap.index.UniqueIndex;

public class ColumnCorrelationMatrix<R, C>
extends AbstractMatrix<C, C> {
    private final Matrix<R, C> a;
    private final double[] b;
    private final double[] c;
    private final double[] d;
    private final int[] e;

    public ColumnCorrelationMatrix(Matrix<R, C> matrix) {
        Object Column2;
        Object Row2;
        int n2;
        int n3;
        this.a = matrix;
        this.b = new double[this.a.getColumnCount()];
        this.c = new double[this.a.getColumnCount()];
        this.d = new double[this.a.getColumnCount()];
        this.e = new int[this.a.getColumnCount()];
        for (n3 = 0; n3 < this.a.getColumnCount(); ++n3) {
            this.b[n3] = 0.0;
            this.c[n3] = 0.0;
            this.d[n3] = 0.0;
            this.e[n3] = 0;
        }
        for (n3 = 0; n3 < this.a.getColumnCount(); ++n3) {
            for (n2 = 0; n2 < this.a.getRowCount(); ++n2) {
                Row2 = matrix.getRowKey(n2);
                if (!this.a.isAvailable(Row2, Column2 = matrix.getColumnKey(n3))) continue;
                int n4 = n3;
                this.e[n4] = this.e[n4] + 1;
                int n5 = n3;
                this.d[n5] = this.d[n5] + this.a.getDouble(Row2, Column2);
            }
            this.b[n3] = this.d[n3] / (double)this.e[n3];
        }
        for (n3 = 0; n3 < this.a.getColumnCount(); ++n3) {
            for (n2 = 0; n2 < this.a.getRowCount(); ++n2) {
                Row2 = matrix.getRowKey(n2);
                if (!this.a.isAvailable(Row2, Column2 = matrix.getColumnKey(n3))) continue;
                double d2 = this.a.getDouble(Row2, Column2) - this.b[n3];
                int n6 = n3;
                double d3 = d2;
                this.c[n6] = this.c[n6] + d3 * d3;
            }
            this.c[n3] = Math.sqrt(this.c[n3]);
        }
    }

    @Override
    public double getDouble(C row, C column) {
        double d2;
        double d3 = 0.0;
        int n2 = this.a.getColumnAddress(row);
        int n3 = this.a.getColumnAddress(column);
        for (int i2 = 0; i2 < this.a.getRowCount(); ++i2) {
            Object Row2 = this.a.getRowKey(i2);
            if (!this.a.isAvailable(Row2, row) || !this.a.isAvailable(Row2, column)) continue;
            d3 += (this.a.getDouble(Row2, row) - this.b[n2]) * (this.a.getDouble(Row2, column) - this.b[n3]);
        }
        d3 /= this.c[n2] * this.c[n3];
        if (d2 > 1.0) {
            d3 = 1.0;
        }
        if (d3 < -1.0) {
            d3 = 1.0;
        }
        return d3;
    }

    @Override
    public UniqueIndex<C> getRowIndex() {
        return this.a.getColumnIndex();
    }

    @Override
    public UniqueIndex<C> getColumnIndex() {
        return this.a.getColumnIndex();
    }
}

