/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.impl.hash;

import gnu.trove.impl.Constants;
import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.TPrimitiveHash;
import gnu.trove.procedure.TIntProcedure;
import java.util.Arrays;

public abstract class TIntHash
extends TPrimitiveHash {
    public transient int[] _set;
    protected int no_entry_value;
    protected boolean consumeFreeSlot;

    public TIntHash() {
        this.no_entry_value = Constants.DEFAULT_INT_NO_ENTRY_VALUE;
        if (this.no_entry_value != 0) {
            Arrays.fill(this._set, this.no_entry_value);
        }
    }

    /*
     * WARNING - void declaration
     */
    public TIntHash(int initialCapacity) {
        super((int)var1_1);
        void var1_1;
        this.no_entry_value = Constants.DEFAULT_INT_NO_ENTRY_VALUE;
        if (this.no_entry_value != 0) {
            Arrays.fill(this._set, this.no_entry_value);
        }
    }

    /*
     * WARNING - void declaration
     */
    public TIntHash(int initialCapacity, float loadFactor) {
        super((int)var1_1, (float)var2_2);
        void var2_2;
        void var1_1;
        this.no_entry_value = Constants.DEFAULT_INT_NO_ENTRY_VALUE;
        if (this.no_entry_value != 0) {
            Arrays.fill(this._set, this.no_entry_value);
        }
    }

    /*
     * WARNING - void declaration
     */
    public TIntHash(int initialCapacity, float loadFactor, int no_entry_value) {
        super((int)var1_1, (float)var2_2);
        void var2_2;
        void var1_1;
        this.no_entry_value = no_entry_value;
        if (no_entry_value != 0) {
            void var3_3;
            Arrays.fill(this._set, (int)var3_3);
        }
    }

    public int getNoEntryValue() {
        return this.no_entry_value;
    }

    @Override
    protected int setUp(int initialCapacity) {
        int n2;
        n2 = super.setUp(n2);
        this._set = new int[n2];
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(int val) {
        void var1_1;
        return this.index((int)var1_1) >= 0;
    }

    public boolean forEach(TIntProcedure procedure) {
        byte[] byArray = this._states;
        int[] nArray = this._set;
        int n2 = this._set.length;
        while (n2-- > 0) {
            if (byArray[n2] != 1 || procedure.execute(nArray[n2])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void removeAt(int index) {
        void var1_1;
        this._set[index] = this.no_entry_value;
        super.removeAt((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected int index(int val) {
        void var1_1;
        byte[] byArray = this._states;
        int[] nArray = this._set;
        int n2 = byArray.length;
        int n3 = HashFunctions.hash(val) & Integer.MAX_VALUE;
        n2 = n3 % n2;
        int n4 = byArray[n2];
        if (n4 == 0) {
            return -1;
        }
        if (n4 == 1 && nArray[n2] == val) {
            return n2;
        }
        n4 = n3;
        n3 = var1_1;
        TIntHash tIntHash = this;
        int n5 = tIntHash._set.length;
        int n6 = 1 + n4 % (n5 - 2);
        int n7 = n2;
        do {
            if ((n2 -= n6) < 0) {
                n2 += n5;
            }
            if ((n4 = tIntHash._states[n2]) == 0) {
                return -1;
            }
            if (n3 != tIntHash._set[n2] || n4 == 2) continue;
            return n2;
        } while (n2 != n7);
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    protected int insertKey(int val) {
        void var1_1;
        int n2 = HashFunctions.hash(val) & Integer.MAX_VALUE;
        int n3 = n2 % this._states.length;
        int n4 = this._states[n3];
        this.consumeFreeSlot = false;
        if (n4 == 0) {
            this.consumeFreeSlot = true;
            this.a(n3, val);
            return n3;
        }
        if (n4 == 1 && this._set[n3] == val) {
            return -n3 - 1;
        }
        int n5 = n4;
        n4 = n2;
        n2 = var1_1;
        TIntHash tIntHash = this;
        int n6 = tIntHash._set.length;
        n4 = 1 + n4 % (n6 - 2);
        int n7 = n3;
        int n8 = -1;
        do {
            if (n5 == 2 && n8 == -1) {
                n8 = n3;
            }
            if ((n3 -= n4) < 0) {
                n3 += n6;
            }
            if ((n5 = tIntHash._states[n3]) == 0) {
                if (n8 != -1) {
                    tIntHash.a(n8, n2);
                    return n8;
                }
                tIntHash.consumeFreeSlot = true;
                tIntHash.a(n3, n2);
                return n3;
            }
            if (n5 != 1 || tIntHash._set[n3] != n2) continue;
            return -n3 - 1;
        } while (n3 != n7);
        if (n8 != -1) {
            tIntHash.a(n8, n2);
            return n8;
        }
        throw new IllegalStateException("No free or removed slots available. Key set full?!!");
    }

    private void a(int n2, int n3) {
        this._set[n2] = n3;
        this._states[n2] = 1;
    }
}

