/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.db;

import com.macrofocus.data.db.DB2DatabaseDriver;
import com.macrofocus.data.db.DatabaseDriver;
import com.macrofocus.data.db.DerbyDatabaseDriver;
import com.macrofocus.data.db.H2DatabaseDriver;
import com.macrofocus.data.db.HSQLDBDatabaseDriver;
import com.macrofocus.data.db.JTDSSQLServerDatabaseDriver;
import com.macrofocus.data.db.MaxDBDatabaseDriver;
import com.macrofocus.data.db.MySQLDatabaseDriver;
import com.macrofocus.data.db.ODBCDatabaseDriver;
import com.macrofocus.data.db.OracleDatabaseDriver;
import com.macrofocus.data.db.PostGISDatabaseDriver;
import com.macrofocus.data.db.PostgreSQLDatabaseDriver;
import com.macrofocus.data.db.SQLServerDatabaseDriver;
import java.util.ArrayList;
import java.util.List;

public class DatabaseDriverFactory {
    private static final DatabaseDriver defaultValue;
    private static final List<DatabaseDriver> values;

    public static DatabaseDriver getDefault() {
        return defaultValue;
    }

    public static Iterable<DatabaseDriver> getDatabaseDrivers() {
        return values;
    }

    public static DatabaseDriver get(String name) {
        for (DatabaseDriver value : values) {
            if (!value.toString().equals(name)) continue;
            return value;
        }
        return DatabaseDriverFactory.getDefault();
    }

    public static DatabaseDriver find(String name) {
        for (DatabaseDriver value : values) {
            if (!value.toString().equals(name)) continue;
            return value;
        }
        return null;
    }

    static {
        values = new ArrayList<DatabaseDriver>();
        try {
            if (MySQLDatabaseDriver.exist()) {
                values.add(new MySQLDatabaseDriver());
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            if (OracleDatabaseDriver.exist()) {
                values.add(new OracleDatabaseDriver());
            }
        }
        catch (NoClassDefFoundError e) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            if (SQLServerDatabaseDriver.exist()) {
                values.add(new SQLServerDatabaseDriver());
            }
        }
        catch (NoClassDefFoundError e) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            if (JTDSSQLServerDatabaseDriver.exist()) {
                values.add(new JTDSSQLServerDatabaseDriver());
            }
        }
        catch (NoClassDefFoundError e) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            if (PostgreSQLDatabaseDriver.exist()) {
                values.add(new PostgreSQLDatabaseDriver());
            }
        }
        catch (NoClassDefFoundError e) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            if (DB2DatabaseDriver.exist()) {
                values.add(new DB2DatabaseDriver());
            }
        }
        catch (NoClassDefFoundError e) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            if (MaxDBDatabaseDriver.exist()) {
                values.add(new MaxDBDatabaseDriver());
            }
        }
        catch (NoClassDefFoundError e) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            if (PostGISDatabaseDriver.exist()) {
                values.add(new PostGISDatabaseDriver());
            }
        }
        catch (NoClassDefFoundError e) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            if (DerbyDatabaseDriver.exist()) {
                values.add(new DerbyDatabaseDriver());
            }
        }
        catch (NoClassDefFoundError e) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            if (H2DatabaseDriver.exist()) {
                values.add(new H2DatabaseDriver());
            }
        }
        catch (NoClassDefFoundError e) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            if (HSQLDBDatabaseDriver.exist()) {
                values.add(new HSQLDBDatabaseDriver());
            }
        }
        catch (NoClassDefFoundError e) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            if (ODBCDatabaseDriver.exist()) {
                values.add(new ODBCDatabaseDriver());
            }
        }
        catch (NoClassDefFoundError e) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        defaultValue = values.size() > 0 ? values.get(0) : null;
    }
}

