/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.matrix.vector;

import com.macrofocus.data.matrix.vector.QuartilesVectorModel;
import com.macrofocus.data.matrix.vector.VectorModel;

public class VectorHelper {
    public static double getEuclideanNorm(VectorModel vectorModel) {
        double sum = 0.0;
        for (int i = 0; i < vectorModel.getRowCount(); ++i) {
            if (!vectorModel.isAvailable(i)) continue;
            sum += vectorModel.getDouble(i) * vectorModel.getDouble(i);
        }
        return Math.sqrt(sum);
    }

    public static double getDotProduct(VectorModel vectorModel1, VectorModel vectorModel2) {
        double sum = 0.0;
        int dim = Math.min(vectorModel1.getRowCount(), vectorModel2.getRowCount());
        for (int i = 0; i < dim; ++i) {
            if (!vectorModel1.isAvailable(i) || !vectorModel2.isAvailable(i)) continue;
            sum += vectorModel1.getDouble(i) * vectorModel2.getDouble(i);
        }
        return sum;
    }

    public static double[] getDoubleArray(VectorModel vectorModel) {
        double[] array = new double[vectorModel.getRowCount()];
        for (int i = 0; i < vectorModel.getRowCount(); ++i) {
            array[i] = vectorModel.getDouble(i);
        }
        return array;
    }

    public static double getMimimum(VectorModel vectorModel) {
        double min = Double.MAX_VALUE;
        for (int i = 0; i < vectorModel.getRowCount(); ++i) {
            double value;
            if (!vectorModel.isAvailable(i) || !(min > (value = vectorModel.getDouble(i)))) continue;
            min = value;
        }
        if (min == Double.MAX_VALUE) {
            return Double.NaN;
        }
        return min;
    }

    public static double getMaximum(VectorModel vectorModel) {
        double max = -1.7976931348623157E308;
        for (int i = 0; i < vectorModel.getRowCount(); ++i) {
            double value;
            if (!vectorModel.isAvailable(i) || !(max < (value = vectorModel.getDouble(i)))) continue;
            max = value;
        }
        if (max == -1.7976931348623157E308) {
            return Double.NaN;
        }
        return max;
    }

    public static double getSum(VectorModel vectorModel) {
        double sum = 0.0;
        for (int i = 0; i < vectorModel.getRowCount(); ++i) {
            if (!vectorModel.isAvailable(i)) continue;
            double value = vectorModel.getDouble(i);
            sum += value;
        }
        return sum;
    }

    public static int getAvailableCount(VectorModel vectorModel) {
        int count = 0;
        for (int i = 0; i < vectorModel.getRowCount(); ++i) {
            if (!vectorModel.isAvailable(i)) continue;
            ++count;
        }
        return count;
    }

    public static double getAverage(VectorModel vectorModel) {
        double sum = 0.0;
        int count = 0;
        for (int row = 0; row < vectorModel.getRowCount(); ++row) {
            if (!vectorModel.isAvailable(row)) continue;
            double value = vectorModel.getDouble(row);
            sum += value;
            ++count;
        }
        return sum / (double)count;
    }

    public static double getStdDev(VectorModel vectorModel) {
        double sum2 = 0.0;
        double sum = 0.0;
        double average = VectorHelper.getAverage(vectorModel);
        int count = 0;
        for (int i = 0; i < vectorModel.getRowCount(); ++i) {
            if (!vectorModel.isAvailable(i)) continue;
            double value = vectorModel.getDouble(i) - average;
            sum2 += value * value;
            sum += value;
            ++count;
        }
        average = sum / (double)count;
        return Math.sqrt(sum2 / (double)count - average * average);
    }

    public static double getMedian(VectorModel vectorModel) {
        QuartilesVectorModel quartilesVectorModel = new QuartilesVectorModel(vectorModel);
        return quartilesVectorModel.getMedianValue();
    }
}

