/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source;

import com.macrofocus.data.dataframe.DefaultDataFrame;
import com.macrofocus.data.source.DataSource;
import com.macrofocus.data.source.DataSourceFactory;
import com.macrofocus.data.source.FileURLDataSource;
import com.macrofocus.data.table.JSONTableModel;
import com.macrofocus.data.table.SimpleTableModel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.IndexedDataFrame;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import com.macrofocus.molap.series.Series;
import com.macrofocus.molap.series.SeriesFactory;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableModel;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeNanoVector;
import org.apache.arrow.vector.TimeSecVector;
import org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.arrow.vector.TimeStampMilliVector;
import org.apache.arrow.vector.TimeStampNanoVector;
import org.apache.arrow.vector.TimeStampSecVector;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.pojo.ArrowType;

public class ArrowDataSource
extends FileURLDataSource {
    static final String type = "Arrow";
    private static RootAllocator allocator;
    private int batch;

    public ArrowDataSource(File file) {
        super(file);
    }

    public ArrowDataSource(URL url) {
        super(url);
    }

    @Override
    public String getType() {
        return type;
    }

    @Override
    public TableModel loadTableModel(Component contentPane) throws IOException, SQLException {
        TableModel tableModel = this.load(contentPane, true);
        return tableModel;
    }

    public TableModel load(Component contentPane, boolean autoConvert) throws IOException {
        BufferedInputStream bis = this.getInputStream(this.checkContentPane(contentPane));
        JSONTableModel dataReader = new JSONTableModel(bis);
        SimpleTableModel tableModel = new SimpleTableModel((TableModel)dataReader, autoConvert);
        bis.close();
        return tableModel;
    }

    public static void allocate(long limit) {
        if (limit <= 0L) {
            throw new IllegalArgumentException("Invalid RootAllocator limit: " + limit);
        }
        allocator = new RootAllocator(limit);
    }

    @Override
    public MutableDataFrame<Integer, String, Object> loadDataFrame(Component contentPane) throws IOException, SQLException {
        BufferedInputStream bis = this.getInputStream(this.checkContentPane(contentPane));
        return this.loadDataFrameFromInputStream(bis);
    }

    public MutableDataFrame<Integer, String, Object> loadDataFrameFromInputStream(InputStream bis) throws IOException, SQLException {
        int limit = Integer.MAX_VALUE;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        stream.write(ArrowDataSource.readAllBytes(bis));
        if (allocator == null) {
            ArrowDataSource.allocate(Long.MAX_VALUE);
        }
        try (ArrowStreamReader reader = new ArrowStreamReader((InputStream)new ByteArrayInputStream(stream.toByteArray()), (BufferAllocator)allocator);){
            VectorSchemaRoot root = reader.getVectorSchemaRoot();
            ArrayList<IndexedDataFrame> frames = new ArrayList<IndexedDataFrame>();
            for (int size = 0; reader.loadNextBatch() && size < Integer.MAX_VALUE; size += frames.size()) {
                List fieldVectors = root.getFieldVectors();
                Series[] vectors = new Series[fieldVectors.size()];
                block29: for (int j = 0; j < fieldVectors.size(); ++j) {
                    FieldVector fieldVector = (FieldVector)fieldVectors.get(j);
                    ArrowType type = fieldVector.getField().getType();
                    switch (type.getTypeID()) {
                        case Int: {
                            ArrowType.Int itype = (ArrowType.Int)type;
                            int bitWidth = itype.getBitWidth();
                            switch (bitWidth) {
                                case 8: {
                                    vectors[j] = this.readByteField(fieldVector);
                                    continue block29;
                                }
                                case 16: {
                                    if (itype.getIsSigned()) {
                                        vectors[j] = this.readShortField(fieldVector);
                                        continue block29;
                                    }
                                    vectors[j] = this.readCharField(fieldVector);
                                    continue block29;
                                }
                                case 32: {
                                    vectors[j] = this.readIntField(fieldVector);
                                    continue block29;
                                }
                                case 64: {
                                    vectors[j] = this.readLongField(fieldVector);
                                    continue block29;
                                }
                            }
                            throw new UnsupportedOperationException("Unsupported integer bit width: " + bitWidth);
                        }
                        case FloatingPoint: {
                            FloatingPointPrecision precision = ((ArrowType.FloatingPoint)type).getPrecision();
                            switch (precision) {
                                case DOUBLE: {
                                    vectors[j] = this.readDoubleField(fieldVector);
                                    continue block29;
                                }
                                case SINGLE: {
                                    vectors[j] = this.readFloatField(fieldVector);
                                    continue block29;
                                }
                                case HALF: {
                                    throw new UnsupportedOperationException("Unsupported float precision: " + String.valueOf(precision));
                                }
                            }
                            continue block29;
                        }
                        case Decimal: {
                            vectors[j] = this.readDecimalField(fieldVector);
                            continue block29;
                        }
                        case Bool: {
                            vectors[j] = this.readBitField(fieldVector);
                            continue block29;
                        }
                        case Date: {
                            vectors[j] = this.readDateField(fieldVector);
                            continue block29;
                        }
                        case Time: {
                            vectors[j] = this.readTimeField(fieldVector);
                            continue block29;
                        }
                        case Timestamp: {
                            vectors[j] = this.readDateTimeField(fieldVector);
                            continue block29;
                        }
                        case Binary: 
                        case FixedSizeBinary: {
                            vectors[j] = this.readByteArrayField(fieldVector);
                            continue block29;
                        }
                        case Utf8: {
                            vectors[j] = this.readStringField(fieldVector);
                            continue block29;
                        }
                        default: {
                            throw new UnsupportedOperationException("Unsupported column type: " + String.valueOf(fieldVector.getMinorType()));
                        }
                    }
                }
                IndexedDataFrame frame = new IndexedDataFrame(vectors);
                frames.add(frame);
            }
            if (frames.isEmpty()) {
                throw new IllegalStateException("No record batch");
            }
            if (frames.size() == 1) {
                DefaultDataFrame<Object> defaultDataFrame = new DefaultDataFrame<Object>((DataFrame)frames.get(0));
                return defaultDataFrame;
            }
            throw new UnsupportedOperationException("Multiple batches is not yet supported");
        }
    }

    public static byte[] readAllBytes(InputStream inputStream) throws IOException {
        int bufLen = 4096;
        byte[] buf = new byte[4096];
        IOException exception = null;
        try {
            byte[] byArray;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                int readLen;
                while ((readLen = inputStream.read(buf, 0, 4096)) != -1) {
                    outputStream.write(buf, 0, readLen);
                }
                byArray = outputStream.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        outputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    exception = e;
                    throw e;
                }
            }
            outputStream.close();
            return byArray;
        }
        finally {
            if (exception == null) {
                inputStream.close();
            } else {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    exception.addSuppressed(e);
                }
            }
        }
    }

    private Series readBitField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        BitVector vector = (BitVector)fieldVector;
        Object[] a = new Boolean[count];
        for (int i = 0; i < count; ++i) {
            a[i] = vector.isNull(i) ? null : Boolean.valueOf(vector.get(i) != 0);
        }
        return SeriesFactory.create((Object)fieldVector.getField().getName(), (Object[])a);
    }

    private Series readByteField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        TinyIntVector vector = (TinyIntVector)fieldVector;
        Object[] a = new Byte[count];
        for (int i = 0; i < count; ++i) {
            a[i] = vector.isNull(i) ? null : Byte.valueOf(vector.get(i));
        }
        return SeriesFactory.create((Object)fieldVector.getField().getName(), (Object[])a);
    }

    private Series readCharField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        SmallIntVector vector = (SmallIntVector)fieldVector;
        Object[] a = new Character[count];
        for (int i = 0; i < count; ++i) {
            a[i] = vector.isNull(i) ? null : Character.valueOf((char)vector.get(i));
        }
        return SeriesFactory.create((Object)fieldVector.getField().getName(), (Object[])a);
    }

    private Series readShortField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        SmallIntVector vector = (SmallIntVector)fieldVector;
        Object[] a = new Short[count];
        for (int i = 0; i < count; ++i) {
            a[i] = vector.isNull(i) ? null : Short.valueOf(vector.get(i));
        }
        return SeriesFactory.create((Object)fieldVector.getField().getName(), (Object[])a);
    }

    private Series readIntField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        IntVector vector = (IntVector)fieldVector;
        Object[] a = new Integer[count];
        for (int i = 0; i < count; ++i) {
            a[i] = vector.isNull(i) ? null : Integer.valueOf(vector.get(i));
        }
        return SeriesFactory.create((Object)fieldVector.getField().getName(), (Object[])a);
    }

    private Series readLongField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        BigIntVector vector = (BigIntVector)fieldVector;
        Object[] a = new Long[count];
        for (int i = 0; i < count; ++i) {
            a[i] = vector.isNull(i) ? null : Long.valueOf(vector.get(i));
        }
        return SeriesFactory.create((Object)fieldVector.getField().getName(), (Object[])a);
    }

    private Series readFloatField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        Float4Vector vector = (Float4Vector)fieldVector;
        Object[] a = new Float[count];
        for (int i = 0; i < count; ++i) {
            a[i] = vector.isNull(i) ? null : Float.valueOf(vector.get(i));
        }
        return SeriesFactory.create((Object)fieldVector.getField().getName(), (Object[])a);
    }

    private Series readDoubleField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        Float8Vector vector = (Float8Vector)fieldVector;
        Object[] a = new Double[count];
        for (int i = 0; i < count; ++i) {
            a[i] = vector.isNull(i) ? null : Double.valueOf(vector.get(i));
        }
        return SeriesFactory.create((Object)fieldVector.getField().getName(), (Object[])a);
    }

    private Series readDecimalField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        Object[] a = new BigDecimal[count];
        DecimalVector vector = (DecimalVector)fieldVector;
        for (int i = 0; i < count; ++i) {
            a[i] = vector.isNull(i) ? null : vector.getObject(i);
        }
        return SeriesFactory.create((Object)fieldVector.getField().getName(), (Object[])a);
    }

    private Series readDateField(FieldVector fieldVector) {
        Object[] a;
        block3: {
            ZoneOffset zone;
            int count;
            block2: {
                count = fieldVector.getValueCount();
                a = new LocalDate[count];
                zone = OffsetDateTime.now().getOffset();
                if (!(fieldVector instanceof DateDayVector)) break block2;
                DateDayVector vector = (DateDayVector)fieldVector;
                for (int i = 0; i < count; ++i) {
                    a[i] = vector.isNull(i) ? null : LocalDate.ofEpochDay(vector.get(i));
                }
                break block3;
            }
            if (!(fieldVector instanceof DateMilliVector)) break block3;
            DateMilliVector vector = (DateMilliVector)fieldVector;
            for (int i = 0; i < count; ++i) {
                a[i] = vector.isNull(i) ? null : LocalDateTime.ofInstant(Instant.ofEpochMilli(vector.get(i)), zone).toLocalDate();
            }
        }
        return SeriesFactory.create((Object)fieldVector.getField().getName(), (Object[])a);
    }

    private Series readTimeField(FieldVector fieldVector) {
        Object[] a;
        block5: {
            int count;
            block7: {
                block6: {
                    block4: {
                        count = fieldVector.getValueCount();
                        a = new LocalTime[count];
                        if (!(fieldVector instanceof TimeNanoVector)) break block4;
                        TimeNanoVector vector = (TimeNanoVector)fieldVector;
                        for (int i = 0; i < count; ++i) {
                            a[i] = vector.isNull(i) ? null : LocalTime.ofNanoOfDay(vector.get(i));
                        }
                        break block5;
                    }
                    if (!(fieldVector instanceof TimeMilliVector)) break block6;
                    TimeMilliVector vector = (TimeMilliVector)fieldVector;
                    for (int i = 0; i < count; ++i) {
                        a[i] = vector.isNull(i) ? null : LocalTime.ofNanoOfDay(vector.get(i) * 1000000);
                    }
                    break block5;
                }
                if (!(fieldVector instanceof TimeMicroVector)) break block7;
                TimeMicroVector vector = (TimeMicroVector)fieldVector;
                for (int i = 0; i < count; ++i) {
                    a[i] = vector.isNull(i) ? null : LocalTime.ofNanoOfDay(vector.get(i) * 1000L);
                }
                break block5;
            }
            if (!(fieldVector instanceof TimeSecVector)) break block5;
            TimeSecVector vector = (TimeSecVector)fieldVector;
            for (int i = 0; i < count; ++i) {
                a[i] = vector.isNull(i) ? null : LocalTime.ofSecondOfDay(vector.get(i));
            }
        }
        return SeriesFactory.create((Object)fieldVector.getField().getName(), (Object[])a);
    }

    private Series readDateTimeField(FieldVector fieldVector) {
        Object[] a;
        block5: {
            ZoneOffset zone;
            TimeStampVector vector;
            int count;
            block7: {
                block6: {
                    block4: {
                        count = fieldVector.getValueCount();
                        a = new LocalDateTime[count];
                        vector = (TimeStampVector)fieldVector;
                        String timezone = ((ArrowType.Timestamp)fieldVector.getField().getType()).getTimezone();
                        ZoneOffset zoneOffset = zone = timezone == null ? OffsetDateTime.now().getOffset() : ZoneOffset.of(timezone);
                        if (!(fieldVector instanceof TimeStampMilliVector)) break block4;
                        for (int i = 0; i < count; ++i) {
                            a[i] = vector.isNull(i) ? null : LocalDateTime.ofInstant(Instant.ofEpochMilli(vector.get(i)), zone);
                        }
                        break block5;
                    }
                    if (!(fieldVector instanceof TimeStampNanoVector)) break block6;
                    for (int i = 0; i < count; ++i) {
                        a[i] = vector.isNull(i) ? null : LocalDateTime.ofInstant(Instant.ofEpochMilli(vector.get(i) / 1000000L), zone);
                    }
                    break block5;
                }
                if (!(fieldVector instanceof TimeStampMicroVector)) break block7;
                for (int i = 0; i < count; ++i) {
                    a[i] = vector.isNull(i) ? null : LocalDateTime.ofInstant(Instant.ofEpochMilli(vector.get(i) / 1000L), zone);
                }
                break block5;
            }
            if (!(fieldVector instanceof TimeStampSecVector)) break block5;
            for (int i = 0; i < count; ++i) {
                a[i] = vector.isNull(i) ? null : LocalDateTime.ofEpochSecond(vector.get(i), 0, zone);
            }
        }
        return SeriesFactory.create((Object)fieldVector.getField().getName(), (Object[])a);
    }

    private Series readByteArrayField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        byte[][] a = new byte[count][];
        if (fieldVector instanceof VarBinaryVector) {
            VarBinaryVector vector = (VarBinaryVector)fieldVector;
            for (int i = 0; i < count; ++i) {
                a[i] = (byte[])(vector.isNull(i) ? null : vector.get(i));
            }
        } else if (fieldVector instanceof FixedSizeBinaryVector) {
            FixedSizeBinaryVector vector = (FixedSizeBinaryVector)fieldVector;
            for (int i = 0; i < count; ++i) {
                a[i] = (byte[])(vector.isNull(i) ? null : vector.get(i));
            }
        } else {
            throw new UnsupportedOperationException("Unsupported binary vector: " + String.valueOf(fieldVector));
        }
        return SeriesFactory.create((Object)fieldVector.getField().getName(), (Object[])a);
    }

    private Series readStringField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        VarCharVector vector = (VarCharVector)fieldVector;
        Object[] a = new String[count];
        for (int i = 0; i < count; ++i) {
            a[i] = vector.isNull(i) ? null : new String(vector.get(i));
        }
        return SeriesFactory.create((Object)fieldVector.getField().getName(), (Object[])a);
    }

    public static void main(String[] args) {
        DataSource dataSource = DataSourceFactory.getDataSource(new File("/Users/luc/macrofocus/swissgrid/test.feather"));
        try {
            dataSource.loadDataFrame(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
    }
}

