/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source;

import com.macrofocus.data.dataframe.DefaultDataFrame;
import com.macrofocus.data.source.FileURLDataSource;
import com.macrofocus.data.table.GeoJSONTableModel;
import com.macrofocus.data.table.SimpleTableModel;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import javax.swing.table.TableModel;

public class GeoJSONDataSource
extends FileURLDataSource {
    static final String type = "GeoJSON";

    public GeoJSONDataSource(File file) {
        super(file);
    }

    public GeoJSONDataSource(URL url) {
        super(url);
    }

    @Override
    public String getType() {
        return type;
    }

    @Override
    public TableModel loadTableModel(Component contentPane) throws IOException, SQLException {
        TableModel tableModel = this.load(contentPane, true);
        return tableModel;
    }

    public TableModel load(Component contentPane, boolean autoConvert) throws IOException {
        BufferedInputStream bis = this.getInputStream(this.checkContentPane(contentPane));
        GeoJSONTableModel dataReader = new GeoJSONTableModel(bis);
        SimpleTableModel tableModel = new SimpleTableModel((TableModel)dataReader, autoConvert);
        bis.close();
        return tableModel;
    }

    @Override
    public MutableDataFrame<Integer, String, Object> loadDataFrame(Component contentPane) throws IOException, SQLException {
        BufferedInputStream bis = this.getInputStream(this.checkContentPane(contentPane));
        GeoJSONTableModel tableModel = new GeoJSONTableModel(bis);
        return new DefaultDataFrame<Object>(tableModel, true);
    }
}

