/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source.zip;

import com.macrofocus.data.source.zip.PasswordProvider;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;

public class SwingPasswordProvider
implements PasswordProvider {
    private final Component parent;
    private JDialog dialog = null;
    private JOptionPane optionPane;
    private PasswordPanel passwordPanel;
    private char[] password = null;

    public SwingPasswordProvider(Component parent) {
        this.parent = parent;
    }

    @Override
    public char[] getPassword() {
        if (this.password != null) {
            return this.password;
        }
        if (this.dialog == null) {
            this.passwordPanel = new PasswordPanel();
            this.optionPane = new JOptionPane(this.passwordPanel, -1, 2);
            this.dialog = this.optionPane.createDialog(this.parent, "Enter password");
            this.dialog.addWindowFocusListener(new WindowAdapter(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SwingPasswordProvider.this.passwordPanel.requestFocus();
                        }
                    });
                }
            });
        }
        this.dialog.setModal(true);
        this.dialog.setVisible(true);
        this.dialog.toFront();
        if (this.optionPane.getValue() != null && this.optionPane.getValue().equals(0)) {
            this.password = this.passwordPanel.getPassword();
            return this.password;
        }
        this.password = null;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingPasswordProvider.this.dispose();
            }
        });
        return null;
    }

    @Override
    public void dispose() {
        this.password = null;
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
        this.dialog = null;
        this.optionPane = null;
        this.passwordPanel = null;
    }

    @Override
    public void setPassword(char[] password) {
        this.password = password;
    }

    @Override
    public void invalidatePassword() {
        this.password = null;
    }

    public class PasswordPanel
    extends JPanel {
        private final JPasswordField passwordField;

        @Override
        public void requestFocus() {
            super.requestFocus();
            this.passwordField.requestFocusInWindow();
        }

        public PasswordPanel() {
            super(new FlowLayout());
            this.passwordField = new JPasswordField(20);
            this.add(new JLabel("Password: "));
            this.add(this.passwordField);
        }

        public char[] getPassword() {
            return this.passwordField.getPassword();
        }
    }
}

