/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source.zip;

import com.macrofocus.data.source.zip.PasswordProvider;
import com.macrofocus.data.source.zip.ZipArchiveEntry;
import com.macrofocus.data.source.zip.ZipExtraField;
import com.macrofocus.data.source.zip.ZipShort;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import org.apache.commons.io.EndianUtils;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.modes.SICBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class WinzipAesDecryptedZipInputStream
extends InputStream {
    private CipherParameters aesCipherParameters = null;
    private byte aesEncryptionStrength = 0;
    private InputStream baseInputStream = null;
    private int compressionType = 0;
    private byte[] cryptoKeyBytes = null;
    private final PasswordProvider passwordProvider;
    private byte[] passwordVerificationBytes = null;
    private byte[] saltBytes = null;

    private static String byteArrayToHexString(byte[] theByteArray) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < theByteArray.length; ++i) {
            String s = Integer.toHexString(theByteArray[i] & 0xFF);
            if (s.length() < 2) {
                out.append('0');
            }
            out.append(s).append(' ');
        }
        return out.toString();
    }

    private static boolean isEqual(byte[] first, byte[] second) {
        boolean out = first != null && second != null && first.length == second.length;
        for (int i = 0; out && i < first.length; ++i) {
            if (first[i] == second[i]) continue;
            out = false;
        }
        return out;
    }

    public static byte[] toByteArray(int in) {
        byte[] out = new byte[]{(byte)in, (byte)(in >> 8), (byte)(in >> 16), (byte)(in >> 24)};
        return out;
    }

    public static byte[] toByteArray(int in, int outSize) {
        byte[] out = new byte[outSize];
        byte[] intArray = WinzipAesDecryptedZipInputStream.toByteArray(in);
        for (int i = 0; i < intArray.length && i < outSize; ++i) {
            out[i] = intArray[i];
        }
        return out;
    }

    public WinzipAesDecryptedZipInputStream(ZipArchiveEntry zipEntry, InputStream is, PasswordProvider passwordProvider) throws IOException {
        this.passwordProvider = passwordProvider;
        this.initialize(zipEntry, is);
        this.setupInputStream(zipEntry, is);
    }

    private void initialize(ZipArchiveEntry zipEntry, InputStream is) throws IOException {
        ZipExtraField aesExtraDataField = zipEntry.getExtraField(new ZipShort(39169));
        byte[] extraData = aesExtraDataField.getLocalFileDataData();
        this.aesEncryptionStrength = extraData[4];
        byte[] data = aesExtraDataField.getLocalFileDataData();
        byte[] compression = new byte[]{data[5], data[6]};
        this.compressionType = EndianUtils.readSwappedShort((byte[])compression, (int)0);
        int saltBytesLength = 8;
        int aesKeyBitLength = 128;
        if (this.aesEncryptionStrength == 2) {
            saltBytesLength = 12;
            aesKeyBitLength = 192;
        }
        if (this.aesEncryptionStrength == 3) {
            saltBytesLength = 16;
            aesKeyBitLength = 256;
        }
        this.saltBytes = new byte[saltBytesLength];
        is.read(this.saltBytes, 0, saltBytesLength);
        this.passwordVerificationBytes = new byte[2];
        is.read(this.passwordVerificationBytes, 0, 2);
        char[] password = null;
        while ((password = this.passwordProvider.getPassword()) != null && !this.checkPassword(aesKeyBitLength, password)) {
            this.passwordProvider.invalidatePassword();
        }
        if (password == null) {
            throw new ZipException("Wrong password");
        }
    }

    private boolean checkPassword(int aesKeyBitLength, char[] password) {
        if (password != null) {
            PKCS5S2ParametersGenerator generator = new PKCS5S2ParametersGenerator();
            byte[] passwordBytes = password != null ? new String(password).getBytes() : null;
            generator.init(passwordBytes, this.saltBytes, 1000);
            this.aesCipherParameters = generator.generateDerivedParameters(aesKeyBitLength);
            CipherParameters cipherParameters = generator.generateDerivedParameters(aesKeyBitLength * 2 + 16);
            byte[] keyBytes = ((KeyParameter)cipherParameters).getKey();
            this.cryptoKeyBytes = new byte[16];
            System.arraycopy(keyBytes, 0, this.cryptoKeyBytes, 0, 16);
            byte[] pwVerificationBytes = new byte[2];
            System.arraycopy(keyBytes, aesKeyBitLength / 8 * 2, pwVerificationBytes, 0, 2);
            return WinzipAesDecryptedZipInputStream.isEqual(pwVerificationBytes, this.passwordVerificationBytes);
        }
        return false;
    }

    @Override
    public int read() throws IOException {
        return this.baseInputStream.read();
    }

    private void setupInputStream(ZipArchiveEntry zipEntry, InputStream is) throws IOException {
        int bytesLeftToRead = (int)zipEntry.getCompressedSize() - 10;
        if (this.compressionType == 0) {
            bytesLeftToRead = (int)zipEntry.getSize();
        }
        this.baseInputStream = new WrappedWinzipAesDecryptedInputStream(bytesLeftToRead, is);
        if (this.compressionType != 0) {
            if (this.compressionType == 8) {
                this.baseInputStream = new InflaterInputStream(this.baseInputStream, new Inflater(true));
            } else {
                throw new IOException("Unhandled compression type: " + this.compressionType);
            }
        }
    }

    private class WrappedWinzipAesDecryptedInputStream
    extends InputStream {
        private static final int BUFFER_SIZE = 0xA00000;
        private final SICBlockCipher aesCipher = new SICBlockCipher((BlockCipher)new AESEngine());
        private ByteArrayInputStream bais = new ByteArrayInputStream(new byte[0]);
        private final int blockSize = this.aesCipher.getBlockSize();
        private byte[] buffer = null;
        private long bytesLeftToRead = 0L;
        final byte[] decryptedIn = new byte[this.blockSize];
        private InputStream ecnryptedInputStream = null;
        private int nonce = 1;

        public WrappedWinzipAesDecryptedInputStream(long bytesToRead, InputStream encryptedStream) {
            this.bytesLeftToRead = bytesToRead;
            this.ecnryptedInputStream = encryptedStream;
            this.nonce = 1;
            int bufSize = this.bytesLeftToRead > 0xA00000L ? 0xA00000 : (int)this.bytesLeftToRead;
            this.buffer = new byte[bufSize];
        }

        private void decipherNextBlock() throws IOException {
            if (this.bytesLeftToRead > 0L) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int len = this.bytesLeftToRead > (long)this.buffer.length ? this.buffer.length : (int)this.bytesLeftToRead;
                int read = this.ecnryptedInputStream.read(this.buffer, 0, len);
                for (int pos = 0; pos < this.buffer.length && pos < read; pos += this.blockSize) {
                    ParametersWithIV ivParams = new ParametersWithIV(WinzipAesDecryptedZipInputStream.this.aesCipherParameters, WinzipAesDecryptedZipInputStream.toByteArray(this.nonce++, 16));
                    this.aesCipher.init(false, (CipherParameters)ivParams);
                    int remainingCount = read - pos;
                    if (remainingCount >= this.blockSize) {
                        this.aesCipher.processBlock(this.buffer, pos, this.decryptedIn, 0);
                        System.arraycopy(this.decryptedIn, 0, this.buffer, pos, this.blockSize);
                        continue;
                    }
                    byte[] extendedIn = new byte[this.blockSize];
                    System.arraycopy(this.buffer, pos, extendedIn, 0, remainingCount);
                    this.aesCipher.processBlock(extendedIn, 0, this.decryptedIn, 0);
                    System.arraycopy(this.decryptedIn, 0, this.buffer, pos, remainingCount);
                }
                baos.write(this.buffer, 0, read);
                this.bais = new ByteArrayInputStream(baos.toByteArray());
                this.bytesLeftToRead -= (long)len;
            }
        }

        @Override
        public int read() throws IOException {
            int byteRead = this.bais.read();
            if (this.bytesLeftToRead > 0L && byteRead == -1) {
                this.decipherNextBlock();
                byteRead = this.bais.read();
            }
            return byteRead;
        }
    }
}

