/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.table;

import com.macrofocus.data.table.AbstractTableModel;
import java.util.ArrayList;
import java.util.List;
import org.odftoolkit.odfdom.doc.table.OdfTable;
import org.odftoolkit.odfdom.doc.table.OdfTableCell;
import org.odftoolkit.odfdom.dom.attribute.office.OfficeValueTypeAttribute;

public class ODFTableTableModel
extends AbstractTableModel {
    private OdfTable sheet;
    private List<Integer> columns;
    private List<Integer> rows;
    private List<String> names;
    private List<Class> classes;

    public ODFTableTableModel(OdfTable sheet) {
        this.sheet = sheet;
        try {
            int column;
            this.columns = new ArrayList<Integer>();
            this.rows = new ArrayList<Integer>();
            this.names = new ArrayList<String>();
            this.classes = new ArrayList<Class>();
            int columnCount = sheet.getColumnCount();
            int rowCount = sheet.getRowCount();
            long time = System.currentTimeMillis();
            for (column = 0; column < columnCount; ++column) {
                OdfTableCell cell = sheet.getCellByPosition(column, 0);
                if (cell == null || cell.getValueType() == OfficeValueTypeAttribute.Value.VOID.name()) continue;
                String name = cell.getDisplayText();
                if (name != null && !name.equals("")) {
                    this.names.add(name.toString());
                    this.columns.add(column);
                    this.classes.add(Object.class);
                    continue;
                }
                columnCount = column + 1;
                break;
            }
            for (int r = 1; r < rowCount; ++r) {
                boolean found = false;
                for (int column2 = 0; column2 < columnCount; ++column2) {
                    OdfTableCell cell = sheet.getCellByPosition(column2, r);
                    if (cell == null || cell.getValueType() == null || cell.getValueType() == OfficeValueTypeAttribute.Value.VOID.name()) continue;
                    String name = cell.getDisplayText();
                    this.rows.add(r);
                    found = true;
                    break;
                }
                if (found) continue;
                rowCount = r;
                break;
            }
            if (rowCount > 0) {
                for (column = 0; column < this.getColumnCount(); ++column) {
                    Object value;
                    int row;
                    Class<Object> cl = this.getColumnClass(column);
                    for (row = 0; row < rowCount; ++row) {
                        value = this.getValueAt(row, column);
                        if (value == null || value.equals("")) continue;
                        cl = value.getClass();
                        break;
                    }
                    for (row = 0; row < this.getRowCount(); ++row) {
                        value = this.getValueAt(row, column);
                        if (value == null || value.equals("") || value.getClass() == cl) continue;
                        cl = Object.class;
                        break;
                    }
                    this.classes.set(column, cl);
                }
            }
            this.autoConvert();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Class getColumnClass(int columnIndex) {
        return this.classes.get(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.names.get(columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        OdfTableCell cell = this.getCell(rowIndex, columnIndex);
        return this.getValue(columnIndex, cell);
    }

    private Object getValue(int columnIndex, OdfTableCell cell) {
        if (cell != null) {
            String type = cell.getValueType();
            if (type == OfficeValueTypeAttribute.Value.VOID.toString()) {
                return null;
            }
            if (type == OfficeValueTypeAttribute.Value.BOOLEAN.toString()) {
                return cell.getBooleanValue();
            }
            if (type == OfficeValueTypeAttribute.Value.FLOAT.toString()) {
                double d = cell.getDoubleValue();
                if (!Double.isInfinite(d)) {
                    if (this.classes.get(columnIndex) == Integer.class) {
                        return (int)d;
                    }
                    return d;
                }
                System.err.println(String.valueOf(cell) + " " + cell.getDoubleValue());
                return null;
            }
            if (type == OfficeValueTypeAttribute.Value.STRING.toString()) {
                String string = cell.getStringValue();
                if (string != null) {
                    return string.trim();
                }
                return null;
            }
            if (type == OfficeValueTypeAttribute.Value.DATE.toString()) {
                return cell.getDateValue();
            }
            return null;
        }
        return null;
    }

    private OdfTableCell getCell(int rowIndex, int columnIndex) {
        return this.sheet.getCellByPosition(this.columns.get(columnIndex).intValue(), this.rows.get(rowIndex).intValue());
    }

    private void autoConvert() {
        boolean fireEvent = false;
        for (int column = 0; column < this.getColumnCount(); ++column) {
            if (!this.isConvertableToInteger(column)) continue;
            this.convertToInteger(column);
        }
        if (fireEvent) {
            this.fireTableDataChanged();
        }
    }

    private void convertToInteger(int column) {
        this.classes.set(column, Integer.class);
    }

    private boolean isConvertableToInteger(int column) {
        Class type = this.getColumnClass(column);
        if (type != Integer.class && Number.class.isAssignableFrom(type)) {
            for (int row = 0; row < this.getRowCount(); ++row) {
                Number s;
                Object v = this.getValueAt(row, column);
                if (v == null || !(v instanceof Number ? (double)(s = (Number)v).intValue() != s.doubleValue() : !(v instanceof Integer))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

