/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.table;

import com.macrofocus.data.column.ColumnModel;
import com.macrofocus.data.column.MutableColumnModel;
import com.macrofocus.data.table.AbstractTableModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParsingException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class TreeMLTableModel
extends AbstractTableModel {
    private final List<String[]> paths;
    private final List<String> names;
    private final List<ColumnModel> columns;
    private final Map<String, MutableColumnModel> attributesToColumns;
    private int rowCount = 0;
    private final List<String> currentPath = new ArrayList<String>();

    Class parseType(String type) {
        if (((String)(type = Character.toUpperCase(((String)type).charAt(0)) + ((String)type).substring(1).toLowerCase())).equals("Int") || ((String)type).equals("Integer")) {
            return Integer.class;
        }
        if (((String)type).equals("Long")) {
            return Long.class;
        }
        if (((String)type).equals("Float")) {
            return Float.class;
        }
        if (((String)type).equals("Double") || ((String)type).equals("Real")) {
            return Double.class;
        }
        if (((String)type).equals("Boolean")) {
            return Boolean.class;
        }
        if (((String)type).equals("String")) {
            return String.class;
        }
        if (((String)type).equals("Date")) {
            return Date.class;
        }
        throw new RuntimeException("Unrecognized data type: " + (String)type);
    }

    void endElement(String namespaceURI, String localName, String qName) {
        if (qName.equals("branch")) {
            this.currentPath.remove(this.currentPath.size() - 1);
        }
    }

    void startElement(String namespaceURI, String localName, String qName, Element atts) {
        if (qName.equals("attributeDecl")) {
            String name = atts.getAttribute("name").getValue();
            String type = atts.getAttribute("type").getValue();
            Class t = this.parseType(type);
            MutableColumnModel columnModel = new MutableColumnModel(t, name);
            this.columns.add(columnModel);
            this.attributesToColumns.put(name, columnModel);
        } else if (qName.equals("branch") || qName.equals("leaf")) {
            for (MutableColumnModel columnModel : this.attributesToColumns.values()) {
                columnModel.addObject(null);
            }
            String nodeName = null;
            for (int i = 0; i < atts.getChildCount(); ++i) {
                Element element;
                Node child = atts.getChild(i);
                if (!(child instanceof Element) || !(element = (Element)child).getQualifiedName().equals("attribute")) continue;
                String name = null;
                String value = null;
                for (int j = 0; j < element.getAttributeCount(); ++j) {
                    Attribute attribute = element.getAttribute(j);
                    String alName = attribute.getQualifiedName();
                    if (alName.equals("name")) {
                        name = attribute.getValue();
                        continue;
                    }
                    if (!alName.equals("value")) continue;
                    value = attribute.getValue();
                }
                if (name == null || !name.equals("name") && nodeName != null || value == null) continue;
                nodeName = value;
                break;
            }
            String name = nodeName;
            if (!qName.equals("leaf")) {
                if (name != null) {
                    this.currentPath.add(name);
                } else {
                    this.currentPath.add(Integer.toString(this.rowCount));
                }
            }
            String[] p = new String[this.currentPath.size()];
            for (int i = 0; i < this.currentPath.size(); ++i) {
                String integer;
                p[i] = integer = this.currentPath.get(i);
            }
            this.paths.add(p);
            this.names.add(this.currentPath.get(this.currentPath.size() - 1));
            ++this.rowCount;
        } else if (qName.equals("attribute")) {
            this.parseAttribute(atts);
        }
    }

    void parseAttribute(Element atts) {
        String name = null;
        String value = null;
        for (int i = 0; i < atts.getAttributeCount(); ++i) {
            Attribute attribute = atts.getAttribute(i);
            String alName = attribute.getQualifiedName();
            if (alName.equals("name")) {
                name = attribute.getValue();
                continue;
            }
            if (!alName.equals("value")) continue;
            value = attribute.getValue();
        }
        if (name == null || value == null) {
            System.err.println("Attribute under-specified");
            return;
        }
        try {
            MutableColumnModel columnModel = this.attributesToColumns.get(name);
            columnModel.setObject(this.rowCount - 1, this.parseValue(value, columnModel.getMembership()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object parseValue(String value, Class type) {
        if (type.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (type == Integer.class) {
            return Integer.parseInt(value);
        }
        if (type == Double.class) {
            return Double.parseDouble(value);
        }
        if (type == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type == Long.class) {
            return Long.parseLong(value);
        }
        if (type == Boolean.class) {
            return Boolean.parseBoolean(value);
        }
        if (type == Date.class) {
            return Date.parse(value);
        }
        return null;
    }

    public TreeMLTableModel(InputStream is) throws IOException {
        this.columns = new ArrayList<ColumnModel>();
        this.paths = new ArrayList<String[]>();
        this.names = new ArrayList<String>();
        this.attributesToColumns = new HashMap<String, MutableColumnModel>();
        try {
            XMLReader xr = XMLReaderFactory.createXMLReader();
            final EntityResolver er = xr.getEntityResolver();
            xr.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    InputSource is = null;
                    if (er != null) {
                        is = er.resolveEntity(publicId, systemId);
                    }
                    if (is == null && systemId.endsWith("treeml.dtd")) {
                        is = new InputSource(TreeMLTableModel.class.getResourceAsStream("treeml.dtd"));
                    }
                    return is;
                }
            });
            Builder builder = new Builder(xr);
            Document doc = builder.build(is);
            Element root = doc.getRootElement();
            this.process((Node)root, 0);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParsingException e) {
            e.printStackTrace();
        }
    }

    void process(Node current, int depth) {
        if (current instanceof Element) {
            Element element = (Element)current;
            this.startElement(null, element.getLocalName(), element.getQualifiedName(), element);
        }
        for (int i = 0; i < current.getChildCount(); ++i) {
            this.process(current.getChild(i), depth + 1);
        }
        if (current instanceof Element) {
            Element element = (Element)current;
            this.endElement(null, element.getLocalName(), element.getQualifiedName());
        }
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String[].class;
            }
        }
        return this.columns.get(--columnIndex).getMembership();
    }

    @Override
    public int getColumnCount() {
        return this.columns.size() + 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Path";
            }
        }
        return this.columns.get(--columnIndex).getName().toString();
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.paths.get(rowIndex);
            }
        }
        return this.columns.get(--columnIndex).getObject(rowIndex);
    }

    public static interface Tokens {
        public static final String TREE = "tree";
        public static final String BRANCH = "branch";
        public static final String LEAF = "leaf";
        public static final String ATTR = "attribute";
        public static final String NAME = "name";
        public static final String VALUE = "value";
        public static final String TYPE = "type";
        public static final String DECLS = "declarations";
        public static final String DECL = "attributeDecl";
        public static final String INT = "Int";
        public static final String INTEGER = "Integer";
        public static final String LONG = "Long";
        public static final String FLOAT = "Float";
        public static final String REAL = "Real";
        public static final String STRING = "String";
        public static final String DATE = "Date";
        public static final String CATEGORY = "Category";
        public static final String BOOLEAN = "Boolean";
        public static final String DOUBLE = "Double";
    }
}

