/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.type.convert;

import com.macrofocus.common.convert.TypeConverter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class ToGeometryTypeConverter
implements TypeConverter {
    final String[] wktTypes = new String[]{"POINT", "LINESTRING", "LINEARRING", "POLYGON", "MULTIPOINT", "MULTILINESTRING", "MULTIPOLYGON", "GEOMETRYCOLLECTION"};

    public boolean isConvertable(TypeConverter.Input input) {
        try {
            if (!this.isAssignableFrom(Geometry.class, input.getType())) {
                boolean allNull = true;
                for (int row = 0; row < input.size(); ++row) {
                    Object v = input.get(row);
                    if (v == null) continue;
                    if (v instanceof String) {
                        String s = ((String)v).trim();
                        if (s.equals("")) continue;
                        allNull = false;
                        boolean parsed = false;
                        if (s.startsWith("SRID")) {
                            s = s.substring(s.indexOf(";") + 1);
                        }
                        boolean found = false;
                        for (String type : this.wktTypes) {
                            if (!s.startsWith(type)) continue;
                            found = true;
                        }
                        if (!found) {
                            return false;
                        }
                        try {
                            WKTReader reader = new WKTReader();
                            reader.read(s);
                            parsed = true;
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                        if (parsed) continue;
                        return false;
                    }
                    if (v instanceof Geometry) continue;
                    return false;
                }
                return !allNull;
            }
            return false;
        }
        catch (Error e) {
            return false;
        }
        catch (RuntimeException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Class convert(TypeConverter.Input input, TypeConverter.Output output) {
        for (int row = 0; row < input.size(); ++row) {
            Object v = input.get(row);
            if (v == null) continue;
            if (v instanceof String) {
                String s = ((String)v).trim();
                if (!s.equals("")) {
                    boolean parsed = false;
                    if (s.startsWith("SRID")) {
                        s = s.substring(s.indexOf(";") + 1);
                    }
                    boolean found = false;
                    for (String type : this.wktTypes) {
                        if (!s.startsWith(type)) continue;
                        found = true;
                    }
                    if (!found) {
                        output.set(row, null);
                    }
                    try {
                        WKTReader reader = new WKTReader();
                        output.set(row, (Object)reader.read(s));
                        parsed = true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (parsed) continue;
                    output.set(row, null);
                    continue;
                }
                output.set(row, null);
                continue;
            }
            if (v instanceof Geometry) continue;
            output.set(row, null);
        }
        return Geometry.class;
    }

    public Class getType() {
        return Geometry.class;
    }

    public boolean isAssignableFrom(Class a, Class b) {
        return b != null && (a == b || a == b.getSuperclass());
    }
}

