/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.writer;

import com.macrofocus.common.logging.Logging;
import com.macrofocus.data.DataModel;
import com.macrofocus.data.writer.DataWriter;
import java.io.BufferedWriter;
import java.io.IOException;

public class GenericDataWriter
implements DataWriter {
    private final BufferedWriter writer;
    private final String delim;
    private final boolean hasColumnHeader;
    private final boolean hasClassHeader;
    private final String missing;
    private int row;
    private int column;
    private int lineNumber;

    public GenericDataWriter(BufferedWriter writer, String delim, boolean hasColumnHeader, boolean hasClassHeader) {
        this(writer, delim, hasColumnHeader, hasClassHeader, "NaN");
    }

    public GenericDataWriter(BufferedWriter writer, String delim, boolean hasColumnHeader, boolean hasClassHeader, String missing) {
        this.writer = writer;
        this.delim = delim;
        this.hasColumnHeader = hasColumnHeader;
        this.hasClassHeader = hasClassHeader;
        this.row = -1;
        this.column = -1;
        this.lineNumber = -1;
        this.missing = missing;
    }

    @Override
    public void write(DataModel dataModel) {
        try {
            if (this.hasColumnHeader) {
                ++this.lineNumber;
                this.column = 0;
                while (this.column < dataModel.getColumnCount()) {
                    this.writeColumnName(dataModel.getColumnName(this.column));
                    if (this.column + 1 < dataModel.getColumnCount()) {
                        this.nextColumn();
                    }
                    ++this.column;
                }
                this.nextRow();
            }
            if (this.hasClassHeader) {
                ++this.lineNumber;
                this.column = 0;
                while (this.column < dataModel.getColumnCount()) {
                    this.writeClass(dataModel.getColumnClass(this.column));
                    if (this.column + 1 < dataModel.getColumnCount()) {
                        this.nextColumn();
                    }
                    ++this.column;
                }
                this.nextRow();
            }
            this.row = 0;
            while (this.row < dataModel.getRowCount()) {
                ++this.lineNumber;
                this.column = 0;
                while (this.column < dataModel.getColumnCount()) {
                    if (dataModel.isAvailable(this.row, this.column)) {
                        this.writeValue(dataModel.getValueAt(this.row, this.column), dataModel.getColumnClass(this.column));
                    } else {
                        this.writeNotAvailable();
                    }
                    if (this.column + 1 < dataModel.getColumnCount()) {
                        this.nextColumn();
                    }
                    ++this.column;
                }
                this.nextRow();
                ++this.row;
            }
        }
        catch (Exception e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    @Override
    public void writeColumnName(Object columnName) {
        try {
            if (columnName != null) {
                this.writer.write("\"" + columnName.toString() + "\"");
            }
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    @Override
    public void writeClass(Class cl) {
        String className = cl == null ? Object.class.getName() : cl.getName();
        if (className.startsWith("java.lang.")) {
            className = className.substring("java.lang.".length());
        } else if (className.equals("java.net.URL")) {
            className = "URL";
        }
        try {
            this.writer.write(className);
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    @Override
    public void writeValue(Object value, Class cl) {
        if (value == null) {
            this.writeNotAvailable();
        } else {
            try {
                this.writer.write(value.toString());
            }
            catch (IOException e) {
                Logging.getInstance().process((Throwable)e);
            }
        }
    }

    public void writeNotAvailable() {
        try {
            this.writer.write(this.missing);
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    @Override
    public void nextRow() {
        try {
            this.writer.newLine();
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    @Override
    public void nextColumn() {
        try {
            this.writer.write(this.delim);
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getRow() {
        return this.row;
    }

    @Override
    public int getColumn() {
        return this.column;
    }
}

