/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.ole.biff.record;

import com.macrofocus.util.ole.OleInputStream;
import com.macrofocus.util.ole.biff.record.AbstractRecordModel;
import com.macrofocus.util.ole.biff.record.ContinueRecordModel;
import java.util.Vector;

public class SstRecordModel
extends AbstractRecordModel {
    private int cstTotal;
    private int cstUnique;
    private int count;
    private String tmpString;
    private Vector rgb = new Vector();

    public SstRecordModel(int type, int dataLength, OleInputStream streamModel) {
        super(type, dataLength);
        int ap = streamModel.getReadCount();
        this.cstTotal = streamModel.getInteger();
        this.cstUnique = streamModel.getInteger();
        int position = streamModel.getReadCount();
        this.tmpString = null;
        while (dataLength != streamModel.getReadCount() - ap) {
            this.count = streamModel.getShort();
            int grbit = streamModel.getUnsignedByte();
            if (streamModel.getReadCount() - ap + this.count > dataLength) {
                this.tmpString = streamModel.getString(grbit, dataLength - (streamModel.getReadCount() - ap));
                this.count -= this.tmpString.length();
                continue;
            }
            String string = streamModel.getString(grbit, this.count);
            this.rgb.addElement(string);
        }
    }

    public int getCstTotal() {
        return this.cstTotal;
    }

    public int getCstUnique() {
        return this.cstUnique;
    }

    public String getRgb(int index) {
        if (index < this.getRgbCount()) {
            return (String)this.rgb.get(index);
        }
        return null;
    }

    public int getRgbCount() {
        return this.rgb.size();
    }

    public void process(ContinueRecordModel continueRecordModel) {
        OleInputStream streamModel = continueRecordModel.getStreamModel();
        int ap = streamModel.getReadCount();
        int dataLength = continueRecordModel.getDataLength();
        while (dataLength != streamModel.getReadCount() - ap) {
            if (this.tmpString == null) {
                this.count = streamModel.getShort();
            }
            int grbit = streamModel.getUnsignedByte();
            if (streamModel.getReadCount() - ap + this.count > dataLength) {
                this.tmpString = streamModel.getString(grbit, dataLength - (streamModel.getReadCount() - ap));
                this.count -= this.tmpString.length();
                continue;
            }
            Object string = streamModel.getString(grbit, this.count);
            if (this.tmpString != null) {
                string = this.tmpString + (String)string;
                this.tmpString = null;
            }
            this.rgb.addElement(string);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[type=" + Integer.toHexString(this.getType()) + "h,dataLength=" + this.getDataLength() + ",cstTotal=" + this.getCstTotal() + ",cstUnique=" + this.getCstUnique() + ",rgbCount=" + this.getRgbCount() + "]";
    }
}

